/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DigraphIteration;
import org.objectstyle.ashwood.graph.FilterArcIterator;
import org.objectstyle.ashwood.graph.GraphUtils;

public class FilterIteration
implements DigraphIteration,
Serializable {
    private DigraphIteration digraph;
    private Predicate acceptVertex;
    private Predicate acceptArc;

    public FilterIteration(DigraphIteration digraphIteration, Predicate predicate, Predicate predicate2) {
        this.digraph = digraphIteration;
        this.acceptVertex = predicate;
        this.acceptArc = predicate2;
    }

    public Iterator vertexIterator() {
        return IteratorUtils.filteredIterator(this.digraph.vertexIterator(), this.acceptVertex);
    }

    public ArcIterator arcIterator() {
        return new FilterArcIterator(this.digraph.arcIterator(), this.acceptVertex, this.acceptVertex, this.acceptArc);
    }

    public ArcIterator outgoingIterator(Object object) {
        if (!this.acceptVertex.evaluate(object)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new FilterArcIterator(this.digraph.outgoingIterator(object), GraphUtils.TRUE_PREDICATE, this.acceptVertex, this.acceptArc);
    }

    public ArcIterator incomingIterator(Object object) {
        if (!this.acceptVertex.evaluate(object)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new FilterArcIterator(this.digraph.incomingIterator(object), this.acceptVertex, GraphUtils.TRUE_PREDICATE, this.acceptArc);
    }
}

