/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecord;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gpdb.GpdbRecordSelectData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbFormData.class.getName());
    private ALStringField gpdb_name;
    private ALStringField mail_flg;
    private String gpdbId;
    private int userId;
    private static final String RECORD_LIST_FILTER_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("filter").toString();

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.gpdb_name = new ALStringField();
        this.gpdb_name.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_DATABASE_NAME"));
        this.gpdb_name.setTrim(true);
        this.mail_flg = new ALStringField();
        this.mail_flg.setFieldName(ALLocalizationUtils.getl10n((String)"GPDB_MAIL_NOTIFICATION"));
        this.mail_flg.setTrim(false);
        this.mail_flg.setValue("f");
    }

    protected void setValidator() {
        this.gpdb_name.setNotNull(true);
        this.gpdb_name.limitMaxLength(50);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            if (res && "update".equals(this.getMode())) {
                this.gpdbId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTGpdb.class);
            if ("insert".equals(this.getMode())) {
                query.setQualifier(ExpressionFactory.matchExp((String)"gpdbName", (Object)this.gpdb_name.getValue()));
            } else if ("update".equals(this.getMode())) {
                query.setQualifier(ExpressionFactory.matchExp((String)"gpdbName", (Object)this.gpdb_name.getValue()));
                query.andQualifier(ExpressionFactory.noMatchDbExp((String)"GPDB_ID", (Object)Integer.valueOf(this.gpdbId)));
            }
            if (!query.fetchList().isEmpty()) {
                msgList.add("Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u300e <span class='em'>" + this.gpdb_name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        this.gpdb_name.validate(msgList);
        this.mail_flg.validate(msgList);
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTGpdb gpdb = GpdbUtils.getEipTGpdb(rundata, context);
            if (gpdb == null) {
                return false;
            }
            this.gpdb_name.setValue(gpdb.getGpdbName());
            this.mail_flg.setValue(gpdb.getMailFlg());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.userId);
            EipTGpdb gpdb = (EipTGpdb)Database.create(EipTGpdb.class);
            gpdb.setGpdbName(this.gpdb_name.getValue());
            gpdb.setMailFlg(this.mail_flg.getValue());
            gpdb.setTurbineUser(tuser);
            gpdb.setCreateDate(Calendar.getInstance().getTime());
            gpdb.setUpdateDate(Calendar.getInstance().getTime());
            EipTGpdbItem gpdbItem = (EipTGpdbItem)Database.create(EipTGpdbItem.class);
            gpdbItem.setGpdb(gpdb);
            gpdbItem.setGpdbItemName("\u30bf\u30a4\u30c8\u30eb");
            gpdbItem.setType("01");
            gpdbItem.setTitleFlg("t");
            gpdbItem.setRequiredFlg("t");
            gpdbItem.setSizeCol(Integer.valueOf(300));
            gpdbItem.setListFlg("t");
            gpdbItem.setDetailFlg("t");
            gpdbItem.setDefaultSortFlg("f");
            gpdbItem.setOrderNo(Integer.valueOf(1));
            gpdbItem.setTurbineUser(tuser);
            gpdbItem.setCreateDate(Calendar.getInstance().getTime());
            gpdbItem.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdb.getGpdbId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + gpdb.getGpdbName() + "\u300d \u8ffd\u52a0");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)RECORD_LIST_FILTER_STR, (String)gpdb.getGpdbId().toString());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTGpdb gpdb = GpdbUtils.getEipTGpdb(rundata, context);
            if (gpdb == null) {
                return false;
            }
            gpdb.setGpdbName(this.gpdb_name.getValue());
            gpdb.setMailFlg(this.mail_flg.getValue());
            gpdb.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdb.getGpdbId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + gpdb.getGpdbName() + "\u300d \u66f4\u65b0");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTGpdb gpdb = GpdbUtils.getEipTGpdb(rundata, context);
            if (gpdb == null) {
                return false;
            }
            List<EipTGpdbRecord> listRecord = GpdbUtils.getEipTGpdbRecord("" + gpdb.getGpdbId());
            if (listRecord != null && !listRecord.isEmpty()) {
                msgList.add("\u30c7\u30fc\u30bf\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            GpdbUtils.removeGpdbItem(gpdb);
            Database.delete((Persistent)gpdb);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdb.getGpdbId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + gpdb.getGpdbName() + "\u300d \u524a\u9664");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getGpdbName() {
        return this.gpdb_name;
    }

    public ALStringField getMailFlg() {
        return this.mail_flg;
    }
}

