/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbItem;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbItemMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbItemMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTGpdbItem.class);
            query.setQualifier(ExpressionFactory.inDbExp((String)"GPDB_ITEM_ID", values));
            List gpdbItemList = query.fetchList();
            if (gpdbItemList == null || gpdbItemList.isEmpty()) {
                return false;
            }
            for (EipTGpdbItem gpdbItem : gpdbItemList) {
                if (!"t".equals(gpdbItem.getTitleFlg())) continue;
                msgList.add("\u30bf\u30a4\u30c8\u30eb\u6307\u5b9a\u3055\u308c\u305f\u9805\u76ee\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            if (msgList.isEmpty()) {
                EipTGpdb gpdb = GpdbUtils.getEipTGpdb(rundata.getParameters().getString("gpdb_id"));
                for (EipTGpdbItem gpdbItem : gpdbItemList) {
                    GpdbUtils.removeGpdbRecord(rundata, gpdbItem);
                    Database.delete((Persistent)gpdbItem);
                    Database.commit();
                    ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdbItem.getGpdbItemId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + gpdb.getGpdbName() + "\u300d \u9805\u76ee\u5b9a\u7fa9 \u300c" + gpdbItem.getGpdbItemName() + "\u300d \u524a\u9664");
                }
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }
}

