/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecord;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.gpdb.GpdbItemResultData;
import com.aimluck.eip.gpdb.GpdbKubunValueResultData;
import com.aimluck.eip.gpdb.GpdbRecordResultData;
import com.aimluck.eip.gpdb.GpdbRecordSelectData;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbRecordFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbRecordFormData.class.getName());
    private static final String LIST_FILTER_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("filter").toString();
    private static final String FIELD_PREFIX = "field_";
    private List<GpdbItemResultData> gpdbItemList;
    private Map<String, GpdbRecordResultData> mapGpdbRecord;
    private Map<String, List<GpdbKubunValueResultData>> mapGpdbKubunValue;
    private String gpdbId;
    private EipTGpdb gpdb;
    private RunData rundata;
    private Context context;
    private String folderName = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.rundata = rundata;
        this.context = context;
        this.gpdbId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)LIST_FILTER_STR);
        if (this.gpdbId != null && !"".equals(this.gpdbId)) {
            this.gpdb = GpdbUtils.getEipTGpdb(this.gpdbId);
            this.gpdbItemList = GpdbUtils.getGpdbItemResultList(this.gpdbId);
        }
        this.mapGpdbKubunValue = GpdbUtils.getKubunMap();
    }

    public void initField() {
    }

    protected void setValidator() {
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        return res;
    }

    protected boolean validate(List<String> msgList) {
        try {
            for (GpdbItemResultData item : this.gpdbItemList) {
                String field = FIELD_PREFIX + item.getGpdbItemId();
                String type = item.getType().getValue();
                String value = null;
                if ("08".equals(type) || "13".equals(type) || "14".equals(type) || "11".equals(type) || "12".equals(type)) continue;
                if ("05".equals(type)) {
                    value = GpdbUtils.getParamValueString(this.rundata, field);
                } else if ("06".equals(type) || "07".equals(type)) {
                    List<FileuploadLiteBean> fileuploadList = GpdbUtils.getFileuploadList(this.rundata, item.getGpdbItemId().toString());
                    if (fileuploadList != null && !fileuploadList.isEmpty()) {
                        value = fileuploadList.get(0).getFileName();
                    }
                } else {
                    value = ALEipUtils.getParameter((RunData)this.rundata, (Context)this.context, (String)field);
                }
                if ("t".equals(item.getRequiredFlg().getValue())) {
                    String dateYear;
                    if (value == null || "".equals(value.trim())) {
                        msgList.add("\u300e <span class='em'>" + item.getGpdbItemName() + "</span> \u300f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    } else if ("10".equals(type) && ((dateYear = ALEipUtils.getParameter((RunData)this.rundata, (Context)this.context, (String)(field + "_year"))) == null || "".equals(dateYear.trim()))) {
                        msgList.add("\u300e <span class='em'>" + item.getGpdbItemName() + "</span> \u300f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                }
                if ("09".equals(type)) {
                    if (value == null || value.trim().length() <= 0 || ALStringUtil.isMailAddress((String)value)) continue;
                    msgList.add("\u300e <span class='em'>" + item.getGpdbItemName() + " </span>\u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    continue;
                }
                if (!"03".equals(type) || value == null || value.trim().length() <= 0 || GpdbUtils.isUrl(value)) continue;
                msgList.add("\u300e <span class='em'>" + item.getGpdbItemName() + "</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            this.mapGpdbRecord = GpdbUtils.getGpdbRecordMap(this.gpdbId, ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            for (GpdbItemResultData item : this.gpdbItemList) {
                String type = item.getType().getValue();
                if (!"06".equals(type) && !"07".equals(type)) continue;
                GpdbRecordResultData data = this.mapGpdbRecord.get("" + item.getGpdbItemId().getValue());
                data.setAttachmentFiles(GpdbUtils.getAttachmentFiles((int)data.getGpdbRecordId().getValue()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)ALEipUtils.getUserId((RunData)rundata));
            SelectQuery query = Database.query(EipTGpdbRecord.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"gpdb", (Object)this.gpdbId));
            query.orderDesending("recordNo");
            EipTGpdbRecord maxRecordNoObj = (EipTGpdbRecord)query.fetchSingle();
            int recordNo = 1;
            if (maxRecordNoObj != null) {
                recordNo = maxRecordNoObj.getRecordNo() + 1;
            }
            String mailGpdbItemName = "";
            String mailDispValue = "";
            for (GpdbItemResultData item : this.gpdbItemList) {
                String value;
                String field = FIELD_PREFIX + item.getGpdbItemId();
                String type = item.getType().getValue();
                EipTGpdbRecord gpdbRecord = (EipTGpdbRecord)Database.create(EipTGpdbRecord.class);
                if ("05".equals(type)) {
                    value = GpdbUtils.getParamValueString(rundata, field);
                } else if ("08".equals(type)) {
                    SelectQuery querySeq = Database.query(EipTGpdbRecord.class);
                    querySeq.setQualifier(ExpressionFactory.matchExp((String)"gpdbItem", (Object)item.getGpdbItemId().getValue()));
                    querySeq.orderDesending("recordNo");
                    EipTGpdbRecord maxSeqObj = (EipTGpdbRecord)querySeq.fetchSingle();
                    int seqNo = 1;
                    if (maxSeqObj != null && maxSeqObj.getValue() != null) {
                        try {
                            seqNo = Integer.valueOf(maxSeqObj.getValue()) + 1;
                        }
                        catch (Exception e) {
                            seqNo = 1;
                        }
                    }
                    value = "" + seqNo;
                } else if ("06".equals(type) || "07".equals(type)) {
                    List<FileuploadLiteBean> fileuploadList = GpdbUtils.getFileuploadList(rundata, item.getGpdbItemId().toString());
                    this.folderName = rundata.getParameters().getString("folderName_" + item.getGpdbItemId().toString());
                    if (!GpdbUtils.insertFileDataDelegate(rundata, context, gpdbRecord, fileuploadList, this.folderName, msgList)) {
                        return false;
                    }
                    StringBuilder sb = new StringBuilder();
                    if (fileuploadList != null) {
                        for (FileuploadLiteBean bean : fileuploadList) {
                            if (sb.length() > 0) {
                                sb.append("|");
                            }
                            sb.append(bean.getFileName());
                        }
                    }
                    value = sb.toString();
                } else if ("13".equals(type) || "14".equals(type)) {
                    value = ALEipUtils.getALEipUser((RunData)rundata).getUserId().getValueAsString();
                } else if ("11".equals(type) || "12".equals(type)) {
                    ALDateTimeField dt = new ALDateTimeField();
                    dt.setValue(Calendar.getInstance().getTime());
                    value = dt.toStringDateTime();
                } else {
                    String dateYear;
                    value = "10".equals(type) ? ((dateYear = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)(field + "_year"))) == null || "".equals(dateYear.trim()) ? "" : ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)field)) : ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)field);
                }
                gpdbRecord.setGpdb(this.gpdb);
                gpdbRecord.setGpdbItem(GpdbUtils.getEipTGpdbItem(item.getGpdbItemId().getValueAsString()));
                gpdbRecord.setRecordNo(Integer.valueOf(recordNo));
                gpdbRecord.setValue(value);
                gpdbRecord.setTurbineUser(tuser);
                gpdbRecord.setUpdateUserId(tuser.getUserId());
                gpdbRecord.setCreateDate(Calendar.getInstance().getTime());
                gpdbRecord.setUpdateDate(Calendar.getInstance().getTime());
                if (!"t".equals(item.getTitleFlg().toString())) continue;
                mailGpdbItemName = item.getRawGpdbItemName();
                mailDispValue = value;
            }
            Database.commit();
            if ("t".equals(this.gpdb.getMailFlg())) {
                ALEipUser createUser = ALEipUtils.getALEipUser((int)this.gpdb.getTurbineUser().getUserId());
                GpdbUtils.sendMail(rundata, createUser, this.gpdb, mailGpdbItemName, mailDispValue);
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(recordNo, 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + this.gpdb.getGpdbName() + "\u300d \u30c7\u30fc\u30bf\u8ffd\u52a0");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)ALEipUtils.getUserId((RunData)rundata));
            String recordNo = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            for (GpdbItemResultData item : this.gpdbItemList) {
                String value;
                String field = FIELD_PREFIX + item.getGpdbItemId();
                String type = item.getType().getValue();
                EipTGpdbRecord gpdbRecord = GpdbUtils.getEipTGpdbRecord(this.gpdbId, recordNo, item.getGpdbItemId().toString());
                if ("05".equals(type)) {
                    value = GpdbUtils.getParamValueString(rundata, field);
                } else if ("06".equals(type) || "07".equals(type)) {
                    List<FileuploadLiteBean> fileuploadList = GpdbUtils.getFileuploadList(rundata, item.getGpdbItemId().toString());
                    this.folderName = rundata.getParameters().getString("folderName_" + item.getGpdbItemId().toString());
                    if (!GpdbUtils.insertFileDataDelegate(rundata, context, gpdbRecord, fileuploadList, this.folderName, msgList)) {
                        return false;
                    }
                    StringBuilder sb = new StringBuilder();
                    if (fileuploadList != null) {
                        for (FileuploadLiteBean bean : fileuploadList) {
                            if (sb.length() > 0) {
                                sb.append("|");
                            }
                            sb.append(bean.getFileName());
                        }
                    }
                    value = sb.toString();
                } else if ("14".equals(type)) {
                    value = ALEipUtils.getALEipUser((RunData)rundata).getUserId().getValueAsString();
                } else if ("12".equals(type)) {
                    ALDateTimeField dt = new ALDateTimeField();
                    dt.setValue(Calendar.getInstance().getTime());
                    value = dt.toStringDateTime();
                } else {
                    String dateYear;
                    value = "10".equals(type) ? ((dateYear = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)(field + "_year"))) == null || "".equals(dateYear.trim()) ? "" : ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)field)) : ("08".equals(type) || "13".equals(type) || "11".equals(type) ? gpdbRecord.getValue() : ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)field));
                }
                gpdbRecord.setValue(value);
                gpdbRecord.setUpdateUserId(tuser.getUserId());
                gpdbRecord.setUpdateDate(Calendar.getInstance().getTime());
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(Integer.valueOf(recordNo).intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + this.gpdb.getGpdbName() + "\u300d \u30c7\u30fc\u30bf\u66f4\u65b0");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String recordNo = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            List<EipTGpdbRecord> gpdbRecordList = GpdbUtils.getEipTGpdbRecord(this.gpdbId, recordNo);
            Database.deleteAll(gpdbRecordList);
            GpdbUtils.removeGpdbRecordFile(rundata, gpdbRecordList);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(Integer.valueOf(recordNo).intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + this.gpdb.getGpdbName() + "\u300d \u30c7\u30fc\u30bf\u524a\u9664");
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public List<GpdbItemResultData> getGpdbItemList() {
        return this.gpdbItemList;
    }

    public GpdbRecordResultData getRecordResult(String gpdbItemId) {
        if (this.mapGpdbRecord == null) {
            return null;
        }
        return this.mapGpdbRecord.get(gpdbItemId);
    }

    public List<GpdbKubunValueResultData> getKubunValueList(String kubunId) {
        return this.mapGpdbKubunValue.get(kubunId);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public EipTGpdb getGpdb() {
        return this.gpdb;
    }
}

