/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileio.beans.ScheduleCsvUser;
import com.aimluck.eip.fileio.util.FileIOScheduleCsvUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOScheduleCsvFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOScheduleCsvFormData.class.getName());
    public static final String DEFAULT_VIEW_PASSWORD = "*";
    private ALStringField username;
    private ALStringField userfullname;
    private List<ScheduleCsvUser> userList;
    private ALStringField schedulename;
    private ALStringField place;
    private ALStringField note;
    private ALDateTimeField create_date;
    private ALDateTimeField start_date;
    private ALDateTimeField end_date;
    private ALDateTimeField start_time;
    private ALDateTimeField end_time;
    private ALDateTimeField start_date_time;
    private ALDateTimeField end_date_time;
    private boolean is_auto_time;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.username = new ALStringField();
        this.username.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_USER_NAME"));
        this.username.setTrim(true);
        this.userfullname = new ALStringField();
        this.userfullname.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_LOGIN_ID"));
        this.userfullname.setTrim(true);
        this.schedulename = new ALStringField();
        this.schedulename.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_SCHEDULE"));
        this.schedulename.setTrim(true);
        this.schedulename.setValue("");
        this.place = new ALStringField();
        this.place.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_PLACE"));
        this.place.setTrim(true);
        this.place.setValue("");
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_CONTENTS"));
        this.note.setTrim(true);
        this.note.setValue("");
        this.create_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.create_date.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_INPUT_DATE"));
        this.create_date.setValue("");
        this.start_date = new ALDateTimeField("yyyy/MM/dd");
        this.start_date.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_BEGINNING_DAY"));
        this.end_date = new ALDateTimeField("yyyy/MM/dd");
        this.end_date.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_ENDING_DAY"));
        this.start_time = new ALDateTimeField("HH:mm");
        this.start_time.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_BEGINNING_TIME"));
        this.end_time = new ALDateTimeField("HH:mm");
        this.end_time.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_ENDING_TIME"));
        this.start_date_time = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.start_date_time.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_BEGINNING_DATE"));
        this.end_date_time = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.end_date_time.setFieldName(ALLocalizationUtils.getl10n((String)"FILEIO_ENDING_DATE"));
        this.start_date_time.setValue("");
        this.end_date_time.setValue("");
        this.start_date.setValue("");
        this.end_date.setValue("");
        this.start_time.setValue("");
        this.end_time.setValue("");
        this.is_auto_time = false;
        this.userList = new ArrayList<ScheduleCsvUser>();
    }

    protected void setValidator() {
        this.schedulename.setNotNull(true);
        this.schedulename.limitMaxLength(50);
        this.place.limitMaxLength(50);
        this.note.limitMaxLength(1000);
        this.start_date.setNotNull(true);
        this.end_date.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) {
        String usernamestr;
        if (this.start_time.toString().equals("")) {
            this.setStartTime("00:00");
        }
        if (this.end_time.toString().equals("")) {
            this.setEndTime("00:00");
        }
        if ("admin".equals(usernamestr = this.username.getValue()) || "template".equals(usernamestr) || "anon".equals(usernamestr) || !this.username.validate(msgList)) {
            this.username.setValue(null);
        }
        if (!this.userfullname.validate(msgList)) {
            this.userfullname.setValue(null);
        }
        for (ScheduleCsvUser user : this.userList) {
            if (!user.getName().validate(msgList)) {
                user.setName(null);
            }
            if (!user.getFirstName().validate(msgList)) {
                user.setFirstName(null);
            }
            if (user.getLastName().validate(msgList)) continue;
            user.setLastName(null);
        }
        if (!this.schedulename.validate(msgList)) {
            this.schedulename.setValue(null);
        }
        if (!this.place.validate(msgList)) {
            this.place.setValue(null);
        }
        if (!this.note.validate(msgList)) {
            this.note.setValue(null);
        }
        if (!this.create_date.validate(msgList)) {
            Date now = new Date();
            this.create_date.setValue(now);
        }
        if (!this.start_date.validate(msgList)) {
            this.start_date.setValue("");
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_BEGINNING_DAY_NOT_CORRECT"));
        }
        if (!this.end_date.validate(msgList)) {
            this.end_date.setValue("");
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_ENDING_DAY_NOT_CORRECT"));
        }
        if (this.start_time.toString().equals("") && !this.end_time.toString().equals("")) {
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_BEGINNING_TIME_NOT_CORRECT"));
        }
        if (!this.start_time.toString().equals("") && this.end_time.toString().equals("")) {
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_ENDING_TIME_NOT_CORRECT"));
        }
        if (!FileIOScheduleCsvUtils.checkDateAcross(this.start_date, this.start_time, this.end_date, this.end_time)) {
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_NO_MULTI_DATE"));
        }
        if (!this.start_time.validate(msgList)) {
            this.start_time.setValue("");
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_BEGINNING_TIME_NOT_CORRECT"));
        }
        if (!this.end_time.validate(msgList)) {
            this.end_time.setValue("");
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_ENDING_TIME_NOT_CORRECT"));
        }
        try {
            this.getStartDateTime();
            this.getEndDateTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.start_date_time.validate(msgList)) {
            this.start_date_time.setValue("");
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_BEGINNING_DATE_NOT_CORRECT"));
        }
        if (!this.end_date_time.validate(msgList)) {
            this.end_date_time.setValue("");
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_ENDING_DATE_NOT_CORRECT"));
        }
        if (!this.end_date_time.toString().equals("") && !this.start_date_time.toString().equals("") && this.end_date_time.getValue().before(this.start_date_time.getValue())) {
            msgList.add(ALLocalizationUtils.getl10n((String)"FILEIO_DATE_NOT_CORRECT"));
            this.start_date.setValue("");
            this.end_date.setValue("");
            this.start_time.setValue("");
            this.end_time.setValue("");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int size = this.userList.size();
            if (size == 0) {
                msgList.add("user does not exists.");
                return false;
            }
            GregorianCalendar startcal = new GregorianCalendar();
            startcal.setTime(this.start_date_time.getValue());
            Calendar endcal = Calendar.getInstance();
            endcal.setTime(this.end_date_time.getValue());
            EipTSchedule schedule = (EipTSchedule)Database.create(EipTSchedule.class);
            schedule.setParentId(Integer.valueOf(1));
            schedule.setName(this.schedulename.getValue());
            schedule.setPlace(this.place.getValue());
            schedule.setNote(this.note.getValue());
            schedule.setPublicFlag("O");
            schedule.setEditFlag("T");
            Date now = new Date();
            schedule.setCreateDate(now);
            schedule.setUpdateDate(now);
            schedule.setStartDate(this.start_date_time.getValue());
            schedule.setEndDate(this.end_date_time.getValue());
            if (FileIOScheduleCsvUtils.isSpan(this.start_date_time, this.end_date_time)) {
                schedule.setRepeatPattern("S");
            } else {
                schedule.setRepeatPattern("N");
            }
            schedule.setMailFlag("A");
            EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
            for (int i = 0; i < size; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                ScheduleCsvUser user = this.userList.get(i);
                int userid = (int)user.getUserId().getValue();
                if (i == 0) {
                    map.setStatus("O");
                    schedule.setOwnerId(Integer.valueOf(userid));
                    schedule.setCreateUserId(Integer.valueOf(userid));
                    schedule.setUpdateUserId(Integer.valueOf(userid));
                } else {
                    map.setStatus("T");
                }
                map.setEipTSchedule(schedule);
                map.setUserId(Integer.valueOf(userid));
                map.setCommonCategoryId(Integer.valueOf(1));
                map.setEipTCommonCategory(category);
                map.setType("U");
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[FileIOScheduleCsvFormData]", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public ALStringField getUserFullName() {
        return this.userfullname;
    }

    public ALStringField getScheduleName() {
        return this.schedulename;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getPlace() {
        return this.place;
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public ALDateTimeField getStartDate() {
        return this.start_date;
    }

    public ALDateTimeField getEndDate() {
        return this.end_date;
    }

    public ALDateTimeField getStartTime() {
        return this.start_time;
    }

    public ALDateTimeField getEndTime() {
        return this.end_time;
    }

    public ALDateTimeField getStartDateTime() {
        Calendar cal = Calendar.getInstance();
        if ("".equals(this.start_date_time.toString())) {
            cal.set(1, Integer.parseInt(this.start_date.getYear()));
            cal.set(2, Integer.parseInt(this.start_date.getMonth()) - 1);
            cal.set(5, Integer.parseInt(this.start_date.getDay()));
            cal.set(11, Integer.parseInt(this.start_time.getHour()));
            cal.set(12, Integer.parseInt(this.start_time.getMinute()));
            Date date = cal.getTime();
            this.start_date_time.setValue(date);
        }
        return this.start_date_time;
    }

    public ALDateTimeField getEndDateTime() {
        Calendar cal = Calendar.getInstance();
        if ("".equals(this.end_date_time.toString())) {
            cal.set(1, Integer.parseInt(this.end_date.getYear()));
            cal.set(2, Integer.parseInt(this.end_date.getMonth()) - 1);
            cal.set(5, Integer.parseInt(this.end_date.getDay()));
            cal.set(11, Integer.parseInt(this.end_time.getHour()));
            cal.set(12, Integer.parseInt(this.end_time.getMinute()));
            Date date = cal.getTime();
            this.end_date_time.setValue(date);
        }
        return this.end_date_time;
    }

    public void setUserName(String str) {
        this.username.setValue(str);
    }

    public void setUserFullName(String str) {
        this.userfullname.setValue(str);
    }

    public void setScheduleName(String str) {
        this.schedulename.setValue(str);
    }

    public void setNote(String str) {
        this.note.setValue(str);
    }

    public void setPlace(String str) {
        this.place.setValue(str);
    }

    public void setCreateDate(String str) {
        this.create_date.setValue(str);
    }

    public void setStartDate(String str) {
        this.start_date.setValue(str);
    }

    public void setEndDate(String str) {
        this.end_date.setValue(str);
    }

    public void setStartTime(String str) {
        this.start_time.setValue(str);
    }

    public void setEndTime(String str) {
        this.end_time.setValue(str);
    }

    public void setStartDateTime(String str) {
        this.start_date_time.setValue(str);
    }

    public void setEndDateTime(String str) {
        this.end_date_time.setValue(str);
    }

    public void setCreateDate(Date date) {
        this.create_date.setValue(date);
    }

    public void setStartDate(Date date) {
        this.start_date.setValue(date);
    }

    public void setEndDate(Date date) {
        this.end_date.setValue(date);
    }

    public void setStartTime(Date date) {
        this.start_time.setValue(date);
    }

    public void setEndTime(Date date) {
        this.end_time.setValue(date);
    }

    public void setStartDate_Time(Date date) {
        this.start_date_time.setValue(date);
    }

    public void setEndDateTime(Date date) {
        this.end_date_time.setValue(date);
    }

    public void setIsAutoTime(String flag) {
        this.is_auto_time = Integer.parseInt(flag) == 1;
    }

    public void addItemToken(String token, int i) {
        switch (i) {
            case -1: {
                break;
            }
            case 0: {
                this.setUserFullName(token);
                break;
            }
            case 1: {
                this.setScheduleName(token);
                break;
            }
            case 2: {
                this.setPlace(token);
                break;
            }
            case 3: {
                this.setNote(token);
                break;
            }
            case 4: {
                this.setStartDate(token);
                break;
            }
            case 5: {
                this.setEndDate(token);
                break;
            }
            case 6: {
                this.setStartTime(token);
                break;
            }
            case 7: {
                this.setEndTime(token);
                break;
            }
            case 8: {
                this.setUserName(token);
                break;
            }
            case 9: {
                this.setStartDateTime(token);
                break;
            }
            case 10: {
                this.setEndDateTime(token);
                break;
            }
        }
    }

    public void adjust() {
        if (!this.username.getValue().equals("")) {
            this.parseLoginName();
        } else {
            this.parseUserName();
        }
    }

    private void parseUserName() {
        String[] value;
        for (String rawName : value = this.userfullname.getValue().split(",")) {
            ScheduleCsvUser user = new ScheduleCsvUser();
            user.parseFullName(rawName);
            this.userList.add(user);
        }
    }

    private void parseLoginName() {
        String[] value;
        for (String rawName : value = this.username.getValue().split(",")) {
            ScheduleCsvUser user = new ScheduleCsvUser();
            user.setName(rawName.trim());
            this.userList.add(user);
        }
    }

    public void adjustUser(List<String> errmsg) {
        try {
            for (ScheduleCsvUser user : this.userList) {
                user.complement();
            }
        }
        catch (Exception e) {
            errmsg.add("user not found");
        }
    }

    public String getUserNameString() {
        StringBuffer buf = new StringBuffer();
        for (ScheduleCsvUser user : this.userList) {
            buf.append(user.getAliasName());
            buf.append(", ");
        }
        String result = buf.toString();
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public String getLoginNameString() {
        StringBuffer buf = new StringBuffer();
        for (ScheduleCsvUser user : this.userList) {
            buf.append(user.getName());
            buf.append(", ");
        }
        String result = buf.toString();
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }
}

