/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.bsf;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.bsf.BSFService;

public class TurbineBSFService
extends BaseService
implements BSFService {
    protected BSFManager manager;
    protected String scriptsDirectory;
    protected static final String SCRIPTS_DIRECTORY = "scriptsDirectory";
    protected String defaultExtension;
    protected static final String DEFAULT_EXTENSION = "defaultExtension";

    public void init() throws InitializationException {
        this.scriptsDirectory = this.getConfiguration().getString(SCRIPTS_DIRECTORY);
        if (this.scriptsDirectory == null) {
            throw new InitializationException("You must provide a scripts directory in order to executes scripts!");
        }
        this.defaultExtension = this.getConfiguration().getString(DEFAULT_EXTENSION);
        this.initBSFManagers();
        this.setInit(true);
    }

    private void initBSFManagers() {
        this.manager = new BSFManager();
    }

    public void execute(String string) {
        if (string.lastIndexOf(46) == -1) {
            string = string + '.' + this.defaultExtension;
        }
        string = this.getRealPath(this.scriptsDirectory + "/" + string);
        this.getCategory().debug((Object)("[BSFService] Script to execute: " + string));
        try {
            this.manager.exec(BSFManager.getLangFromFilename((String)string), string, 0, 0, (Object)this.fileContentsToString(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BSFException bSFException) {
            int n = bSFException.getReason();
            bSFException.printStackTrace();
        }
    }

    protected String fileContentsToString(String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = bufferedReader.read(cArray, 0, 1024)) != -1) {
            stringWriter.write(cArray, 0, n);
        }
        return stringWriter.toString();
    }
}

