/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.TurbineIntake;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FieldFactory;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.apache.fulcrum.util.parser.ValueParser;
import org.apache.log4j.Category;

public class Group {
    public static final String EMPTY = "";
    public static final String NEW = "_0";
    private static final Category log = Category.getInstance((String)(class$org$apache$fulcrum$intake$model$Group == null ? (class$org$apache$fulcrum$intake$model$Group = Group.class$("org.apache.fulcrum.intake.model.Group")) : class$org$apache$fulcrum$intake$model$Group).getName());
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    protected final String gid;
    protected final String name;
    private final int poolCapacity;
    protected Map fields;
    protected Map mapToObjectFields;
    protected Field[] fieldsArray;
    protected String oid;
    protected ValueParser pp;
    protected boolean isDeclared;
    static /* synthetic */ Class class$org$apache$fulcrum$intake$model$Group;

    public Group(XmlGroup xmlGroup) throws Exception {
        ArrayList<Field> arrayList;
        Field field;
        Object object;
        this.gid = xmlGroup.getKey();
        this.name = xmlGroup.getName();
        this.poolCapacity = Integer.parseInt(xmlGroup.getPoolCapacity());
        List list = xmlGroup.getFields();
        int n = list.size();
        this.fields = new HashMap((int)(1.25 * (double)n + 1.0));
        this.mapToObjectFields = new HashMap((int)(1.25 * (double)n + 1.0));
        this.fieldsArray = new Field[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            object = (XmlField)list.get(n2);
            this.fieldsArray[n2] = field = FieldFactory.getInstance((XmlField)object, this);
            this.fields.put(((XmlField)object).getName(), field);
            arrayList = (List)this.mapToObjectFields.get(((XmlField)object).getMapToObject());
            if (arrayList == null) {
                arrayList = new ArrayList<Field>(n);
                this.mapToObjectFields.put(((XmlField)object).getMapToObject(), arrayList);
            }
            arrayList.add(field);
            --n2;
        }
        object = this.mapToObjectFields.keySet().iterator();
        while (object.hasNext()) {
            field = object.next();
            arrayList = (ArrayList<Field>)this.mapToObjectFields.get(field);
            this.mapToObjectFields.put(field, arrayList.toArray(new Field[arrayList.size()]));
        }
    }

    public Group init(ValueParser valueParser) throws ServiceException {
        return this.init(NEW, valueParser);
    }

    public Group init(String string, ValueParser valueParser) throws ServiceException {
        this.oid = string;
        this.pp = valueParser;
        int n = this.fieldsArray.length - 1;
        while (n >= 0) {
            this.fieldsArray[n].init(valueParser);
            --n;
        }
        return this;
    }

    public Group init(Retrievable retrievable) {
        this.oid = retrievable.getQueryKey();
        Class<?> clazz = retrievable.getClass();
        while (clazz != null) {
            Field[] fieldArray = (Field[])this.mapToObjectFields.get(clazz.getName());
            if (fieldArray != null) {
                int n = fieldArray.length - 1;
                while (n >= 0) {
                    fieldArray[n].init(retrievable);
                    --n;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return this;
    }

    public String[] getFieldNames() {
        String[] stringArray = new String[this.fieldsArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.fieldsArray[n].name;
            ++n;
        }
        return stringArray;
    }

    public String getIntakeGroupName() {
        return this.name;
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getGID() {
        return this.gid;
    }

    public String getOID() {
        return this.oid;
    }

    public String getObjectKey() {
        return this.gid + this.oid;
    }

    public ArrayList getObjects(ValueParser valueParser) throws ServiceException {
        ArrayList<Group> arrayList = null;
        String[] stringArray = valueParser.getStrings(this.gid);
        if (stringArray != null) {
            arrayList = new ArrayList<Group>(stringArray.length);
            int n = stringArray.length - 1;
            while (n >= 0) {
                arrayList.add(TurbineIntake.getGroup(this.name).init(stringArray[n], valueParser));
                --n;
            }
        }
        return arrayList;
    }

    public Field get(String string) throws ServiceException {
        if (this.fields.containsKey(string)) {
            return (Field)this.fields.get(string);
        }
        throw new ServiceException("Intake Field name: " + string + " not found!");
    }

    public boolean isAllValid() {
        boolean bl = true;
        int n = this.fieldsArray.length - 1;
        while (n >= 0) {
            bl &= this.fieldsArray[n].isValid();
            if (isDebugEnabled && !this.fieldsArray[n].isValid()) {
                log.debug((Object)("[Intake] Group(" + this.oid + "): " + this.name + "; Field: " + this.fieldsArray[n].name + "; value=" + this.fieldsArray[n].getValue() + " is invalid!"));
            }
            --n;
        }
        return bl;
    }

    public void setProperties(Object object) throws ServiceException {
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            Field[] fieldArray = (Field[])this.mapToObjectFields.get(clazz.getName());
            if (fieldArray != null) {
                int n = fieldArray.length - 1;
                while (n >= 0) {
                    fieldArray[n].setProperty(object);
                    --n;
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public void setValidProperties(Object object) {
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            Field[] fieldArray = (Field[])this.mapToObjectFields.get(clazz.getName());
            if (fieldArray != null) {
                int n = fieldArray.length - 1;
                while (n >= 0) {
                    try {
                        fieldArray[n].setProperty(object);
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                    --n;
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public void getProperties(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            Field[] fieldArray = (Field[])this.mapToObjectFields.get(clazz.getName());
            if (fieldArray != null) {
                int n = fieldArray.length - 1;
                while (n >= 0) {
                    fieldArray[n].getProperty(object);
                    --n;
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public void removeFromRequest() {
        String[] stringArray;
        if (this.pp != null && (stringArray = this.pp.getStrings(this.gid)) != null) {
            this.pp.remove(this.gid);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && !stringArray[n].equals(this.oid)) {
                    this.pp.add(this.gid, stringArray[n]);
                }
                ++n;
            }
            int n2 = this.fieldsArray.length - 1;
            while (n2 >= 0) {
                this.fieldsArray[n2].removeFromRequest();
                --n2;
            }
        }
    }

    public void resetDeclared() {
        this.isDeclared = false;
    }

    public String getHtmlFormInput() {
        StringBuffer stringBuffer = new StringBuffer(64);
        this.appendHtmlFormInput(stringBuffer);
        return stringBuffer.toString();
    }

    public void appendHtmlFormInput(StringBuffer stringBuffer) {
        if (!this.isDeclared) {
            this.isDeclared = true;
            stringBuffer.append("<input type=\"hidden\" name=\"").append(this.gid).append("\" value=\"").append(this.oid).append("\"/>\n");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class GroupFactory
    extends BaseKeyedPoolableObjectFactory {
        private AppData appData;

        public GroupFactory(AppData appData) {
            this.appData = appData;
        }

        public Object makeObject(Object object) throws Exception {
            return new Group(this.appData.getGroup((String)object));
        }

        public void passivateObject(Object object, Object object2) throws Exception {
            Group group = (Group)object2;
            group.oid = null;
            group.pp = null;
            int n = group.fieldsArray.length - 1;
            while (n >= 0) {
                group.fieldsArray[n].dispose();
                --n;
            }
            group.isDeclared = false;
        }
    }
}

