/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.NumberValidator;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.torque.om.NumberKey;

public class NumberKeyValidator
extends NumberValidator {
    private static String INVALID_NUMBER = "Entry was not valid.";
    private NumberKey minValue;
    private NumberKey maxValue;

    public NumberKeyValidator(Map map) throws ServiceException {
        this();
        this.init(map);
    }

    public NumberKeyValidator() {
    }

    protected void doInit(Map map) {
        String string;
        this.minValue = null;
        this.maxValue = null;
        Constraint constraint = (Constraint)map.get("minValue");
        if (constraint != null) {
            string = constraint.getValue();
            this.minValue = new NumberKey(string);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)map.get("maxValue")) != null) {
            string = constraint.getValue();
            this.maxValue = new NumberKey(string);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    protected String getDefaultInvalidNumberMessage() {
        return INVALID_NUMBER;
    }

    protected void doAssertValidity(String string) throws ValidationException {
        NumberKey numberKey = null;
        try {
            numberKey = new NumberKey(string);
        }
        catch (RuntimeException runtimeException) {
            this.message = this.invalidNumberMessage;
            throw new ValidationException(this.invalidNumberMessage);
        }
        if (this.minValue != null && numberKey.compareTo((Object)this.minValue) < 0) {
            this.message = this.minValueMessage;
            throw new ValidationException(this.minValueMessage);
        }
        if (this.maxValue != null && numberKey.compareTo((Object)this.maxValue) > 0) {
            this.message = this.maxValueMessage;
            throw new ValidationException(this.maxValueMessage);
        }
    }

    public NumberKey getMinValue() {
        return this.minValue;
    }

    public void setMinValue(NumberKey numberKey) {
        this.minValue = numberKey;
    }

    public NumberKey getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(NumberKey numberKey) {
        this.maxValue = numberKey;
    }
}

