/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jsp;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.jsp.JspService;
import org.apache.fulcrum.template.BaseTemplateEngineService;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TurbineTemplate;

public class TurbineJspService
extends BaseTemplateEngineService
implements JspService {
    private String[] templatePaths;
    private String[] relativeTemplatePaths;
    private int bufferSize;

    public void init() throws InitializationException {
        try {
            this.initJsp();
            this.registerConfiguration("jsp");
            this.setInit(true);
        }
        catch (Exception exception) {
            throw new InitializationException("TurbineJspService failed to initialize", exception);
        }
    }

    public int getDefaultBufferSize() {
        return this.bufferSize;
    }

    public String handleRequest(TemplateContext templateContext, String string) throws ServiceException {
        return "";
    }

    public void handleRequest(TemplateContext templateContext, String string, OutputStream outputStream) throws ServiceException {
    }

    public void handleRequest(TemplateContext templateContext, String string, Writer writer) throws ServiceException {
    }

    private void initJsp() throws Exception {
        this.templatePaths = TurbineTemplate.translateTemplatePaths(this.getConfiguration().getStringArray("templates"));
        this.relativeTemplatePaths = this.getConfiguration().getStringArray("templates");
        int n = 0;
        while (n < this.relativeTemplatePaths.length) {
            if (!this.relativeTemplatePaths[n].startsWith("/")) {
                this.relativeTemplatePaths[n] = "/" + this.relativeTemplatePaths[n];
            }
            ++n;
        }
        this.bufferSize = this.getConfiguration().getInt("buffer.size", 8192);
        this.registerConfiguration("jsp");
    }

    public boolean templateExists(String string) {
        return TurbineTemplate.templateExists(string, this.templatePaths);
    }

    public String getRelativeTemplateName(String string) {
        String[] stringArray = new String[1];
        int n = 0;
        while (n < this.relativeTemplatePaths.length) {
            stringArray[0] = this.getRealPath(this.relativeTemplatePaths[n]);
            if (TurbineTemplate.templateExists(string, stringArray)) {
                return this.relativeTemplatePaths[n] + string;
            }
            ++n;
        }
        return null;
    }
}

