/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.fulcrum.schedule.JobEntry;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.pool.DBConnection;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public abstract class BaseJobEntryPeer
extends BasePeer {
    public static final String DATABASE_NAME = "default";
    public static final String TABLE_NAME = "TURBINE_SCHEDULED_JOB";
    public static final String JOB_ID = "TURBINE_SCHEDULED_JOB.JOB_ID";
    public static final String JOB_SECOND = "TURBINE_SCHEDULED_JOB.JOB_SECOND";
    public static final String JOB_MINUTE = "TURBINE_SCHEDULED_JOB.JOB_MINUTE";
    public static final String JOB_HOUR = "TURBINE_SCHEDULED_JOB.JOB_HOUR";
    public static final String WEEK_DAY = "TURBINE_SCHEDULED_JOB.WEEK_DAY";
    public static final String DAY_OF_MONTH = "TURBINE_SCHEDULED_JOB.DAY_OF_MONTH";
    public static final String TASK = "TURBINE_SCHEDULED_JOB.TASK";
    public static final String EMAIL = "TURBINE_SCHEDULED_JOB.EMAIL";
    public static final String JOB_PROPERTY = "TURBINE_SCHEDULED_JOB.JOB_PROPERTY";
    public static final int numColumns = 9;
    protected static final String CLASSNAME_DEFAULT = "org.apache.fulcrum.schedule.JobEntry";
    protected static final Class CLASS_DEFAULT;

    public static MapBuilder getMapBuilder() throws TorqueException {
        return BasePeer.getMapBuilder((String)"org.apache.fulcrum.schedule.map.JobEntryMapBuilder");
    }

    private static Class initClass(String string) {
        Class<?> clazz;
        block2: {
            clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                BasePeer.category.error((Object)"A FATAL ERROR has occurred which should not have happened under any circumstance.  Please notify the Turbine developers <turbine-dev@jakarta.apache.org> and give as many details as possible (including the error stack trace).", throwable);
                if (!(throwable instanceof Error)) break block2;
                throw (Error)throwable.fillInStackTrace();
            }
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector resultSet2Objects(ResultSet resultSet) throws TorqueException {
        try {
            QueryDataSet queryDataSet = null;
            Vector vector = null;
            try {
                queryDataSet = new QueryDataSet(resultSet);
                vector = BasePeer.getSelectResults((QueryDataSet)queryDataSet);
                Object var4_5 = null;
                if (queryDataSet == null) return BaseJobEntryPeer.populateObjects(vector);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (queryDataSet == null) throw throwable;
                queryDataSet.close();
                throw throwable;
            }
            queryDataSet.close();
            return BaseJobEntryPeer.populateObjects(vector);
        }
        catch (SQLException sQLException) {
            throw new TorqueException((Throwable)sQLException);
        }
        catch (DataSetException dataSetException) {
            throw new TorqueException((Throwable)dataSetException);
        }
    }

    public static ObjectKey doInsert(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.doInsert(criteria, (DBConnection)null);
    }

    public static ObjectKey doInsert(Criteria criteria, DBConnection dBConnection) throws TorqueException {
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (dBConnection == null) {
            return BasePeer.doInsert((Criteria)criteria);
        }
        return BasePeer.doInsert((Criteria)criteria, (DBConnection)dBConnection);
    }

    public static void addSelectColumns(Criteria criteria) throws TorqueException {
        criteria.addSelectColumn(JOB_ID);
        criteria.addSelectColumn(JOB_SECOND);
        criteria.addSelectColumn(JOB_MINUTE);
        criteria.addSelectColumn(JOB_HOUR);
        criteria.addSelectColumn(WEEK_DAY);
        criteria.addSelectColumn(DAY_OF_MONTH);
        criteria.addSelectColumn(TASK);
        criteria.addSelectColumn(EMAIL);
        criteria.addSelectColumn(JOB_PROPERTY);
    }

    public static JobEntry row2Object(Record record, int n, Class clazz) throws TorqueException {
        try {
            JobEntry jobEntry = (JobEntry)clazz.newInstance();
            BaseJobEntryPeer.populateObject(record, n, jobEntry);
            jobEntry.setModified(false);
            jobEntry.setNew(false);
            return jobEntry;
        }
        catch (InstantiationException instantiationException) {
            throw new TorqueException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TorqueException((Throwable)illegalAccessException);
        }
    }

    public static void populateObject(Record record, int n, JobEntry jobEntry) throws TorqueException {
        try {
            jobEntry.setJobId(new NumberKey(record.getValue(n + 0).asBigDecimal()));
            jobEntry.setSecond(record.getValue(n + 1).asInt());
            jobEntry.setMinute(record.getValue(n + 2).asInt());
            jobEntry.setHour(record.getValue(n + 3).asInt());
            jobEntry.setWeekDay(record.getValue(n + 4).asInt());
            jobEntry.setDayOfMonth(record.getValue(n + 5).asInt());
            jobEntry.setTask(record.getValue(n + 6).asString());
            jobEntry.setEmail(record.getValue(n + 7).asString());
            jobEntry.setProperty(record.getValue(n + 8).asBytes());
        }
        catch (DataSetException dataSetException) {
            throw new TorqueException((Throwable)dataSetException);
        }
    }

    public static Vector doSelect(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.populateObjects(BaseJobEntryPeer.doSelectVillageRecords(criteria));
    }

    public static Vector doSelect(Criteria criteria, DBConnection dBConnection) throws TorqueException {
        return BaseJobEntryPeer.populateObjects(BaseJobEntryPeer.doSelectVillageRecords(criteria, dBConnection));
    }

    public static Vector doSelectVillageRecords(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.doSelectVillageRecords(criteria, null);
    }

    public static Vector doSelectVillageRecords(Criteria criteria, DBConnection dBConnection) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            BaseJobEntryPeer.addSelectColumns(criteria);
        }
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (dBConnection == null) {
            return BasePeer.doSelect((Criteria)criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (DBConnection)dBConnection);
    }

    public static Vector populateObjects(Vector vector) throws TorqueException {
        Vector<JobEntry> vector2 = new Vector<JobEntry>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Record record = (Record)vector.elementAt(n);
            vector2.add(BaseJobEntryPeer.row2Object(record, 1, BaseJobEntryPeer.getOMClass()));
            ++n;
        }
        return vector2;
    }

    public static Class getOMClass() throws TorqueException {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        BaseJobEntryPeer.doUpdate(criteria, (DBConnection)null);
    }

    public static void doUpdate(Criteria criteria, DBConnection dBConnection) throws TorqueException {
        Criteria criteria2 = new Criteria(DATABASE_NAME, 2);
        criteria2.put((Object)JOB_ID, criteria.remove(JOB_ID));
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (dBConnection == null) {
            BasePeer.doUpdate((Criteria)criteria2, (Criteria)criteria);
        } else {
            BasePeer.doUpdate((Criteria)criteria2, (Criteria)criteria, (DBConnection)dBConnection);
        }
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        BaseJobEntryPeer.doDelete(criteria, (DBConnection)null);
    }

    public static void doDelete(Criteria criteria, DBConnection dBConnection) throws TorqueException {
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (dBConnection == null) {
            BasePeer.doDelete((Criteria)criteria);
        } else {
            BasePeer.doDelete((Criteria)criteria, (DBConnection)dBConnection);
        }
    }

    public static Vector doSelect(JobEntry jobEntry) throws TorqueException {
        return BaseJobEntryPeer.doSelect(BaseJobEntryPeer.buildCriteria(jobEntry));
    }

    public static void doInsert(JobEntry jobEntry) throws TorqueException {
        jobEntry.setPrimaryKey(BaseJobEntryPeer.doInsert(BaseJobEntryPeer.buildCriteria(jobEntry)));
        jobEntry.setNew(false);
        jobEntry.setModified(false);
    }

    public static void doUpdate(JobEntry jobEntry) throws TorqueException {
        BaseJobEntryPeer.doUpdate(BaseJobEntryPeer.buildCriteria(jobEntry));
    }

    public static void doDelete(JobEntry jobEntry) throws TorqueException {
        BaseJobEntryPeer.doDelete(BaseJobEntryPeer.buildCriteria(jobEntry));
    }

    public static void doInsert(JobEntry jobEntry, DBConnection dBConnection) throws TorqueException {
        jobEntry.setPrimaryKey(BaseJobEntryPeer.doInsert(BaseJobEntryPeer.buildCriteria(jobEntry), dBConnection));
        jobEntry.setNew(false);
        jobEntry.setModified(false);
    }

    public static void doUpdate(JobEntry jobEntry, DBConnection dBConnection) throws TorqueException {
        BaseJobEntryPeer.doUpdate(BaseJobEntryPeer.buildCriteria(jobEntry), dBConnection);
    }

    public static void doDelete(JobEntry jobEntry, DBConnection dBConnection) throws TorqueException {
        BaseJobEntryPeer.doDelete(BaseJobEntryPeer.buildCriteria(jobEntry), dBConnection);
    }

    public static Criteria buildCriteria(JobEntry jobEntry) {
        Criteria criteria = new Criteria(DATABASE_NAME);
        if (!jobEntry.isNew()) {
            criteria.add(JOB_ID, (Object)jobEntry.getJobId());
        }
        criteria.add(JOB_SECOND, jobEntry.getSecond());
        criteria.add(JOB_MINUTE, jobEntry.getMinute());
        criteria.add(JOB_HOUR, jobEntry.getHour());
        criteria.add(WEEK_DAY, jobEntry.getWeekDay());
        criteria.add(DAY_OF_MONTH, jobEntry.getDayOfMonth());
        criteria.add(TASK, (Object)jobEntry.getTask());
        criteria.add(EMAIL, (Object)jobEntry.getEmail());
        criteria.add(JOB_PROPERTY, (Object)jobEntry.getProperty());
        return criteria;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobEntry retrieveByPK(ObjectKey objectKey) throws TorqueException {
        DBConnection dBConnection = null;
        JobEntry jobEntry = null;
        try {
            dBConnection = Torque.getConnection((String)DATABASE_NAME);
            jobEntry = BaseJobEntryPeer.retrieveByPK(objectKey, dBConnection);
            Object var4_3 = null;
            if (dBConnection == null) return jobEntry;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (dBConnection == null) throw throwable;
            Torque.releaseConnection((DBConnection)dBConnection);
            throw throwable;
        }
        Torque.releaseConnection((DBConnection)dBConnection);
        return jobEntry;
    }

    public static JobEntry retrieveByPK(ObjectKey objectKey, DBConnection dBConnection) throws TorqueException {
        Criteria criteria = new Criteria();
        criteria.add(JOB_ID, (Object)objectKey);
        Vector vector = BaseJobEntryPeer.doSelect(criteria, dBConnection);
        if (vector.size() != 1) {
            throw new TorqueException("Failed to select one and only one row.");
        }
        return (JobEntry)vector.firstElement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List retrieveByPKs(List list) throws TorqueException {
        DBConnection dBConnection = null;
        List list2 = null;
        try {
            dBConnection = Torque.getConnection((String)DATABASE_NAME);
            list2 = BaseJobEntryPeer.retrieveByPKs(list, dBConnection);
            Object var4_3 = null;
            if (dBConnection == null) return list2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (dBConnection == null) throw throwable;
            Torque.releaseConnection((DBConnection)dBConnection);
            throw throwable;
        }
        Torque.releaseConnection((DBConnection)dBConnection);
        return list2;
    }

    public static List retrieveByPKs(List list, DBConnection dBConnection) throws TorqueException {
        AbstractList abstractList = null;
        if (list == null || list.size() == 0) {
            abstractList = new LinkedList();
        } else {
            Criteria criteria = new Criteria();
            criteria.addIn(JOB_ID, list);
            abstractList = BaseJobEntryPeer.doSelect(criteria, dBConnection);
        }
        return abstractList;
    }

    protected static TableMap getTableMap() throws TorqueException {
        return Torque.getDatabaseMap((String)DATABASE_NAME).getTable(TABLE_NAME);
    }

    static {
        if (Torque.isInit()) {
            try {
                BaseJobEntryPeer.getMapBuilder();
            }
            catch (Exception exception) {
                BasePeer.category.error((Object)"Could not initialize Peer", (Throwable)exception);
            }
        } else {
            Torque.registerMapBuilder((String)"org.apache.fulcrum.schedule.map.JobEntryMapBuilder");
        }
        CLASS_DEFAULT = BaseJobEntryPeer.initClass(CLASSNAME_DEFAULT);
    }
}

