/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.template;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.template.DefaultTemplateContext;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TemplateEngineService;
import org.apache.fulcrum.template.TemplateService;

public class TurbineTemplateService
extends BaseService
implements TemplateService {
    protected static final String NO_FILE_EXT = "";
    private String defaultExtension;
    private HashMap templateEngineRegistry;

    public void init() throws InitializationException {
        this.setInit(true);
    }

    public String[] translateTemplatePaths(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.getRealPath(stringArray[n]);
            ++n;
        }
        return stringArray;
    }

    public boolean templateExists(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (new File(stringArray[n], string).exists()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean templateExists(String string) {
        TemplateEngineService templateEngineService = this.getTemplateEngineService(string);
        if (templateEngineService != null) {
            return templateEngineService.templateExists(string);
        }
        return false;
    }

    public synchronized void registerTemplateEngineService(TemplateEngineService templateEngineService) {
        HashMap hashMap = this.templateEngineRegistry != null ? (HashMap)this.templateEngineRegistry.clone() : new HashMap();
        String[] stringArray = templateEngineService.getAssociatedFileExtensions();
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n], templateEngineService);
            ++n;
        }
        this.templateEngineRegistry = hashMap;
    }

    protected TemplateEngineService getTemplateEngineService(String string) {
        HashMap hashMap = this.templateEngineRegistry;
        if (hashMap != null && string != null) {
            int n = string.lastIndexOf(46);
            String string2 = n == -1 ? this.defaultExtension : string.substring(n + 1);
            return (TemplateEngineService)hashMap.get(string2);
        }
        return null;
    }

    public String handleRequest(TemplateContext templateContext, String string) throws ServiceException {
        TemplateEngineService templateEngineService = this.getTemplateEngineService(string);
        return templateEngineService.handleRequest(templateContext, string);
    }

    public void handleRequest(TemplateContext templateContext, String string, OutputStream outputStream) throws ServiceException {
        TemplateEngineService templateEngineService = this.getTemplateEngineService(string);
        templateEngineService.handleRequest(templateContext, string, outputStream);
    }

    public void handleRequest(TemplateContext templateContext, String string, Writer writer) throws ServiceException {
        TemplateEngineService templateEngineService = this.getTemplateEngineService(string);
        templateEngineService.handleRequest(templateContext, string, writer);
    }

    public TemplateContext getTemplateContext() {
        return new DefaultTemplateContext();
    }
}

