/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.xslt;

import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.xslt.XSLTService;
import org.w3c.dom.Node;

public class TurbineXSLTService
extends BaseService
implements XSLTService {
    protected boolean caching = false;
    protected String path;
    protected Hashtable cache = new Hashtable();
    protected static final String STYLESHEET_PATH = "path";
    protected static final String STYLESHEET_CACHING = "cache";
    private static TransformerFactory tfactory;

    public void init() throws InitializationException {
        if (this.isInitialized()) {
            return;
        }
        this.path = this.getRealPath(this.getConfiguration().getString(STYLESHEET_PATH));
        if (!this.path.endsWith("/") && !this.path.endsWith("\\")) {
            this.path = this.path + File.separator;
        }
        this.caching = this.getConfiguration().getBoolean(STYLESHEET_CACHING);
        tfactory = TransformerFactory.newInstance();
        this.setInit(true);
    }

    protected String getFileName(String string) {
        File file;
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((file = new File(this.path + string + ".xsl")).exists()) {
            return this.path + string + ".xsl";
        }
        file = new File(this.path + "default.xsl");
        if (file.exists()) {
            return this.path + "default.xsl";
        }
        return null;
    }

    protected Templates compileTemplates(String string) throws Exception {
        StreamSource streamSource = new StreamSource(new File(string));
        Templates templates = tfactory.newTemplates(streamSource);
        return templates;
    }

    protected Templates getTemplates(String string) throws Exception {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            String string2 = this.getFileName(string);
            if (string2 == null) {
                Templates templates = null;
                return templates;
            }
            if (this.caching && this.cache.containsKey(string2)) {
                Templates templates = (Templates)this.cache.get(string2);
                return templates;
            }
            Templates templates = this.compileTemplates(string2);
            if (this.caching) {
                this.cache.put(string2, templates);
            }
            Templates templates2 = templates;
            return templates2;
        }
    }

    protected void transform(String string, Source source, Result result) throws Exception {
        Templates templates = this.getTemplates(string);
        Transformer transformer = templates == null ? tfactory.newTransformer() : templates.newTransformer();
        transformer.transform(source, result);
    }

    public void transform(String string, Reader reader, Writer writer) throws Exception {
        StreamSource streamSource = new StreamSource(reader);
        StreamResult streamResult = new StreamResult(writer);
        this.transform(string, streamSource, streamResult);
    }

    public String transform(String string, Reader reader) throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.transform(string, reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public void transform(String string, Node node, Writer writer) throws Exception {
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        this.transform(string, dOMSource, streamResult);
    }

    public String transform(String string, Node node) throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.transform(string, node, (Writer)stringWriter);
        return stringWriter.toString();
    }
}

