;#
;# ds7_lib.pm version 1.2.4 1998/08/01
;#                          Copyright (C) 1997,1998 Mamoru Ohno
;#                               E-mail: mamo@yk.rim.or.jp 
;#
;# ٻΥե ǥ륫 DS-7 󥿥ե饤֥ Version 1.2.4
;#
;# linux(2.0.35)  perl(5.004) ưǧ
;# 
;# --------------------------------------
;# 1.2.4 ѹ
;# 109ܰʹߤβߤ˼ԤХ
;# ( patch 򤢤꤬Ȥޤ)
;#
;# --------------------------------------
;# 1.2.3 ѹ
;# 饤֥ؤѹ̵
;#
;# --------------------------------------
;# 1.2.2 ѹ
;# ƻּˡѹ(DS-20,DS-10ȯԶ礿)
;# ͥǽɲ
;# 
;# --------------------------------------
;# 1.2.1 ѹ
;# setoflag ȤäƲ®٤ꤷƤʬ setospeed ѹ
;# (  patch 򤢤꤬Ȥޤ)
;# 
;# --------------------------------------
;# 1.2 ѹ
;# üѥ᡼ ⡼ɤѹ
;#    &B9600 | &CS8  | &CREAD | &PARENB | &CRTSCTS
;#                     
;#    &B9600 | &CS8 | &PARENB | &CLOCAL | &CREAD
;# ioctl ѤƤʬ POSIX  setcflag ѹ
;#    ˤ굡老Ȥüѥ᡼ѹɬפ̵ʤä
;# versionֵѴؿ(&ds7lib_version)ɲ
;#    
;# --------------------------------------
;# 1.1 ѹ
;# եե  ٻΥե
;# å  BCC(Block Check Character)
;# Х
;#          read_ds7 إåʬ10 ޤޤƤν۾

package ds7_lib;
use	POSIX;
my($version) = 1.24;

sub BEGIN
{
    require Exporter;
    @ISA = qw(Exporter);
    @EXPORT = qw(open_ds7 close_ds7 get_image read_ds7 set_speed image_name finish_ds7 image_date ds7lib_version image_thumb get_thumb);
}

;#
;# üѥ᡼ (linux)
;#
eval 'sub B57600 {0010001;}';

;#
;# ꥢɤ߹ߤΥߥĴ
;#
#$Wait = 0.2 ;

;#
;# 業饯
;#
$ETX = 0x03;			# ƥȽλ
$ACK = 0x06;			# 
$NAK = 0x15;			# 
$ETB = 0x17;			# ֥åλ

;# ds-7 򥪡ץ󤷡ϿֵѤ롣
;# Usage:
;#           &open_ds7($handle,$serial_line)
;#                          $handle:          եϥɥ
;#                          $serial_line:     DS-7 ³줿ǥХ̾
;#                                            COM1 ξ "/dev/cua0"
;#                          RETURN:           ̿Ͽ
sub open_ds7
{
    $SIG{'INT'} = "finish_ds7";
    my($handle,$serial_line) = @_ ;
    my($buf,$dummy) = '';
    my($new_cflag) = (&CS8 | &PARENB | &CLOCAL | &CREAD);
    #
    # ̿® 9600 ǥץ
    #
    &open_serial($handle,$serial_line,$new_cflag, &B9600) || 
	die "Can't open $serial_line: $!\n";
    #----------------------------------------
    # DS-7 Ȥ̿
    #----------------------------------------
    &write_serial($handle,"05");	# ³(䤤碌)
    &ACK($handle) || die " Can't talk to DS-7.\n"; # 
    #----------------------------------------
    &write_serial($handle,make_msg("00090000")); # μ
    &ACK($handle) || die " Error.\n" ;
    ($buf,$dummy) = &read_ds7($handle); # 1
    #printf (" OK! This is %s .\n",substr($buf,5,4));	# 00.00DS-7 
    #----------------------------------------
    &OK($handle);		# 
    &write_serial($handle,make_msg("000b0000")); # Ͽμ
    &ACK($handle) || die " Error.\n";
    ($buf,$dummy) = &read_ds7($handle);		# 2
    &OK($handle);		# 
    my($number) = unpack("c*",substr($buf,0,1)) ;  # Ͽ
    $number ;
}

;# 饤open
;# Usage:
;#           &open_serial($handle,$dev,$cflag)
;#                          $handle:          եϥɥ
;#                          $dev:             ꥢǥХե̾
;#                          $cflag:           üե饰
sub open_serial
{
    my($handle,$dev,$cflag,$sspeed) = @_;
    return 0 unless defined $dev;
    return 0 if defined fileno($handle);
    #printf("%s\n",$dev);
    open($handle, "+< $dev") || die "Can't open $dev:$!";
    # ̿
    &set_ioctl($handle,$cflag,$sspeed);
}

;# ̿ꤹ
;# Usage:
;#           &set_ioctl($handle,$cflag)
;#                          $handle:          եϥɥ
;#                          $cflag:           üե饰
sub set_ioctl
{
    my($handle,$cflag,$sspeed) = @_;
    select((select($handle), $| = 1)[0]);
    # ̿
#    &show_param($handle);
    my($termios) = POSIX::Termios->new;
    $termios->getattr(fileno($handle));
    $termios->setcflag( $cflag ); # ⡼
    $termios->setiflag( 0 );	# ϥ⡼
    $termios->setoflag( 0 );	# ϥ⡼
    $termios->setlflag( 0 );	# ⡼
    for(my($i)=0;$i<&NCCS;++$i){
        $termios->setcc($i,0);
    }
    $termios->setispeed($sspeed); # ®
    $termios->setospeed($sspeed); # ®
    $termios->setattr(fileno($handle), &POSIX::TCSANOW ); # ⡼
#    &show_param($handle);
}

;#
;# üѥ᡼ɽ
;# Usage:
;#          &show_param($handle)
;#                          $handle:          եϥɥ
sub show_param
{
    my($handle) = @_;
    my($imes,$omes,$cmes,$lmes,$ismes,$osmes,$sizemes) = '';
    my(%idb) = (&IGNBRK => 'IGNBRK',
    		&BRKINT => 'BRKINT',
		&IGNPAR => 'IGNPAR',
		&PARMRK => 'PARMRK',
		&INPCK => 'INPCK',
		&ISTRIP => 'ISTRIP',
		&INLCR => 'INLCR',
		&IGNCR => 'IGNCR',
		&ICRNL => 'ICRNL',
		&IXON => 'IXON',
		&IXOFF => 'IXOFF'
		);
    my(%odb) = (&OPOST => 'OPOST');
    my(%sdb) = (&B0 => 'B0',
		&B50 => 'B50',
		&B75 => 'B75',
		&B110 => 'B110',
		&B134 => 'B134',
		&B150 => 'B150',
		&B200 => 'B200',
		&B300 => 'B300',
		&B600 => 'B600',
		&B1200 => 'B1200',
		&B1800 => 'B1800',
		&B2400 => 'B2400',
		&B4800 => 'B4800',
		&B9600 => 'B9600',
		&B19200 => 'B19200',
		&B38400 => 'B38400'
		);
    my(%bdb) = (&CS5 => 'CS5',
		&CS6 => 'CS6',
		&CS7 => 'CS7',
		&CS8 => 'CS8'
		);
    my(%cdb) = (&CSTOPB => 'CSTOPB',
		&CREAD => 'CREAD',
		&PARENB => 'PARENB',
		&PARODD => 'PARODD',
		&HUPCL => 'HUPCL',
		&CLOCAL => 'CLOCAL'
		);
    my(%ldb) = (&ISIG => 'ISIG',
		&ICANON => 'ICANON',
		&ECHO => 'ECHO',
		&ECHOE => 'ECHOE',
		&ECHOK => 'ECHOK',
		&ECHONL => 'ECHONL',
		&NOFLSH => 'NOFLSH',
		&TOSTOP => 'TOSTOP',
		&IEXTEN => 'IEXTEN'
		);
    my($termios) = POSIX::Termios->new;
    $termios->getattr(fileno($handle));
    my($iflag) = $termios->getiflag;
    my($oflag) = $termios->getoflag;
    my($cflag) = $termios->getcflag;
    my($lflag) = $termios->getlflag;
    my($ispeed) = $termios->getispeed;
    my($ospeed) = $termios->getospeed;
    my($csize) = $cflag & &CSIZE ;
    foreach $key (sort keys %idb)
    {
	if($iflag & $key)
	{
	    $imes .= $idb{$key}." ";
	}
    }
    foreach $key (sort keys %odb)
    {
	if($oflag & $key)
	{
	    $omes .= $odb{$key}." ";
	}
    }
    foreach $key (sort keys %cdb)
    {
	if($cflag & $key)
	{
	    $cmes .= $cdb{$key}." ";
	}
    }
    foreach $key (sort keys %ldb)
    {
	if($lflag & $key)
	{
	    $lmes .= $ldb{$key}." ";
	}
    }
    $ismes = $sdb{$ispeed};
    $osmes = $sdb{$ospeed};
    $sizemes = $bdb{$csize};
    printf("%s\n%s\n%s%s %s %s\n%s\n",
	   $imes,$omes,$cmes,$ismes,$osmes,$sizemes,$lmes);
    for(my($i)=0;$i<&NCCS;++$i){
        $c_cc[$i] = $termios->getcc($i);
        printf("%d:",$c_cc[$i]);
    }
    printf;
}

;# ds-7 򥯥롣
;# Usage:
;#           &close_ds7($handle)
;#                          $handle:          եϥɥ
sub close_ds7
{
    my($handle) = @_;
    return 0 unless defined fileno($handle);
    &OK($handle);		# ̿λ
    &write_serial($handle,"04");
    close($handle);
}

;# 1ʬΥ᡼
;# Usage:
;#           &get_image($handle,$num)
;#                          $handle:          եϥɥ
;#                          $num:             ᡼ֹ
;#                          RETURN:           ᡼ǡ
sub get_image
{
    my($handle,$num) = @_;
    my($buf,$image,$bcc) = '';
    &write_serial($handle,make_msg("00020200".sprintf("%02x",$num)."00"));
    &ACK($handle) || die " get_image error :$!\n"; # 
    $| = 1;
    do {
	($buf,$bcc) = &read_ds7($handle);
	$image .= $buf;
	if ($bcc == $ETB) {	# ETB(0x17) ξϥǡ³
	    print STDERR "+";
	    &OK($handle);		# 
	    select(undef,undef,undef,$Wait) if defined $Wait;
	}
	last if ($end);
    } until ($bcc == $ETX);	# ETX(0x03) ξϥǡλ
    print STDERR "\n";
    &OK($handle);
    $image;
}
;# 1ʬΥͥ
;# Usage:
;#           &get_thumb($handle,$num)
;#                          $handle:          եϥɥ
;#                          $num:             ᡼ֹ
;#                          RETURN:           ͥޤǡ
sub get_thumb
{
    my($handle,$num) = @_;
    my($buf,$thumb,$bcc) = '';
    &write_serial($handle,make_msg("00000200".sprintf("%02x",$num)."00"));
    &ACK($handle) || die " get_thumb error :$!\n"; # 
    $| = 1;
    do {
	($buf,$bcc) = &read_ds7($handle);
	$thumb .= $buf;
	if ($bcc == $ETB) {	# ETB(0x17) ξϥǡ³
	    print STDERR "+";
	    &OK($handle);		# 
	    select(undef,undef,undef,$Wait) if defined $Wait;
	}
	last if ($end);
    } until ($bcc == $ETX);	# ETX(0x03) ξϥǡλ
    print STDERR "\n";
    &OK($handle);
    $thumb;
}

;# ds-7 ǡ꡼ɤ
;# Usage:
;#           &read_ds7($handle)
;#                          $handle:          եϥɥ
;#                          RETURN:           ǡ業饯
;#                                            ($buf,$ctl)
sub read_ds7
{
    my($handle) = @_;
    my($ctl,$buf,@F) = '';
    for (;;) {
	&read_serial($handle,2);	# إåɤ߹(DLE+STX)

	# Block Check Character 
	my($xor) = 0;

	# ꡼ɽλԤ
	$fds = '';
	vec($fds, fileno($handle), 1) = 1;
	$ret = select($fds, undef, undef, 1);
	last if ($end || $ret < 1);

	$buf = '';
	do {
	    # ǡեåʬɤ߹
	    1 while(sysread($handle,$buf,1024,length($buf)) == 1024);

	    # ǡʬ 1010 ϼºݤˤ 10 ̣
	    # 業饯 10 ȶ̤뤿ˡ1010 иʬ
	    # ʬ䤹
	    @F = split(/\x10{2}/,$buf);	

	    # λγߥå
	    last if ($end);
	} until (unpack("c*",substr($F[$#F],-3,1)) == 0x10);
	# 0x10 ޤǷ֤
	# 0x10 θ 0x17  0x03  ꡢǸ1ХȤΥåब롣

	$ctl = unpack("c*",substr($F[$#F],-2,1)); # 業饯
	
	$bcc = unpack("c*",substr($F[$#F],-1,1)); # BCC(Block Check Character)

	substr($F[$#F],-3,3) = ""; # 0x10 ʹ(եå)

	$buf = join("\x10",@F);	# 1010 ʬ䤷ƤǤ10Ϣ

	# ǡǤå
	@G = unpack("c*",$buf);	# ǡʬ
	$xor ^= $ctl;		# 業饯å
	while (@G) {		# ǡå
	    $xor ^= shift(@G);
	}
	$xor ^= $bcc;		# BCCå
	last if ($xor == 0);	# å̤ξϡ롼פȴ
	print STDERR ":$xor Retry"; # ۾(ǡǤƤʤ)
	# 򤹤롣()
	&write_serial($handle,sprintf("%02x",$NAK));
    } 
    $buf = substr($buf, 4) ;	# ǡ˴طʤʬ򥫥å
    @ret = ($buf,$ctl);
}

;# ǡϤ
;# Usage:
;#           &write_serial($handle,$buf)
;#                          $handle:          եϥɥ
;#                          $buf:             ϥǡ
;#                          RETURN:           Ϥ줿ǡΥХȿ
sub write_serial
{
    my($handle,$buf) = @_;
    my($bare) = '';
    my($count,$ret) = (0);
    while(($len=length($buf))>0){
	$fds = '';
	vec($fds, fileno($handle), 1) = 1;
	$ret = select(undef, $fds, undef, 8);
	last if ($end || $ret < 1);
	$bare = substr($buf,0,2);
	while(($ret = syswrite($handle,pack("H*",$bare),1)) != 1) {
	    die "System write error: $!\n" unless defined $ret;
	}
	if ($count++ % 128 == 0) {
	    select(undef, undef, undef, 0.1);
	}
	$buf = substr($buf,2,$len-2);
	last if ($end) ;
    }
    $count;
}

;# ǡХȿ꡼ɤ
;# Usage:
;#           &read_serial($handle,$len)
;#                          $handle:          եϥɥ
;#                          $len:             ꡼ɥХȿ
;#                          RETURN:           ꡼ɤǡ
sub read_serial
{
    my($handle,$len) = @_;
    my($buf) = '';
    my($fds,$ret,$c);
    while($len-- > 0) {
	($fds,$ret) = '';
	vec($fds, fileno($handle), 1) = 1;
	$ret = select($fds, undef, undef, 2);
	last if ($end || $ret < 1);
	undef($ret);
	$ret = sysread($handle,$c,1); 
	die "Error in sysread: $!\n" unless defined $ret;
	$buf .= $c;
    }
    $buf;
}

;# ǡ業饯(إåեå)BCCɲä
;# Usage:
;#           &make_msg($buf)
;#                          $buf:             ǡ
;#                          RETURN:           Խǡ
sub make_msg
{
    my($buf) = @_;
    my($str) = '';
    my($head) = "1002" ;
    my($foot) = "1003" ;
    my($bcc) = 0x03 ;
    my($c) = '';

    while (length($buf)>0) {
        $c = substr($buf,0,2);
        $bcc ^= hex($c) ;
        $str .= $c;
        if( $c eq "10" ) {
            $str = sprintf( "%s10",$str);
        }
        substr($buf,0,2) = '';
    }
    $buf = sprintf("%s%s%s%02x",$head,$str,$foot,$bcc);
    $buf;
}

;# ǡ1ХȼACKп֤
;# Usage:
;#           &ACK($handle)
;#                          $handle:          եϥɥ
;#                          RETURN:           
sub ACK
{
    my($handle) = @_;
    my($buf) = '';
    $buf = &read_serial(cua1,1);
    select(undef,undef,undef,$Wait) if defined $Wait;
    if (unpack("c*",$buf ) != $ACK) {
	return 0;
    }
    return 1;
}

;# ACK1Х
;# Usage:
;#           &OK($handle)
;#                          $handle:          եϥɥ
sub OK
{
    my($handle) = @_;
    &write_serial($handle,"06");
}

;# ᡼̾
;# Usage:
;#           &image_name($handle,$num)
;#                          $handle:          եϥɥ
;#                          $num:             ᡼ֹ
;#                          RETURN:           ᡼̾
sub image_name
{
    my($handle,$num) = @_;
    &write_serial($handle,
		  make_msg("000a0200".sprintf("%02x",$num)."00"));
				# ե̾
    &ACK($handle) || die "Can't get filename : $!\n";
    my($buf,$dummy) = &read_ds7($handle);		# 
    &OK($handle);		# 
    $filename = substr($buf,0,12);
    $filename;
}
;# ̿®٤ꤹ
;# Usage:
;#           &set_speed($handle,$speed)
;#                          $handle:          եϥɥ
;#                          $speed:           ̿®
;#                          RETURN:           ̿
#----------------------------------------
# ̿® 57600,38400,19200,9600
# 57600 "0107010007"
# 38400 "0107010006"
# 19200 "0107010004"
# 9600  "0107010000"
sub set_speed
{
    %speed_msg = (
		  "57600","0107010007",
		  "38400","0107010006",
		  "19200","0107010004",
		  "9600","0107010000",
		  );
    %speed_boud = (
		   "57600",&B57600,
		   "38400",&B38400,
		   "19200",&B19200,
		   "9600",&B9600,
		   );

    my($handle,$speed) = @_;
    return 0 unless defined $speed_msg{$speed};
    &write_serial($handle,make_msg($speed_msg{$speed})); # ̿®ٻ
    &ACK($handle) || die "Can't change speed : $!\n";
    ($buf,$dummy) = &read_ds7($handle);		# 
    &OK($handle);
    #----------------------------------------
    &write_serial($handle,"04"); # ̿λ
    #----------------------------------------
    my($new_cflag) = (&CS8 | &PARENB | &CLOCAL | &CREAD);
    &set_ioctl($handle,$new_cflag,$speed_boud{$speed});
    &write_serial($handle,"05"); # ³(䤤碌)
    &ACK($handle) || return 0;
    &OK($handle);
    return 1;
}
;# ᡼λƻ֤
;# Usage:
;#           &image_date($buf)
;#                          $buf:             ᡼ǡ
;#                          RETURN:           ƻ
;#                                            "1997:04:29 22:45:50"η
sub image_date
{
    my($buf) = @_;
    my($exif) = &get_exif($buf); # ᡼exifǡФ
    my($A) = unpack("V",substr($exif,4,4)); # ǽIFDؤΥեå
    my($dummy1,$dummy2,$Value) = &tag_value($exif,$A,34665);
				# DS-7ȼǡʬؤΥեå
    $A = unpack("V",$Value);
    ($dummy1,$dummy2,$Value) = &tag_value($exif,$A,36867);
				# DS-7ȼǡʬؤΥեå
    my($date) = unpack("A*",$Value);
    $date;
}
;# ᡼ǡ饵ͥ
;# Usage:
;#           &image_thumb($buf)
;#                          $buf:             ᡼ǡ
;#                          RETURN:           ͥtiffǡ
sub image_thumb
{
    my($buf) = @_;
    my($entry_t) = 'vvVV';	# ȥ꡼η
    my(@size)=(0,1,1,2,4,8);	# Typeȥбɽ
				# 0,BYTE,ASCII.SHORT,LONG,RATIONAL
    my($i,$Tag,$Type,$Count,$Value,$dummy1,$dummy2,$StripOffsets,$StripByteCounts);
    my($exif) = &get_exif($buf); # ᡼exifǡФ
    #
    # ǡ2ܤIFD˳ǼƤ륵ͥǡ
    # ǽIFD˳ǼͥtiffǡȤֵѤ롣
    #
    my($A) = &next_ifd($exif,unpack("V",substr($exif,4,4)));
    die "Next IFD is empty!" if ($A == 0);
				# ͥγǼƤIFD˰ư
    my($entry) = unpack("v",substr($exif,$A,2));
				# ȥĿ
    # tiffǡ
    my($tiff) = pack("A*","II"); # Intel byte order
    $tiff .= pack('vVv',(42,8,$entry));	# 42,IFDؤΥեå,ȥĿ
    my($data_p) = 8+6+$entry*12; # tiffեǡʬؤΥեå 
    my($initial_data_p) = $data_p;
    # ޤǤ(ǡ)
    # ͥ륤᡼
    ($dummy1,$dummy2,$StripOffsets) = &tag_value($exif,$A,273);
				# ͥ륤᡼ʬؤΥեå
    ($dummy1,$dummy2,$StripByteCounts) = &tag_value($exif,$A,279);
				# ͥ륤᡼
    my($data) = substr($exif,unpack("V",$StripOffsets),unpack("v",$StripByteCounts));
				# ͥ륤᡼Ǽ
    $data_p += unpack('v',$StripByteCounts);
    # ᡼
    for($i = 0; $i<$entry;++$i) {
	($Tag,$Type,$Count,$Value) = &get_value($exif,$A,$i);
	if($Tag == 273) {		# ͥ륤᡼ʬؤΥեå
	    $tiff .= pack($entry_t,($Tag,$Type,$Count,$initial_data_p));
	    next;
	}
	if($size[$Type]*$Count < 5){ # ͤ4ХȰξ
	    # 4ХȤ
	    $tiff .= pack($entry_t,($Tag,$Type,$Count,unpack("V",$Value)));
	} else {            # ͤ4ХȰʾξ
	    $tiff .= pack($entry_t,($Tag,$Type,$Count,$data_p));
	    $data .= $Value;
	    $data_p += length($Value); # եåȤ򹹿
	}
    }
    $tiff .= pack("V",0);	# IFDʤ
    $tiff .= $data;		# ǡʬ
    $tiff;
}
;# ᡼exifǡФ
;# Usage:
;#           &get_exif($buf)
;#                          $buf:             ᡼ǡ
;#                          RETURN:           exifǡ
sub get_exif
{
    my($buf) = @_;
				# ExifǡμФ
    my($len) = unpack("n", substr($buf,4,2));
    my($exif) = substr($buf,12,$len-8);
				# Ƭ6ХܤAPP1ǡϤޤ
				# θ6ХȤExifإå
				# ǡĹ-2(ǡ)-6(Exifإå)
    $exif;
}
;# IFDΥեåȤ֤
;# Usage:
;#           &next_ifd($exif,$A)
;#                          $exif:            exifǡ
;#                          $A:               ߤIFDΥեå
;#                          RETURN:           IFDΥեå
;#           ǽIFDΥեåȤϡ$A = unpack("V",substr($exif,4,4));
;#           ȤƼ롣
sub next_ifd
{
    my($exif,$A) = @_;
    my($B) = unpack("v",substr($exif,$A,2));
				# IFD˴ޤޤ륨ȥθĿ
    my($next) = unpack("V",substr($exif,$A+2+$B*12,4));
				# IFDؤΥեå
    $next;
}
;# IFDTagֹǥޥå֤
;# Usage:
;#           &tag_value($exif,$A,$tag)
;#                          $exif:            exifǡ
;#                          $A:               ߤIFDΥեå
;#                          $tag:             Tagֹ
;#                          RETURN:           Type,Count,ꤷTag
sub tag_value
{
    my($exif,$A,$tag) = @_;
    my($i,$DirEnt,$Tag,$Type,$Count,$ValueOffset,$Value);
    my($entry_t) = 'vvVV';	# ȥ꡼η
    my(@size)=(0,1,1,2,4,8);	# Typeȥбɽ
				# 0,BYTE,ASCII.SHORT,LONG,RATIONAL
    my($B) = unpack("v",substr($exif,$A,2));
    for($i=0;$i<$B;++$i) {
	($Tag,$Type,$Count,$Value) = unpack($entry_t,substr($exif,$A+2+$i*12,12));
				# IFD˴ޤޤ륨ȥθĿ
	last if($Tag == $tag);
    }
    die "Tag don't match!" unless ($i < $B);
    if($size[$Type]*$Count > 4){ # ͤ4ХȰʾξ
	$ValueOffset = $Value;
	# 4ХȤϡͤؤΥեå
	$Value = substr($exif,$ValueOffset,$size[$Type]*$Count);
    } else {
	$Value = pack("V",$Value);
    }
    ($Type,$Count,$Value);
}
;# ꤷֹΥǥ쥯ȥꥨȥξ֤
;# Usage:
;#           &get_value($exif,$A,$entry)
;#                          $exif:            exifǡ
;#                          $A:               ߤIFDΥեå
;#                          $entry:           entryֹ
;#                          RETURN:           Tag,Type,Count,ꤷTag
sub get_value
{
    my($exif,$A,$entry) = @_;
    my($DirEnt,$Tag,$Type,$Count,$ValueOffset,$Value);
    my($entry_t) = 'vvVV';	# ȥ꡼η
    my(@size)=(0,1,1,2,4,8);	# Typeȥбɽ
				# 0,BYTE,ASCII.SHORT,LONG,RATIONAL
    my($B) = unpack("v",substr($exif,$A,2));
				# IFD˴ޤޤ륨ȥθĿ
    die "Parameter ENTRY is too large!" unless ($entry < $B);
    ($Tag,$Type,$Count,$Value) = unpack($entry_t,substr($exif,$A+2+$entry*12,12));
				# IFD˴ޤޤ륨ȥθĿ
    if($size[$Type]*$Count > 4){ # ͤ4ХȰʾξ
	$ValueOffset = $Value;
	# 4ХȤϡͤؤΥեå
	$Value = substr($exif,$ValueOffset,$size[$Type]*$Count);
    } else {
	$Value = pack("V",$Value);
    }
    ($Tag,$Type,$Count,$Value);
}
;#----------------------------------------
;# κ˻ߤ褦˥ʥϥɥ
;#         ܡɤγߤ顢$end ꤹ
$end = 0;
sub finish_ds7 {
    $end = 1;
}
;# versionֵѤ
;# Usage:
;#           &ds7lib_version()
;#                          RETURN:           version
sub ds7lib_version
{
    $version;
}
1;
