/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

class DbUtil {
    private static final boolean big_endian = DbUtil.am_big_endian();

    static int array2int(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        if (big_endian) {
            n5 = byArray[n6++];
            n4 = byArray[n6++];
            n3 = byArray[n6++];
            n2 = byArray[n6];
        } else {
            n2 = byArray[n6++];
            n3 = byArray[n6++];
            n4 = byArray[n6++];
            n5 = byArray[n6];
        }
        if (n2 < 0) {
            n2 += 256;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        if (n4 < 0) {
            n4 += 256;
        }
        if (n5 < 0) {
            n5 += 256;
        }
        return n2 + (n3 <<= 8) + (n4 <<= 16) + (n5 <<= 24);
    }

    static void int2array(int n, byte[] byArray, int n2) {
        int n3 = n2;
        int n4 = n & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n >> 16 & 0xFF;
        int n7 = n >> 24 & 0xFF;
        if (n4 >= 128) {
            n4 -= 256;
        }
        if (n5 >= 128) {
            n5 -= 256;
        }
        if (n6 >= 128) {
            n6 -= 256;
        }
        if (n7 >= 128) {
            n7 -= 256;
        }
        if (big_endian) {
            byArray[n3++] = (byte)n7;
            byArray[n3++] = (byte)n6;
            byArray[n3++] = (byte)n5;
            byArray[n3] = (byte)n4;
        } else {
            byArray[n3++] = (byte)n4;
            byArray[n3++] = (byte)n5;
            byArray[n3++] = (byte)n6;
            byArray[n3] = (byte)n7;
        }
    }

    private static final native boolean am_big_endian();

    DbUtil() {
    }
}

