/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.CpoolClass;
import gnu.bytecodecvssnap.CpoolEntry;
import gnu.bytecodecvssnap.CpoolNameAndType;
import gnu.bytecodecvssnap.CpoolRef;
import gnu.bytecodecvssnap.CpoolString;
import gnu.bytecodecvssnap.CpoolUtf8;
import gnu.bytecodecvssnap.CpoolValue1;
import gnu.bytecodecvssnap.CpoolValue2;
import gnu.bytecodecvssnap.Field;
import gnu.bytecodecvssnap.Method;
import gnu.bytecodecvssnap.ObjectType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConstantPool {
    public static final byte CLASS = 7;
    public static final byte FIELDREF = 9;
    public static final byte METHODREF = 10;
    public static final byte INTERFACE_METHODREF = 11;
    public static final byte STRING = 8;
    public static final byte INTEGER = 3;
    public static final byte FLOAT = 4;
    public static final byte LONG = 5;
    public static final byte DOUBLE = 6;
    public static final byte NAME_AND_TYPE = 12;
    public static final byte UTF8 = 1;
    CpoolEntry[] pool;
    int count;
    boolean locked;
    CpoolEntry[] hashTab;

    public final int getCount() {
        return this.count;
    }

    public final CpoolEntry getPoolEntry(int n) {
        return this.pool[n];
    }

    void rehash() {
        CpoolEntry cpoolEntry;
        int n;
        if (this.hashTab == null && this.count > 0) {
            n = this.pool.length;
            while (--n >= 0) {
                cpoolEntry = this.pool[n];
                if (cpoolEntry == null) continue;
                cpoolEntry.hashCode();
            }
        }
        this.hashTab = new CpoolEntry[this.count < 5 ? 101 : 2 * this.count];
        if (this.pool != null) {
            n = this.pool.length;
            while (--n >= 0) {
                cpoolEntry = this.pool[n];
                if (cpoolEntry == null) continue;
                cpoolEntry.add_hashed(this);
            }
        }
    }

    public CpoolUtf8 addUtf8(String string) {
        string = string.intern();
        int n = string.hashCode();
        if (this.hashTab == null) {
            this.rehash();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.hashTab.length;
        CpoolEntry cpoolEntry = this.hashTab[n2];
        while (cpoolEntry != null) {
            if (n == cpoolEntry.hash && cpoolEntry instanceof CpoolUtf8) {
                CpoolUtf8 cpoolUtf8 = (CpoolUtf8)cpoolEntry;
                if (cpoolUtf8.string == string) {
                    return cpoolUtf8;
                }
            }
            cpoolEntry = cpoolEntry.next;
        }
        if (this.locked) {
            throw new Error("adding new Utf8 entry to locked contant pool: " + string);
        }
        return new CpoolUtf8(this, n, string);
    }

    public CpoolClass addClass(ObjectType objectType) {
        return this.addClass(this.addUtf8(objectType.getInternalName()));
    }

    public CpoolClass addClass(String string) {
        return this.addClass(this.addUtf8(string.replace('.', '/')));
    }

    public CpoolClass addClass(CpoolUtf8 cpoolUtf8) {
        int n = CpoolClass.hashCode(cpoolUtf8);
        if (this.hashTab == null) {
            this.rehash();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.hashTab.length;
        CpoolEntry cpoolEntry = this.hashTab[n2];
        while (cpoolEntry != null) {
            if (n == cpoolEntry.hash && cpoolEntry instanceof CpoolClass) {
                CpoolClass cpoolClass = (CpoolClass)cpoolEntry;
                if (cpoolClass.name == cpoolUtf8) {
                    return cpoolClass;
                }
            }
            cpoolEntry = cpoolEntry.next;
        }
        return new CpoolClass(this, n, cpoolUtf8);
    }

    CpoolValue1 addValue1(int n, int n2) {
        int n3 = CpoolValue1.hashCode(n2);
        if (this.hashTab == null) {
            this.rehash();
        }
        int n4 = (n3 & Integer.MAX_VALUE) % this.hashTab.length;
        CpoolEntry cpoolEntry = this.hashTab[n4];
        while (cpoolEntry != null) {
            if (n3 == cpoolEntry.hash && cpoolEntry instanceof CpoolValue1) {
                CpoolValue1 cpoolValue1 = (CpoolValue1)cpoolEntry;
                if (cpoolValue1.tag == n && cpoolValue1.value == n2) {
                    return cpoolValue1;
                }
            }
            cpoolEntry = cpoolEntry.next;
        }
        return new CpoolValue1(this, n, n3, n2);
    }

    CpoolValue2 addValue2(int n, long l) {
        int n2 = CpoolValue2.hashCode(l);
        if (this.hashTab == null) {
            this.rehash();
        }
        int n3 = (n2 & Integer.MAX_VALUE) % this.hashTab.length;
        CpoolEntry cpoolEntry = this.hashTab[n3];
        while (cpoolEntry != null) {
            if (n2 == cpoolEntry.hash && cpoolEntry instanceof CpoolValue2) {
                CpoolValue2 cpoolValue2 = (CpoolValue2)cpoolEntry;
                if (cpoolValue2.tag == n && cpoolValue2.value == l) {
                    return cpoolValue2;
                }
            }
            cpoolEntry = cpoolEntry.next;
        }
        return new CpoolValue2(this, n, n2, l);
    }

    public CpoolValue1 addInt(int n) {
        return this.addValue1(3, n);
    }

    public CpoolValue2 addLong(long l) {
        return this.addValue2(5, l);
    }

    public CpoolValue1 addFloat(float f) {
        return this.addValue1(4, Float.floatToIntBits(f));
    }

    public CpoolValue2 addDouble(double d) {
        return this.addValue2(6, Double.doubleToLongBits(d));
    }

    public final CpoolString addString(String string) {
        return this.addString(this.addUtf8(string));
    }

    public CpoolString addString(CpoolUtf8 cpoolUtf8) {
        int n = CpoolString.hashCode(cpoolUtf8);
        if (this.hashTab == null) {
            this.rehash();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.hashTab.length;
        CpoolEntry cpoolEntry = this.hashTab[n2];
        while (cpoolEntry != null) {
            if (n == cpoolEntry.hash && cpoolEntry instanceof CpoolString) {
                CpoolString cpoolString = (CpoolString)cpoolEntry;
                if (cpoolString.str == cpoolUtf8) {
                    return cpoolString;
                }
            }
            cpoolEntry = cpoolEntry.next;
        }
        return new CpoolString(this, n, cpoolUtf8);
    }

    public CpoolNameAndType addNameAndType(Method method) {
        CpoolUtf8 cpoolUtf8 = this.addUtf8(method.getName());
        CpoolUtf8 cpoolUtf82 = this.addUtf8(method.getSignature());
        return this.addNameAndType(cpoolUtf8, cpoolUtf82);
    }

    public CpoolNameAndType addNameAndType(Field field) {
        CpoolUtf8 cpoolUtf8 = this.addUtf8(field.getName());
        CpoolUtf8 cpoolUtf82 = this.addUtf8(field.getSignature());
        return this.addNameAndType(cpoolUtf8, cpoolUtf82);
    }

    public CpoolNameAndType addNameAndType(CpoolUtf8 cpoolUtf8, CpoolUtf8 cpoolUtf82) {
        int n = CpoolNameAndType.hashCode(cpoolUtf8, cpoolUtf82);
        if (this.hashTab == null) {
            this.rehash();
        }
        int n2 = (n & Integer.MAX_VALUE) % this.hashTab.length;
        CpoolEntry cpoolEntry = this.hashTab[n2];
        while (cpoolEntry != null) {
            if (n == cpoolEntry.hash && cpoolEntry instanceof CpoolNameAndType && ((CpoolNameAndType)cpoolEntry).name == cpoolUtf8 && ((CpoolNameAndType)cpoolEntry).type == cpoolUtf82) {
                return (CpoolNameAndType)cpoolEntry;
            }
            cpoolEntry = cpoolEntry.next;
        }
        return new CpoolNameAndType(this, n, cpoolUtf8, cpoolUtf82);
    }

    public CpoolRef addRef(int n, CpoolClass cpoolClass, CpoolNameAndType cpoolNameAndType) {
        int n2 = CpoolRef.hashCode(cpoolClass, cpoolNameAndType);
        if (this.hashTab == null) {
            this.rehash();
        }
        int n3 = (n2 & Integer.MAX_VALUE) % this.hashTab.length;
        CpoolEntry cpoolEntry = this.hashTab[n3];
        while (cpoolEntry != null) {
            if (n2 == cpoolEntry.hash && cpoolEntry instanceof CpoolRef) {
                CpoolRef cpoolRef = (CpoolRef)cpoolEntry;
                if (cpoolRef.tag == n && cpoolRef.clas == cpoolClass && cpoolRef.nameAndType == cpoolNameAndType) {
                    return cpoolRef;
                }
            }
            cpoolEntry = cpoolEntry.next;
        }
        return new CpoolRef(this, n2, n, cpoolClass, cpoolNameAndType);
    }

    public CpoolRef addMethodRef(Method method) {
        CpoolClass cpoolClass = this.addClass(method.classfile.this_name);
        int n = (method.getDeclaringClass().getModifiers() & 0x200) == 0 ? 10 : 11;
        CpoolNameAndType cpoolNameAndType = this.addNameAndType(method);
        return this.addRef(n, cpoolClass, cpoolNameAndType);
    }

    public CpoolRef addFieldRef(Field field) {
        CpoolClass cpoolClass = this.addClass(field.owner.this_name);
        int n = 9;
        CpoolNameAndType cpoolNameAndType = this.addNameAndType(field);
        return this.addRef(n, cpoolClass, cpoolNameAndType);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.count + 1);
        int n = 1;
        while (n <= this.count) {
            CpoolEntry cpoolEntry = this.pool[n];
            if (cpoolEntry != null) {
                cpoolEntry.write(dataOutputStream);
            }
            ++n;
        }
        this.locked = true;
    }

    CpoolEntry getForced(int n, int n2) {
        CpoolEntry cpoolEntry = this.pool[n &= (char)-1];
        if (cpoolEntry == null) {
            if (this.locked) {
                throw new Error("adding new entry to locked contant pool");
            }
            switch (n2) {
                case 1: {
                    cpoolEntry = new CpoolUtf8();
                    break;
                }
                case 3: 
                case 4: {
                    cpoolEntry = new CpoolValue1(n2);
                    break;
                }
                case 5: 
                case 6: {
                    cpoolEntry = new CpoolValue2(n2);
                    break;
                }
                case 7: {
                    cpoolEntry = new CpoolClass();
                    break;
                }
                case 8: {
                    cpoolEntry = new CpoolString();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    cpoolEntry = new CpoolRef(n2);
                    break;
                }
                case 12: {
                    cpoolEntry = new CpoolNameAndType();
                }
            }
            this.pool[n] = cpoolEntry;
            cpoolEntry.index = n;
        } else if (cpoolEntry.getTag() != n2) {
            throw new ClassFormatError("conflicting constant pool tags at " + n);
        }
        return cpoolEntry;
    }

    public ConstantPool() {
    }

    public ConstantPool(DataInputStream dataInputStream) throws IOException {
        this.count = dataInputStream.readUnsignedShort() - 1;
        this.pool = new CpoolEntry[this.count + 1];
        int n = 1;
        while (n <= this.count) {
            byte by = dataInputStream.readByte();
            CpoolEntry cpoolEntry = this.getForced(n, by);
            switch (by) {
                case 1: {
                    ((CpoolUtf8)cpoolEntry).string = dataInputStream.readUTF();
                    break;
                }
                case 3: 
                case 4: {
                    ((CpoolValue1)cpoolEntry).value = dataInputStream.readInt();
                    break;
                }
                case 5: 
                case 6: {
                    ((CpoolValue2)cpoolEntry).value = dataInputStream.readLong();
                    ++n;
                    break;
                }
                case 7: {
                    ((CpoolClass)cpoolEntry).name = (CpoolUtf8)this.getForced(dataInputStream.readUnsignedShort(), 1);
                    break;
                }
                case 8: {
                    ((CpoolString)cpoolEntry).str = (CpoolUtf8)this.getForced(dataInputStream.readUnsignedShort(), 1);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    CpoolRef cpoolRef = (CpoolRef)cpoolEntry;
                    cpoolRef.clas = (CpoolClass)this.getForced(dataInputStream.readUnsignedShort(), 7);
                    cpoolRef.nameAndType = (CpoolNameAndType)this.getForced(dataInputStream.readUnsignedShort(), 12);
                    break;
                }
                case 12: {
                    CpoolNameAndType cpoolNameAndType = (CpoolNameAndType)cpoolEntry;
                    cpoolNameAndType.name = (CpoolUtf8)this.getForced(dataInputStream.readUnsignedShort(), 1);
                    cpoolNameAndType.type = (CpoolUtf8)this.getForced(dataInputStream.readUnsignedShort(), 1);
                    break;
                }
            }
            ++n;
        }
    }
}

