/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;

public class SmartClip {
    private final Clip clip;
    private final FloatControl volumeCtrl;
    private boolean muted = false;

    public SmartClip(String resourceName) {
        FloatControl tmpVolumeCtrl;
        Clip tmpClip;
        Object thrown = null;
        try {
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(this.getClass().getResource(resourceName));
            DataLine.Info outInfo = new DataLine.Info(Clip.class, audioIn.getFormat());
            tmpClip = (Clip)AudioSystem.getLine(outInfo);
            tmpClip.open(audioIn);
            audioIn.close();
            tmpVolumeCtrl = (FloatControl)tmpClip.getControl(FloatControl.Type.MASTER_GAIN);
        }
        catch (Exception excep) {
            Logger.getLogger("global").log(Level.WARNING, "SmartClip.new: Error loading " + resourceName, excep);
            tmpClip = null;
            tmpVolumeCtrl = null;
        }
        this.clip = tmpClip;
        this.volumeCtrl = tmpVolumeCtrl;
    }

    public void play() {
        if (!this.muted && this.clip != null) {
            this.clip.stop();
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void setVolume(float volume) {
        if (this.volumeCtrl == null) {
            return;
        }
        if (volume == 0.0f) {
            this.muted = true;
        } else {
            this.muted = false;
            float min = this.volumeCtrl.getMinimum();
            float max = this.volumeCtrl.getMaximum();
            this.volumeCtrl.setValue(volume * (max - min) + min);
        }
    }

    public float getVolume() {
        if (this.muted || this.volumeCtrl == null) {
            return 0.0f;
        }
        float min = this.volumeCtrl.getMinimum();
        float max = this.volumeCtrl.getMaximum();
        return (this.volumeCtrl.getValue() - min) / (max - min);
    }

    public boolean isRunning() {
        return this.clip != null && this.clip.isRunning();
    }
}

