/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UMacGenerator
extends BasePRNG
implements Cloneable {
    public static final String INDEX = "gnu.crypto.prng.umac.index";
    public static final String CIPHER = "gnu.crypto.prng.umac.cipher.name";
    private IBlockCipher cipher;

    public void setup(Map map) {
        boolean bl = true;
        String string = (String)map.get(CIPHER);
        if (string == null) {
            if (this.cipher == null) {
                this.cipher = CipherFactory.getInstance("rijndael");
            } else {
                bl = false;
            }
        } else {
            this.cipher = CipherFactory.getInstance(string);
        }
        int n = 0;
        Integer n2 = (Integer)map.get("gnu.crypto.cipher.block.size");
        if (n2 != null) {
            n = n2;
        } else if (bl) {
            n = this.cipher.defaultBlockSize();
        }
        byte[] byArray = (byte[])map.get("gnu.crypto.cipher.key.material");
        if (byArray == null) {
            throw new IllegalArgumentException("gnu.crypto.cipher.key.material");
        }
        int n3 = byArray.length;
        boolean bl2 = false;
        Iterator iterator = this.cipher.keySizes();
        while (iterator.hasNext()) {
            boolean bl3 = false;
            if (n3 == (Integer)iterator.next()) {
                bl3 = true;
            }
            if (bl2 = bl3) break;
        }
        if (!bl2) {
            throw new IllegalArgumentException("key length");
        }
        int n4 = -1;
        Integer n5 = (Integer)map.get(INDEX);
        if (n5 != null && ((n4 = n5.intValue()) < 0 || n4 > 255)) {
            throw new IllegalArgumentException(INDEX);
        }
        HashMap hashMap = new HashMap();
        if (n != 0) {
            hashMap.put("gnu.crypto.cipher.block.size", new Integer(n));
        }
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        try {
            this.cipher.init(hashMap);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("gnu.crypto.cipher.key.material");
        }
        this.buffer = new byte[this.cipher.currentBlockSize()];
        this.buffer[this.cipher.currentBlockSize() - 1] = (byte)n4;
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {}
    }

    public void fillBlock() throws LimitReachedException {
        this.cipher.encryptBlock(this.buffer, 0, this.buffer, 0);
    }

    public UMacGenerator() {
        super("umac-kdf");
    }
}

