/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Collator;
import java.util.Arrays;

public final class CollationKey
implements Comparable {
    private Collator collator;
    private String originalText;
    private byte[] key;

    public final int compareTo(CollationKey collationKey) {
        int n = Math.min(this.key.length, collationKey.key.length);
        int n2 = 0;
        while (n2 < n) {
            if (this.key[n2] != collationKey.key[n2]) {
                return this.key[n2] - collationKey.key[n2];
            }
            ++n2;
        }
        return this.key.length - collationKey.key.length;
    }

    public final int compareTo(Object object) {
        return this.compareTo((CollationKey)object);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof CollationKey)) {
            return false;
        }
        CollationKey collationKey = (CollationKey)object;
        if (collationKey.collator != this.collator) {
            return false;
        }
        if (!collationKey.getSourceString().equals(this.getSourceString())) {
            return false;
        }
        return Arrays.equals(collationKey.toByteArray(), this.toByteArray());
    }

    public final String getSourceString() {
        return this.originalText;
    }

    public final int hashCode() {
        long l = this.originalText.hashCode();
        int n = this.key.length - 1;
        while (n >= 0) {
            l ^= (long)(this.key[n] * (n + 1));
            --n;
        }
        return (int)(l >> 32 ^ l);
    }

    public final byte[] toByteArray() {
        return this.key;
    }

    CollationKey(Collator collator, String string, byte[] byArray) {
        this.collator = collator;
        this.originalText = string;
        this.key = byArray;
    }
}

