/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.behaviour;

import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.behaviour.DoubleActivityBase;

public class ToMove
extends DoubleActivityBase
implements Serializable {
    private double _from;
    private double _to;
    private double _duration;
    private double _timeout;

    public ToMove() {
        this._from = 0.0;
        this._to = 0.0;
        this._timeout = 1.0;
        this._duration = 1.0;
    }

    public ToMove(double d, double d2, double d3) {
        this._to = d2;
        this._from = d;
        this._duration = this._timeout = d3;
    }

    public double getFrom() {
        return this._from;
    }

    public void setFrom(double d) {
        this._from = d;
    }

    public double getTo() {
        return this._to;
    }

    public void setTo(double d) {
        this._to = d;
    }

    public double getDuration() {
        return this._duration;
    }

    public void setDuration(double d) {
        this._duration = this._timeout = d;
    }

    public double getValue() {
        return this._from + (1.0 - this._timeout / this._duration) * (this._to - this._from);
    }

    public boolean isFinite() {
        return true;
    }

    public void reset() {
        this._timeout = this._duration;
        this.postUpdate(this.getValue());
    }

    public void performActivity(double d) {
        if (this._timeout > 0.0) {
            this._timeout -= d;
            if (this._timeout <= 0.0) {
                this._timeout = 0.0;
                this._from = this._to;
                this.postActivityComplete();
            }
        }
        this.postUpdate(this.getValue());
    }

    public final DoubleBehaviourListener newFromAdapter() {
        return new FromAdapter();
    }

    public final DoubleBehaviourListener newToAdapter() {
        return new ToAdapter();
    }

    public final DoubleBehaviourListener newDurationAdapter() {
        return new DurationAdapter();
    }

    class DurationAdapter
    implements DoubleBehaviourListener,
    Serializable {
        DurationAdapter() {
        }

        public void behaviourUpdated(double d) {
            ToMove.this.setDuration(d);
        }
    }

    class ToAdapter
    implements DoubleBehaviourListener,
    Serializable {
        ToAdapter() {
        }

        public void behaviourUpdated(double d) {
            ToMove.this.setTo(d);
        }
    }

    class FromAdapter
    implements DoubleBehaviourListener,
    Serializable {
        FromAdapter() {
        }

        public void behaviourUpdated(double d) {
            ToMove.this.setFrom(d);
        }
    }
}

