(************************************************************
 * WARNING!
 *
 * This file is generated by ocamlrpcgen from the source file
 * netplex_ctrl.x
 *
 ************************************************************)

(* Type definitions *)

type longstring = 
     string
and longstring_opt = 
     longstring option
and internal_port = 
     longstring option
and internal_ports = 
     longstring array
and message = 
     { 
       mutable msg_name : longstring;
       mutable msg_arguments : longstring array;
     }
and socket_id = 
     { 
       mutable sock_protocol : longstring;
       mutable sock_index : int;
     }
and socket_id_list = 
     socket_id array
and event_type = 
     Netnumber.int4
and event = 
     [ 
     | `event_none 
     | `event_accept of (int) 
     | `event_noaccept 
     | `event_received_message of (message) 
     | `event_received_admin_message of (message) 
     | `event_shutdown 
     | `event_system_shutdown 
     ]
and level = 
     Netnumber.int4
and t_Control'V1'ping'arg = 
     unit
and t_Control'V1'ping'res = 
     unit
and t_Control'V1'poll'arg = 
      ( int * bool )
and t_Control'V1'poll'res = 
     event
and t_Control'V1'accepted'arg = 
     unit
and t_Control'V1'accepted'res = 
     unit
and t_System'V1'ping'arg = 
     unit
and t_System'V1'ping'res = 
     unit
and t_System'V1'lookup'arg = 
      ( longstring * longstring )
and t_System'V1'lookup'res = 
     internal_port
and t_System'V1'send_message'arg = 
      ( longstring * message )
and t_System'V1'send_message'res = 
     unit
and t_System'V1'log'arg = 
      ( level * longstring * longstring )
and t_System'V1'log'res = 
     unit
and t_System'V1'call_plugin'arg = 
      ( int64 * longstring * longstring )
and t_System'V1'call_plugin'res = 
     longstring
and t_System'V1'register_container_socket'arg = 
      ( longstring * longstring * longstring )
and t_System'V1'register_container_socket'res = 
     unit
and t_System'V1'lookup_container_sockets'arg = 
      ( longstring * longstring )
and t_System'V1'lookup_container_sockets'res = 
     internal_ports
and t_System'V1'activate_lever'arg = 
      ( int * longstring )
and t_System'V1'activate_lever'res = 
     longstring
and result_code = 
     Netnumber.int4
and unit_result = 
     [ | `code_ok | `code_error of (longstring) ]
and socket_domain = 
     Netnumber.int4
and port = 
     [ 
     | `pf_unknown 
     | `pf_unix of (longstring) 
     | `pf_inet of (_t0) 
     | `pf_inet6 of (_t1) 
     ]
and port_list = 
     port array
and prot = 
     { 
       mutable prot_name : longstring;
       mutable prot_ports : port_list;
     }
and prot_list = 
     prot array
and srv_state = 
     Netnumber.int4
and cnt_state_enum = 
     Netnumber.int4
and cnt_state = 
     [ 
     | `cstate_accepting 
     | `cstate_selected 
     | `cstate_busy 
     | `cstate_starting 
     | `cstate_shutdown 
     ]
and container_info = 
     { 
       mutable cnt_id : int64;
       mutable cnt_sys_id : longstring;
       mutable cnt_state : cnt_state;
     }
and service_info = 
     { 
       mutable srv_name : longstring;
       mutable srv_protocols : prot_list;
       mutable srv_nr_containers : int;
       mutable srv_containers : container_info array;
       mutable srv_state : srv_state;
     }
and service_info_list = 
     service_info array
and t_Admin'V2'ping'arg = 
     unit
and t_Admin'V2'ping'res = 
     unit
and t_Admin'V2'list'arg = 
     unit
and t_Admin'V2'list'res = 
     service_info_list
and t_Admin'V2'enable'arg = 
     longstring
and t_Admin'V2'enable'res = 
     unit_result
and t_Admin'V2'disable'arg = 
     longstring
and t_Admin'V2'disable'res = 
     unit_result
and t_Admin'V2'restart'arg = 
     longstring
and t_Admin'V2'restart'res = 
     unit_result
and t_Admin'V2'restart_all'arg = 
     unit
and t_Admin'V2'restart_all'res = 
     unit_result
and t_Admin'V2'system_shutdown'arg = 
     unit
and t_Admin'V2'system_shutdown'res = 
     unit_result
and t_Admin'V2'reopen_logfiles'arg = 
     unit
and t_Admin'V2'reopen_logfiles'res = 
     unit_result
and t_Admin'V2'send_admin_message'arg = 
      ( longstring * message )
and t_Admin'V2'send_admin_message'res = 
     unit
and t_Semaphore'V1'ping'arg = 
     unit
and t_Semaphore'V1'ping'res = 
     unit
and t_Semaphore'V1'increment'arg = 
     longstring
and t_Semaphore'V1'increment'res = 
     int64
and t_Semaphore'V1'decrement'arg = 
      ( longstring * bool )
and t_Semaphore'V1'decrement'res = 
     int64
and t_Semaphore'V1'get'arg = 
     longstring
and t_Semaphore'V1'get'res = 
     int64
and t_Semaphore'V1'create'arg = 
      ( longstring * int64 * bool )
and t_Semaphore'V1'create'res = 
     bool
and t_Semaphore'V1'destroy'arg = 
     longstring
and t_Semaphore'V1'destroy'res = 
     unit
and shvar_enum = 
     Netnumber.int4
and shvar_code = 
     [ 
     | `shvar_ok 
     | `shvar_badtype 
     | `shvar_notfound 
     | `shvar_exists 
     | `shvar_noperm 
     ]
and shvar_serial = 
     [ 
     | `shvar_ok of (int64) 
     | `shvar_badtype 
     | `shvar_notfound 
     | `shvar_exists 
     | `shvar_noperm 
     ]
and shvar_get = 
     [ 
     | `shvar_ok of (_t2) 
     | `shvar_badtype 
     | `shvar_notfound 
     | `shvar_exists 
     | `shvar_noperm 
     ]
and slot = 
     int option
and t_Sharedvar'V2'ping'arg = 
     unit
and t_Sharedvar'V2'ping'res = 
     unit
and t_Sharedvar'V2'create_var'arg = 
      ( longstring * bool * bool * longstring * float )
and t_Sharedvar'V2'create_var'res = 
     shvar_code
and t_Sharedvar'V2'set_value'arg = 
      ( longstring * longstring * longstring )
and t_Sharedvar'V2'set_value'res = 
     shvar_serial
and t_Sharedvar'V2'get_value'arg = 
      ( longstring * longstring )
and t_Sharedvar'V2'get_value'res = 
     shvar_get
and t_Sharedvar'V2'delete_var'arg = 
     longstring
and t_Sharedvar'V2'delete_var'res = 
     shvar_code
and t_Sharedvar'V2'wait_for_value'arg = 
      ( longstring * longstring )
and t_Sharedvar'V2'wait_for_value'res = 
     shvar_get
and t_Sharedvar'V2'dump'arg = 
      ( longstring * longstring )
and t_Sharedvar'V2'dump'res = 
     unit
and t_Sharedvar'V2'shm_slot'arg = 
     longstring
and t_Sharedvar'V2'shm_slot'res = 
     slot
and _t0 = 
     { 
       mutable inet_addr : longstring;
       mutable inet_port : int;
     }
and _t1 = 
     { 
       mutable inet6_addr : longstring;
       mutable inet6_port : int;
     }
and _t2 = 
     ( longstring * int64 )
;;
exception X_longstring of longstring
exception X_longstring_opt of longstring_opt
exception X_internal_port of internal_port
exception X_internal_ports of internal_ports
exception X_message of message
exception X_socket_id of socket_id
exception X_socket_id_list of socket_id_list
exception X_event_type of event_type
exception X_event of event
exception X_level of level
exception X_result_code of result_code
exception X_unit_result of unit_result
exception X_socket_domain of socket_domain
exception X_port of port
exception X_port_list of port_list
exception X_prot of prot
exception X_prot_list of prot_list
exception X_srv_state of srv_state
exception X_cnt_state_enum of cnt_state_enum
exception X_cnt_state of cnt_state
exception X_container_info of container_info
exception X_service_info of service_info
exception X_service_info_list of service_info_list
exception X_shvar_enum of shvar_enum
exception X_shvar_code of shvar_code
exception X_shvar_serial of shvar_serial
exception X_shvar_get of shvar_get
exception X_slot of slot
;;

(* Constant definitions *)

val event_none : Netnumber.int4;;
val event_accept : Netnumber.int4;;
val event_noaccept : Netnumber.int4;;
val event_received_message : Netnumber.int4;;
val event_received_admin_message : Netnumber.int4;;
val event_shutdown : Netnumber.int4;;
val event_system_shutdown : Netnumber.int4;;
val log_emerg : Netnumber.int4;;
val log_alert : Netnumber.int4;;
val log_crit : Netnumber.int4;;
val log_err : Netnumber.int4;;
val log_warning : Netnumber.int4;;
val log_notice : Netnumber.int4;;
val log_info : Netnumber.int4;;
val log_debug : Netnumber.int4;;
val code_ok : Netnumber.int4;;
val code_error : Netnumber.int4;;
val pf_unknown : Netnumber.int4;;
val pf_unix : Netnumber.int4;;
val pf_inet : Netnumber.int4;;
val pf_inet6 : Netnumber.int4;;
val state_enabled : Netnumber.int4;;
val state_disabled : Netnumber.int4;;
val state_restarting : Netnumber.int4;;
val state_down : Netnumber.int4;;
val cstate_accepting : Netnumber.int4;;
val cstate_selected : Netnumber.int4;;
val cstate_busy : Netnumber.int4;;
val cstate_starting : Netnumber.int4;;
val cstate_shutdown : Netnumber.int4;;
val shvar_ok : Netnumber.int4;;
val shvar_badtype : Netnumber.int4;;
val shvar_notfound : Netnumber.int4;;
val shvar_exists : Netnumber.int4;;
val shvar_noperm : Netnumber.int4;;

(* Conversion functions *)

val _to_longstring : Netxdr.xdr_value -> longstring;;
val _of_longstring : longstring -> Netxdr.xdr_value;;
val _xof_longstring : Netxdr.ctx -> longstring -> Netxdr.xdr_value;;
val _to_longstring_opt : Netxdr.xdr_value -> longstring_opt;;
val _of_longstring_opt : longstring_opt -> Netxdr.xdr_value;;
val _xof_longstring_opt : Netxdr.ctx -> longstring_opt -> Netxdr.xdr_value;;
val _to_internal_port : Netxdr.xdr_value -> internal_port;;
val _of_internal_port : internal_port -> Netxdr.xdr_value;;
val _xof_internal_port : Netxdr.ctx -> internal_port -> Netxdr.xdr_value;;
val _to_internal_ports : Netxdr.xdr_value -> internal_ports;;
val _of_internal_ports : internal_ports -> Netxdr.xdr_value;;
val _xof_internal_ports : Netxdr.ctx -> internal_ports -> Netxdr.xdr_value;;
val _to_message : Netxdr.xdr_value -> message;;
val _of_message : message -> Netxdr.xdr_value;;
val _xof_message : Netxdr.ctx -> message -> Netxdr.xdr_value;;
val _to_socket_id : Netxdr.xdr_value -> socket_id;;
val _of_socket_id : socket_id -> Netxdr.xdr_value;;
val _xof_socket_id : Netxdr.ctx -> socket_id -> Netxdr.xdr_value;;
val _to_socket_id_list : Netxdr.xdr_value -> socket_id_list;;
val _of_socket_id_list : socket_id_list -> Netxdr.xdr_value;;
val _xof_socket_id_list : Netxdr.ctx -> socket_id_list -> Netxdr.xdr_value;;
val _to_event_type : Netxdr.xdr_value -> event_type;;
val _of_event_type : event_type -> Netxdr.xdr_value;;
val _xof_event_type : Netxdr.ctx -> event_type -> Netxdr.xdr_value;;
val _to_event : Netxdr.xdr_value -> event;;
val _of_event : event -> Netxdr.xdr_value;;
val _xof_event : Netxdr.ctx -> event -> Netxdr.xdr_value;;
val _to_level : Netxdr.xdr_value -> level;;
val _of_level : level -> Netxdr.xdr_value;;
val _xof_level : Netxdr.ctx -> level -> Netxdr.xdr_value;;
val _to_Control'V1'ping'arg : Netxdr.xdr_value -> t_Control'V1'ping'arg;;
val _of_Control'V1'ping'arg : t_Control'V1'ping'arg -> Netxdr.xdr_value;;
val _xof_Control'V1'ping'arg : Netxdr.ctx -> t_Control'V1'ping'arg -> Netxdr.xdr_value;;
val _to_Control'V1'ping'res : Netxdr.xdr_value -> t_Control'V1'ping'res;;
val _of_Control'V1'ping'res : t_Control'V1'ping'res -> Netxdr.xdr_value;;
val _xof_Control'V1'ping'res : Netxdr.ctx -> t_Control'V1'ping'res -> Netxdr.xdr_value;;
val _to_Control'V1'poll'arg : Netxdr.xdr_value -> t_Control'V1'poll'arg;;
val _of_Control'V1'poll'arg : t_Control'V1'poll'arg -> Netxdr.xdr_value;;
val _xof_Control'V1'poll'arg : Netxdr.ctx -> t_Control'V1'poll'arg -> Netxdr.xdr_value;;
val _to_Control'V1'poll'res : Netxdr.xdr_value -> t_Control'V1'poll'res;;
val _of_Control'V1'poll'res : t_Control'V1'poll'res -> Netxdr.xdr_value;;
val _xof_Control'V1'poll'res : Netxdr.ctx -> t_Control'V1'poll'res -> Netxdr.xdr_value;;
val _to_Control'V1'accepted'arg : Netxdr.xdr_value -> t_Control'V1'accepted'arg;;
val _of_Control'V1'accepted'arg : t_Control'V1'accepted'arg -> Netxdr.xdr_value;;
val _xof_Control'V1'accepted'arg : Netxdr.ctx -> t_Control'V1'accepted'arg -> Netxdr.xdr_value;;
val _to_Control'V1'accepted'res : Netxdr.xdr_value -> t_Control'V1'accepted'res;;
val _of_Control'V1'accepted'res : t_Control'V1'accepted'res -> Netxdr.xdr_value;;
val _xof_Control'V1'accepted'res : Netxdr.ctx -> t_Control'V1'accepted'res -> Netxdr.xdr_value;;
val _to_System'V1'ping'arg : Netxdr.xdr_value -> t_System'V1'ping'arg;;
val _of_System'V1'ping'arg : t_System'V1'ping'arg -> Netxdr.xdr_value;;
val _xof_System'V1'ping'arg : Netxdr.ctx -> t_System'V1'ping'arg -> Netxdr.xdr_value;;
val _to_System'V1'ping'res : Netxdr.xdr_value -> t_System'V1'ping'res;;
val _of_System'V1'ping'res : t_System'V1'ping'res -> Netxdr.xdr_value;;
val _xof_System'V1'ping'res : Netxdr.ctx -> t_System'V1'ping'res -> Netxdr.xdr_value;;
val _to_System'V1'lookup'arg : Netxdr.xdr_value -> t_System'V1'lookup'arg;;
val _of_System'V1'lookup'arg : t_System'V1'lookup'arg -> Netxdr.xdr_value;;
val _xof_System'V1'lookup'arg : Netxdr.ctx -> t_System'V1'lookup'arg -> Netxdr.xdr_value;;
val _to_System'V1'lookup'res : Netxdr.xdr_value -> t_System'V1'lookup'res;;
val _of_System'V1'lookup'res : t_System'V1'lookup'res -> Netxdr.xdr_value;;
val _xof_System'V1'lookup'res : Netxdr.ctx -> t_System'V1'lookup'res -> Netxdr.xdr_value;;
val _to_System'V1'send_message'arg : Netxdr.xdr_value -> t_System'V1'send_message'arg;;
val _of_System'V1'send_message'arg : t_System'V1'send_message'arg -> Netxdr.xdr_value;;
val _xof_System'V1'send_message'arg : Netxdr.ctx -> t_System'V1'send_message'arg -> Netxdr.xdr_value;;
val _to_System'V1'send_message'res : Netxdr.xdr_value -> t_System'V1'send_message'res;;
val _of_System'V1'send_message'res : t_System'V1'send_message'res -> Netxdr.xdr_value;;
val _xof_System'V1'send_message'res : Netxdr.ctx -> t_System'V1'send_message'res -> Netxdr.xdr_value;;
val _to_System'V1'log'arg : Netxdr.xdr_value -> t_System'V1'log'arg;;
val _of_System'V1'log'arg : t_System'V1'log'arg -> Netxdr.xdr_value;;
val _xof_System'V1'log'arg : Netxdr.ctx -> t_System'V1'log'arg -> Netxdr.xdr_value;;
val _to_System'V1'log'res : Netxdr.xdr_value -> t_System'V1'log'res;;
val _of_System'V1'log'res : t_System'V1'log'res -> Netxdr.xdr_value;;
val _xof_System'V1'log'res : Netxdr.ctx -> t_System'V1'log'res -> Netxdr.xdr_value;;
val _to_System'V1'call_plugin'arg : Netxdr.xdr_value -> t_System'V1'call_plugin'arg;;
val _of_System'V1'call_plugin'arg : t_System'V1'call_plugin'arg -> Netxdr.xdr_value;;
val _xof_System'V1'call_plugin'arg : Netxdr.ctx -> t_System'V1'call_plugin'arg -> Netxdr.xdr_value;;
val _to_System'V1'call_plugin'res : Netxdr.xdr_value -> t_System'V1'call_plugin'res;;
val _of_System'V1'call_plugin'res : t_System'V1'call_plugin'res -> Netxdr.xdr_value;;
val _xof_System'V1'call_plugin'res : Netxdr.ctx -> t_System'V1'call_plugin'res -> Netxdr.xdr_value;;
val _to_System'V1'register_container_socket'arg : Netxdr.xdr_value -> t_System'V1'register_container_socket'arg;;
val _of_System'V1'register_container_socket'arg : t_System'V1'register_container_socket'arg -> Netxdr.xdr_value;;
val _xof_System'V1'register_container_socket'arg : Netxdr.ctx -> t_System'V1'register_container_socket'arg -> Netxdr.xdr_value;;
val _to_System'V1'register_container_socket'res : Netxdr.xdr_value -> t_System'V1'register_container_socket'res;;
val _of_System'V1'register_container_socket'res : t_System'V1'register_container_socket'res -> Netxdr.xdr_value;;
val _xof_System'V1'register_container_socket'res : Netxdr.ctx -> t_System'V1'register_container_socket'res -> Netxdr.xdr_value;;
val _to_System'V1'lookup_container_sockets'arg : Netxdr.xdr_value -> t_System'V1'lookup_container_sockets'arg;;
val _of_System'V1'lookup_container_sockets'arg : t_System'V1'lookup_container_sockets'arg -> Netxdr.xdr_value;;
val _xof_System'V1'lookup_container_sockets'arg : Netxdr.ctx -> t_System'V1'lookup_container_sockets'arg -> Netxdr.xdr_value;;
val _to_System'V1'lookup_container_sockets'res : Netxdr.xdr_value -> t_System'V1'lookup_container_sockets'res;;
val _of_System'V1'lookup_container_sockets'res : t_System'V1'lookup_container_sockets'res -> Netxdr.xdr_value;;
val _xof_System'V1'lookup_container_sockets'res : Netxdr.ctx -> t_System'V1'lookup_container_sockets'res -> Netxdr.xdr_value;;
val _to_System'V1'activate_lever'arg : Netxdr.xdr_value -> t_System'V1'activate_lever'arg;;
val _of_System'V1'activate_lever'arg : t_System'V1'activate_lever'arg -> Netxdr.xdr_value;;
val _xof_System'V1'activate_lever'arg : Netxdr.ctx -> t_System'V1'activate_lever'arg -> Netxdr.xdr_value;;
val _to_System'V1'activate_lever'res : Netxdr.xdr_value -> t_System'V1'activate_lever'res;;
val _of_System'V1'activate_lever'res : t_System'V1'activate_lever'res -> Netxdr.xdr_value;;
val _xof_System'V1'activate_lever'res : Netxdr.ctx -> t_System'V1'activate_lever'res -> Netxdr.xdr_value;;
val _to_result_code : Netxdr.xdr_value -> result_code;;
val _of_result_code : result_code -> Netxdr.xdr_value;;
val _xof_result_code : Netxdr.ctx -> result_code -> Netxdr.xdr_value;;
val _to_unit_result : Netxdr.xdr_value -> unit_result;;
val _of_unit_result : unit_result -> Netxdr.xdr_value;;
val _xof_unit_result : Netxdr.ctx -> unit_result -> Netxdr.xdr_value;;
val _to_socket_domain : Netxdr.xdr_value -> socket_domain;;
val _of_socket_domain : socket_domain -> Netxdr.xdr_value;;
val _xof_socket_domain : Netxdr.ctx -> socket_domain -> Netxdr.xdr_value;;
val _to_port : Netxdr.xdr_value -> port;;
val _of_port : port -> Netxdr.xdr_value;;
val _xof_port : Netxdr.ctx -> port -> Netxdr.xdr_value;;
val _to_port_list : Netxdr.xdr_value -> port_list;;
val _of_port_list : port_list -> Netxdr.xdr_value;;
val _xof_port_list : Netxdr.ctx -> port_list -> Netxdr.xdr_value;;
val _to_prot : Netxdr.xdr_value -> prot;;
val _of_prot : prot -> Netxdr.xdr_value;;
val _xof_prot : Netxdr.ctx -> prot -> Netxdr.xdr_value;;
val _to_prot_list : Netxdr.xdr_value -> prot_list;;
val _of_prot_list : prot_list -> Netxdr.xdr_value;;
val _xof_prot_list : Netxdr.ctx -> prot_list -> Netxdr.xdr_value;;
val _to_srv_state : Netxdr.xdr_value -> srv_state;;
val _of_srv_state : srv_state -> Netxdr.xdr_value;;
val _xof_srv_state : Netxdr.ctx -> srv_state -> Netxdr.xdr_value;;
val _to_cnt_state_enum : Netxdr.xdr_value -> cnt_state_enum;;
val _of_cnt_state_enum : cnt_state_enum -> Netxdr.xdr_value;;
val _xof_cnt_state_enum : Netxdr.ctx -> cnt_state_enum -> Netxdr.xdr_value;;
val _to_cnt_state : Netxdr.xdr_value -> cnt_state;;
val _of_cnt_state : cnt_state -> Netxdr.xdr_value;;
val _xof_cnt_state : Netxdr.ctx -> cnt_state -> Netxdr.xdr_value;;
val _to_container_info : Netxdr.xdr_value -> container_info;;
val _of_container_info : container_info -> Netxdr.xdr_value;;
val _xof_container_info : Netxdr.ctx -> container_info -> Netxdr.xdr_value;;
val _to_service_info : Netxdr.xdr_value -> service_info;;
val _of_service_info : service_info -> Netxdr.xdr_value;;
val _xof_service_info : Netxdr.ctx -> service_info -> Netxdr.xdr_value;;
val _to_service_info_list : Netxdr.xdr_value -> service_info_list;;
val _of_service_info_list : service_info_list -> Netxdr.xdr_value;;
val _xof_service_info_list : Netxdr.ctx -> service_info_list -> Netxdr.xdr_value;;
val _to_Admin'V2'ping'arg : Netxdr.xdr_value -> t_Admin'V2'ping'arg;;
val _of_Admin'V2'ping'arg : t_Admin'V2'ping'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'ping'arg : Netxdr.ctx -> t_Admin'V2'ping'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'ping'res : Netxdr.xdr_value -> t_Admin'V2'ping'res;;
val _of_Admin'V2'ping'res : t_Admin'V2'ping'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'ping'res : Netxdr.ctx -> t_Admin'V2'ping'res -> Netxdr.xdr_value;;
val _to_Admin'V2'list'arg : Netxdr.xdr_value -> t_Admin'V2'list'arg;;
val _of_Admin'V2'list'arg : t_Admin'V2'list'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'list'arg : Netxdr.ctx -> t_Admin'V2'list'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'list'res : Netxdr.xdr_value -> t_Admin'V2'list'res;;
val _of_Admin'V2'list'res : t_Admin'V2'list'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'list'res : Netxdr.ctx -> t_Admin'V2'list'res -> Netxdr.xdr_value;;
val _to_Admin'V2'enable'arg : Netxdr.xdr_value -> t_Admin'V2'enable'arg;;
val _of_Admin'V2'enable'arg : t_Admin'V2'enable'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'enable'arg : Netxdr.ctx -> t_Admin'V2'enable'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'enable'res : Netxdr.xdr_value -> t_Admin'V2'enable'res;;
val _of_Admin'V2'enable'res : t_Admin'V2'enable'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'enable'res : Netxdr.ctx -> t_Admin'V2'enable'res -> Netxdr.xdr_value;;
val _to_Admin'V2'disable'arg : Netxdr.xdr_value -> t_Admin'V2'disable'arg;;
val _of_Admin'V2'disable'arg : t_Admin'V2'disable'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'disable'arg : Netxdr.ctx -> t_Admin'V2'disable'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'disable'res : Netxdr.xdr_value -> t_Admin'V2'disable'res;;
val _of_Admin'V2'disable'res : t_Admin'V2'disable'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'disable'res : Netxdr.ctx -> t_Admin'V2'disable'res -> Netxdr.xdr_value;;
val _to_Admin'V2'restart'arg : Netxdr.xdr_value -> t_Admin'V2'restart'arg;;
val _of_Admin'V2'restart'arg : t_Admin'V2'restart'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'restart'arg : Netxdr.ctx -> t_Admin'V2'restart'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'restart'res : Netxdr.xdr_value -> t_Admin'V2'restart'res;;
val _of_Admin'V2'restart'res : t_Admin'V2'restart'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'restart'res : Netxdr.ctx -> t_Admin'V2'restart'res -> Netxdr.xdr_value;;
val _to_Admin'V2'restart_all'arg : Netxdr.xdr_value -> t_Admin'V2'restart_all'arg;;
val _of_Admin'V2'restart_all'arg : t_Admin'V2'restart_all'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'restart_all'arg : Netxdr.ctx -> t_Admin'V2'restart_all'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'restart_all'res : Netxdr.xdr_value -> t_Admin'V2'restart_all'res;;
val _of_Admin'V2'restart_all'res : t_Admin'V2'restart_all'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'restart_all'res : Netxdr.ctx -> t_Admin'V2'restart_all'res -> Netxdr.xdr_value;;
val _to_Admin'V2'system_shutdown'arg : Netxdr.xdr_value -> t_Admin'V2'system_shutdown'arg;;
val _of_Admin'V2'system_shutdown'arg : t_Admin'V2'system_shutdown'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'system_shutdown'arg : Netxdr.ctx -> t_Admin'V2'system_shutdown'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'system_shutdown'res : Netxdr.xdr_value -> t_Admin'V2'system_shutdown'res;;
val _of_Admin'V2'system_shutdown'res : t_Admin'V2'system_shutdown'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'system_shutdown'res : Netxdr.ctx -> t_Admin'V2'system_shutdown'res -> Netxdr.xdr_value;;
val _to_Admin'V2'reopen_logfiles'arg : Netxdr.xdr_value -> t_Admin'V2'reopen_logfiles'arg;;
val _of_Admin'V2'reopen_logfiles'arg : t_Admin'V2'reopen_logfiles'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'reopen_logfiles'arg : Netxdr.ctx -> t_Admin'V2'reopen_logfiles'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'reopen_logfiles'res : Netxdr.xdr_value -> t_Admin'V2'reopen_logfiles'res;;
val _of_Admin'V2'reopen_logfiles'res : t_Admin'V2'reopen_logfiles'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'reopen_logfiles'res : Netxdr.ctx -> t_Admin'V2'reopen_logfiles'res -> Netxdr.xdr_value;;
val _to_Admin'V2'send_admin_message'arg : Netxdr.xdr_value -> t_Admin'V2'send_admin_message'arg;;
val _of_Admin'V2'send_admin_message'arg : t_Admin'V2'send_admin_message'arg -> Netxdr.xdr_value;;
val _xof_Admin'V2'send_admin_message'arg : Netxdr.ctx -> t_Admin'V2'send_admin_message'arg -> Netxdr.xdr_value;;
val _to_Admin'V2'send_admin_message'res : Netxdr.xdr_value -> t_Admin'V2'send_admin_message'res;;
val _of_Admin'V2'send_admin_message'res : t_Admin'V2'send_admin_message'res -> Netxdr.xdr_value;;
val _xof_Admin'V2'send_admin_message'res : Netxdr.ctx -> t_Admin'V2'send_admin_message'res -> Netxdr.xdr_value;;
val _to_Semaphore'V1'ping'arg : Netxdr.xdr_value -> t_Semaphore'V1'ping'arg;;
val _of_Semaphore'V1'ping'arg : t_Semaphore'V1'ping'arg -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'ping'arg : Netxdr.ctx -> t_Semaphore'V1'ping'arg -> Netxdr.xdr_value;;
val _to_Semaphore'V1'ping'res : Netxdr.xdr_value -> t_Semaphore'V1'ping'res;;
val _of_Semaphore'V1'ping'res : t_Semaphore'V1'ping'res -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'ping'res : Netxdr.ctx -> t_Semaphore'V1'ping'res -> Netxdr.xdr_value;;
val _to_Semaphore'V1'increment'arg : Netxdr.xdr_value -> t_Semaphore'V1'increment'arg;;
val _of_Semaphore'V1'increment'arg : t_Semaphore'V1'increment'arg -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'increment'arg : Netxdr.ctx -> t_Semaphore'V1'increment'arg -> Netxdr.xdr_value;;
val _to_Semaphore'V1'increment'res : Netxdr.xdr_value -> t_Semaphore'V1'increment'res;;
val _of_Semaphore'V1'increment'res : t_Semaphore'V1'increment'res -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'increment'res : Netxdr.ctx -> t_Semaphore'V1'increment'res -> Netxdr.xdr_value;;
val _to_Semaphore'V1'decrement'arg : Netxdr.xdr_value -> t_Semaphore'V1'decrement'arg;;
val _of_Semaphore'V1'decrement'arg : t_Semaphore'V1'decrement'arg -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'decrement'arg : Netxdr.ctx -> t_Semaphore'V1'decrement'arg -> Netxdr.xdr_value;;
val _to_Semaphore'V1'decrement'res : Netxdr.xdr_value -> t_Semaphore'V1'decrement'res;;
val _of_Semaphore'V1'decrement'res : t_Semaphore'V1'decrement'res -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'decrement'res : Netxdr.ctx -> t_Semaphore'V1'decrement'res -> Netxdr.xdr_value;;
val _to_Semaphore'V1'get'arg : Netxdr.xdr_value -> t_Semaphore'V1'get'arg;;
val _of_Semaphore'V1'get'arg : t_Semaphore'V1'get'arg -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'get'arg : Netxdr.ctx -> t_Semaphore'V1'get'arg -> Netxdr.xdr_value;;
val _to_Semaphore'V1'get'res : Netxdr.xdr_value -> t_Semaphore'V1'get'res;;
val _of_Semaphore'V1'get'res : t_Semaphore'V1'get'res -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'get'res : Netxdr.ctx -> t_Semaphore'V1'get'res -> Netxdr.xdr_value;;
val _to_Semaphore'V1'create'arg : Netxdr.xdr_value -> t_Semaphore'V1'create'arg;;
val _of_Semaphore'V1'create'arg : t_Semaphore'V1'create'arg -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'create'arg : Netxdr.ctx -> t_Semaphore'V1'create'arg -> Netxdr.xdr_value;;
val _to_Semaphore'V1'create'res : Netxdr.xdr_value -> t_Semaphore'V1'create'res;;
val _of_Semaphore'V1'create'res : t_Semaphore'V1'create'res -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'create'res : Netxdr.ctx -> t_Semaphore'V1'create'res -> Netxdr.xdr_value;;
val _to_Semaphore'V1'destroy'arg : Netxdr.xdr_value -> t_Semaphore'V1'destroy'arg;;
val _of_Semaphore'V1'destroy'arg : t_Semaphore'V1'destroy'arg -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'destroy'arg : Netxdr.ctx -> t_Semaphore'V1'destroy'arg -> Netxdr.xdr_value;;
val _to_Semaphore'V1'destroy'res : Netxdr.xdr_value -> t_Semaphore'V1'destroy'res;;
val _of_Semaphore'V1'destroy'res : t_Semaphore'V1'destroy'res -> Netxdr.xdr_value;;
val _xof_Semaphore'V1'destroy'res : Netxdr.ctx -> t_Semaphore'V1'destroy'res -> Netxdr.xdr_value;;
val _to_shvar_enum : Netxdr.xdr_value -> shvar_enum;;
val _of_shvar_enum : shvar_enum -> Netxdr.xdr_value;;
val _xof_shvar_enum : Netxdr.ctx -> shvar_enum -> Netxdr.xdr_value;;
val _to_shvar_code : Netxdr.xdr_value -> shvar_code;;
val _of_shvar_code : shvar_code -> Netxdr.xdr_value;;
val _xof_shvar_code : Netxdr.ctx -> shvar_code -> Netxdr.xdr_value;;
val _to_shvar_serial : Netxdr.xdr_value -> shvar_serial;;
val _of_shvar_serial : shvar_serial -> Netxdr.xdr_value;;
val _xof_shvar_serial : Netxdr.ctx -> shvar_serial -> Netxdr.xdr_value;;
val _to_shvar_get : Netxdr.xdr_value -> shvar_get;;
val _of_shvar_get : shvar_get -> Netxdr.xdr_value;;
val _xof_shvar_get : Netxdr.ctx -> shvar_get -> Netxdr.xdr_value;;
val _to_slot : Netxdr.xdr_value -> slot;;
val _of_slot : slot -> Netxdr.xdr_value;;
val _xof_slot : Netxdr.ctx -> slot -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'ping'arg : Netxdr.xdr_value -> t_Sharedvar'V2'ping'arg;;
val _of_Sharedvar'V2'ping'arg : t_Sharedvar'V2'ping'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'ping'arg : Netxdr.ctx -> t_Sharedvar'V2'ping'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'ping'res : Netxdr.xdr_value -> t_Sharedvar'V2'ping'res;;
val _of_Sharedvar'V2'ping'res : t_Sharedvar'V2'ping'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'ping'res : Netxdr.ctx -> t_Sharedvar'V2'ping'res -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'create_var'arg : Netxdr.xdr_value -> t_Sharedvar'V2'create_var'arg;;
val _of_Sharedvar'V2'create_var'arg : t_Sharedvar'V2'create_var'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'create_var'arg : Netxdr.ctx -> t_Sharedvar'V2'create_var'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'create_var'res : Netxdr.xdr_value -> t_Sharedvar'V2'create_var'res;;
val _of_Sharedvar'V2'create_var'res : t_Sharedvar'V2'create_var'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'create_var'res : Netxdr.ctx -> t_Sharedvar'V2'create_var'res -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'set_value'arg : Netxdr.xdr_value -> t_Sharedvar'V2'set_value'arg;;
val _of_Sharedvar'V2'set_value'arg : t_Sharedvar'V2'set_value'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'set_value'arg : Netxdr.ctx -> t_Sharedvar'V2'set_value'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'set_value'res : Netxdr.xdr_value -> t_Sharedvar'V2'set_value'res;;
val _of_Sharedvar'V2'set_value'res : t_Sharedvar'V2'set_value'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'set_value'res : Netxdr.ctx -> t_Sharedvar'V2'set_value'res -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'get_value'arg : Netxdr.xdr_value -> t_Sharedvar'V2'get_value'arg;;
val _of_Sharedvar'V2'get_value'arg : t_Sharedvar'V2'get_value'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'get_value'arg : Netxdr.ctx -> t_Sharedvar'V2'get_value'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'get_value'res : Netxdr.xdr_value -> t_Sharedvar'V2'get_value'res;;
val _of_Sharedvar'V2'get_value'res : t_Sharedvar'V2'get_value'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'get_value'res : Netxdr.ctx -> t_Sharedvar'V2'get_value'res -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'delete_var'arg : Netxdr.xdr_value -> t_Sharedvar'V2'delete_var'arg;;
val _of_Sharedvar'V2'delete_var'arg : t_Sharedvar'V2'delete_var'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'delete_var'arg : Netxdr.ctx -> t_Sharedvar'V2'delete_var'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'delete_var'res : Netxdr.xdr_value -> t_Sharedvar'V2'delete_var'res;;
val _of_Sharedvar'V2'delete_var'res : t_Sharedvar'V2'delete_var'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'delete_var'res : Netxdr.ctx -> t_Sharedvar'V2'delete_var'res -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'wait_for_value'arg : Netxdr.xdr_value -> t_Sharedvar'V2'wait_for_value'arg;;
val _of_Sharedvar'V2'wait_for_value'arg : t_Sharedvar'V2'wait_for_value'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'wait_for_value'arg : Netxdr.ctx -> t_Sharedvar'V2'wait_for_value'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'wait_for_value'res : Netxdr.xdr_value -> t_Sharedvar'V2'wait_for_value'res;;
val _of_Sharedvar'V2'wait_for_value'res : t_Sharedvar'V2'wait_for_value'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'wait_for_value'res : Netxdr.ctx -> t_Sharedvar'V2'wait_for_value'res -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'dump'arg : Netxdr.xdr_value -> t_Sharedvar'V2'dump'arg;;
val _of_Sharedvar'V2'dump'arg : t_Sharedvar'V2'dump'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'dump'arg : Netxdr.ctx -> t_Sharedvar'V2'dump'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'dump'res : Netxdr.xdr_value -> t_Sharedvar'V2'dump'res;;
val _of_Sharedvar'V2'dump'res : t_Sharedvar'V2'dump'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'dump'res : Netxdr.ctx -> t_Sharedvar'V2'dump'res -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'shm_slot'arg : Netxdr.xdr_value -> t_Sharedvar'V2'shm_slot'arg;;
val _of_Sharedvar'V2'shm_slot'arg : t_Sharedvar'V2'shm_slot'arg -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'shm_slot'arg : Netxdr.ctx -> t_Sharedvar'V2'shm_slot'arg -> Netxdr.xdr_value;;
val _to_Sharedvar'V2'shm_slot'res : Netxdr.xdr_value -> t_Sharedvar'V2'shm_slot'res;;
val _of_Sharedvar'V2'shm_slot'res : t_Sharedvar'V2'shm_slot'res -> Netxdr.xdr_value;;
val _xof_Sharedvar'V2'shm_slot'res : Netxdr.ctx -> t_Sharedvar'V2'shm_slot'res -> Netxdr.xdr_value;;

(* XDR definitions *)

val xdrt_longstring : Netxdr.xdr_type_term;;
val xdrt_longstring_opt : Netxdr.xdr_type_term;;
val xdrt_internal_port : Netxdr.xdr_type_term;;
val xdrt_internal_ports : Netxdr.xdr_type_term;;
val xdrt_message : Netxdr.xdr_type_term;;
val xdrt_socket_id : Netxdr.xdr_type_term;;
val xdrt_socket_id_list : Netxdr.xdr_type_term;;
val xdrt_event_type : Netxdr.xdr_type_term;;
val xdrt_event : Netxdr.xdr_type_term;;
val xdrt_level : Netxdr.xdr_type_term;;
val xdrt_Control'V1'ping'arg : Netxdr.xdr_type_term;;
val xdrt_Control'V1'ping'res : Netxdr.xdr_type_term;;
val xdrt_Control'V1'poll'arg : Netxdr.xdr_type_term;;
val xdrt_Control'V1'poll'res : Netxdr.xdr_type_term;;
val xdrt_Control'V1'accepted'arg : Netxdr.xdr_type_term;;
val xdrt_Control'V1'accepted'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'ping'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'ping'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'lookup'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'lookup'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'send_message'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'send_message'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'log'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'log'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'call_plugin'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'call_plugin'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'register_container_socket'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'register_container_socket'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'lookup_container_sockets'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'lookup_container_sockets'res : Netxdr.xdr_type_term;;
val xdrt_System'V1'activate_lever'arg : Netxdr.xdr_type_term;;
val xdrt_System'V1'activate_lever'res : Netxdr.xdr_type_term;;
val xdrt_result_code : Netxdr.xdr_type_term;;
val xdrt_unit_result : Netxdr.xdr_type_term;;
val xdrt_socket_domain : Netxdr.xdr_type_term;;
val xdrt_port : Netxdr.xdr_type_term;;
val xdrt_port_list : Netxdr.xdr_type_term;;
val xdrt_prot : Netxdr.xdr_type_term;;
val xdrt_prot_list : Netxdr.xdr_type_term;;
val xdrt_srv_state : Netxdr.xdr_type_term;;
val xdrt_cnt_state_enum : Netxdr.xdr_type_term;;
val xdrt_cnt_state : Netxdr.xdr_type_term;;
val xdrt_container_info : Netxdr.xdr_type_term;;
val xdrt_service_info : Netxdr.xdr_type_term;;
val xdrt_service_info_list : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'ping'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'ping'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'list'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'list'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'enable'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'enable'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'disable'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'disable'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'restart'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'restart'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'restart_all'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'restart_all'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'system_shutdown'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'system_shutdown'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'reopen_logfiles'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'reopen_logfiles'res : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'send_admin_message'arg : Netxdr.xdr_type_term;;
val xdrt_Admin'V2'send_admin_message'res : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'ping'arg : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'ping'res : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'increment'arg : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'increment'res : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'decrement'arg : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'decrement'res : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'get'arg : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'get'res : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'create'arg : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'create'res : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'destroy'arg : Netxdr.xdr_type_term;;
val xdrt_Semaphore'V1'destroy'res : Netxdr.xdr_type_term;;
val xdrt_shvar_enum : Netxdr.xdr_type_term;;
val xdrt_shvar_code : Netxdr.xdr_type_term;;
val xdrt_shvar_serial : Netxdr.xdr_type_term;;
val xdrt_shvar_get : Netxdr.xdr_type_term;;
val xdrt_slot : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'ping'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'ping'res : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'create_var'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'create_var'res : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'set_value'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'set_value'res : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'get_value'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'get_value'res : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'delete_var'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'delete_var'res : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'wait_for_value'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'wait_for_value'res : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'dump'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'dump'res : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'shm_slot'arg : Netxdr.xdr_type_term;;
val xdrt_Sharedvar'V2'shm_slot'res : Netxdr.xdr_type_term;;

(* Program definitions *)

val program_Control'V1 : Rpc_program.t;;
val program_System'V1 : Rpc_program.t;;
val program_Admin'V2 : Rpc_program.t;;
val program_Semaphore'V1 : Rpc_program.t;;
val program_Sharedvar'V2 : Rpc_program.t;;

