/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.lang.reflect.TypeSignature;
import java.io.InvalidClassException;
import java.io.VMObjectStreamClass;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectStreamField
implements Comparable {
    private String name;
    private Class type;
    private String typename;
    private int offset;
    private boolean unshared;
    private boolean persistent;
    private boolean toset;
    private Field field;

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public char getTypeCode() {
        return this.typename.charAt(0);
    }

    public String getTypeString() {
        if (this.isPrimitive()) {
            return null;
        }
        return this.typename.intern();
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int off) {
        this.offset = off;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public boolean isPrimitive() {
        boolean bl = false;
        if (this.typename.length() == 1) {
            bl = true;
        }
        return bl;
    }

    public int compareTo(Object obj) {
        ObjectStreamField f = (ObjectStreamField)obj;
        boolean this_is_primitive = this.isPrimitive();
        boolean f_is_primitive = f.isPrimitive();
        if (this_is_primitive && !f_is_primitive) {
            return -1;
        }
        if (!this_is_primitive && f_is_primitive) {
            return 1;
        }
        return this.getName().compareTo(f.getName());
    }

    void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    boolean isPersistent() {
        return this.persistent;
    }

    void setToSet(boolean toset) {
        this.toset = toset;
    }

    boolean isToSet() {
        return this.toset;
    }

    void lookupField(Class clazz) throws NoSuchFieldException, SecurityException {
        final Field f = clazz.getDeclaredField(this.name);
        AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                f.setAccessible(true);
                return null;
            }
        });
        this.field = f;
    }

    void checkFieldType() throws InvalidClassException {
        Class ftype = this.field.getType();
        if (!ftype.isAssignableFrom(this.type)) {
            throw new InvalidClassException("invalid field type for " + this.name + " in class " + this.field.getDeclaringClass());
        }
    }

    public String toString() {
        return "ObjectStreamField< " + this.type + ' ' + this.name + " >";
    }

    final void setBooleanField(Object obj, boolean val) {
        VMObjectStreamClass.setBooleanNative(this.field, obj, val);
    }

    final void setByteField(Object obj, byte val) {
        VMObjectStreamClass.setByteNative(this.field, obj, val);
    }

    final void setCharField(Object obj, char val) {
        VMObjectStreamClass.setCharNative(this.field, obj, val);
    }

    final void setShortField(Object obj, short val) {
        VMObjectStreamClass.setShortNative(this.field, obj, val);
    }

    final void setIntField(Object obj, int val) {
        VMObjectStreamClass.setIntNative(this.field, obj, val);
    }

    final void setLongField(Object obj, long val) {
        VMObjectStreamClass.setLongNative(this.field, obj, val);
    }

    final void setFloatField(Object obj, float val) {
        VMObjectStreamClass.setFloatNative(this.field, obj, val);
    }

    final void setDoubleField(Object obj, double val) {
        VMObjectStreamClass.setDoubleNative(this.field, obj, val);
    }

    final void setObjectField(Object obj, Object val) {
        VMObjectStreamClass.setObjectNative(this.field, obj, val);
    }

    private final /* synthetic */ void this() {
        this.offset = -1;
        this.persistent = false;
        this.toset = true;
    }

    ObjectStreamField(Field field) {
        this(field.getName(), field.getType());
        this.field = field;
    }

    public ObjectStreamField(String name, Class type) {
        this(name, type, false);
    }

    public ObjectStreamField(String name, Class type, boolean unshared) {
        this.this();
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.type = type;
        this.typename = TypeSignature.getEncodingOfClass(type);
        this.unshared = unshared;
    }

    ObjectStreamField(String name, String typename) {
        this.this();
        this.name = name;
        this.typename = typename;
        try {
            this.type = TypeSignature.getClassForEncoding(typename);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    ObjectStreamField(String name, String typename, ClassLoader loader) {
        this.this();
        this.name = name;
        this.typename = typename;
        try {
            this.type = TypeSignature.getClassForEncoding(typename, true, loader);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }
}

