/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.MimeTypeMapper;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.AllPermission;
import java.security.Permission;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class URLConnection {
    private static FileNameMap fileNameMap;
    private static ContentHandlerFactory factory;
    private static boolean defaultAllowUserInteraction;
    private static boolean defaultUseCaches;
    private static SimpleDateFormat[] dateFormats;
    private static boolean dateformats_initialized;
    protected boolean allowUserInteraction;
    protected boolean connected;
    protected boolean doInput;
    protected boolean doOutput;
    protected boolean useCaches;
    protected long ifModifiedSince;
    protected URL url;
    private ParsePosition position;

    public abstract void connect() throws IOException;

    public URL getURL() {
        return this.url;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(int index) {
        return null;
    }

    public String getHeaderField(String name) {
        return null;
    }

    public Map getHeaderFields() {
        return Collections.EMPTY_MAP;
    }

    public int getHeaderFieldInt(String name, int defaultValue) {
        String value = this.getHeaderField(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getHeaderFieldDate(String name, long defaultValue) {
        if (!dateformats_initialized) {
            URLConnection.initializeDateFormats();
        }
        if (this.position == null) {
            this.position = new ParsePosition(0);
        }
        long result = defaultValue;
        String str = this.getHeaderField(name);
        if (str != null) {
            int i = 0;
            while (i < dateFormats.length) {
                SimpleDateFormat df = dateFormats[i];
                this.position.setIndex(0);
                this.position.setErrorIndex(0);
                Date date = df.parse(str, this.position);
                if (date != null) {
                    return date.getTime();
                }
                ++i;
            }
        }
        return result;
    }

    public String getHeaderFieldKey(int index) {
        return null;
    }

    public Object getContent() throws IOException {
        String type;
        ContentHandler ch;
        if (!this.connected) {
            this.connect();
        }
        if ((ch = this.getContentHandler(type = this.getContentType())) != null) {
            return ch.getContent(this);
        }
        return this.getInputStream();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.getContent();
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support input.");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support output.");
    }

    public String toString() {
        return this.getClass().getName() + ':' + this.url.toString();
    }

    public void setDoInput(boolean input) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doInput = input;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public void setDoOutput(boolean output) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doOutput = output;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public void setAllowUserInteraction(boolean allow) {
        this.allowUserInteraction = allow;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public static void setDefaultAllowUserInteraction(boolean allow) {
        defaultAllowUserInteraction = allow;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public void setUseCaches(boolean usecaches) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.useCaches = usecaches;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.ifModifiedSince = ifmodifiedsince;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public void setDefaultUseCaches(boolean use) {
        defaultUseCaches = use;
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
    }

    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
    }

    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return null;
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return Collections.EMPTY_MAP;
    }

    public static void setDefaultRequestProperty(String key, String value) {
    }

    public static String getDefaultRequestProperty(String key) {
        return null;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory factory) {
        if (URLConnection.factory != null) {
            throw new Error("ContentHandlerFactory already set");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        URLConnection.factory = factory;
    }

    public static String guessContentTypeFromName(String filename) {
        return URLConnection.getFileNameMap().getContentTypeFor(filename.toLowerCase());
    }

    public static String guessContentTypeFromStream(InputStream is) throws IOException {
        return "application/octet-stream";
    }

    public static synchronized FileNameMap getFileNameMap() {
        if (fileNameMap == null) {
            fileNameMap = new MimeTypeMapper();
        }
        return fileNameMap;
    }

    public static synchronized void setFileNameMap(FileNameMap map) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        fileNameMap = map;
    }

    private final ContentHandler getContentHandler(String contentType) {
        if (contentType == null || contentType.equals("")) {
            return null;
        }
        ContentHandler handler = null;
        if (factory != null) {
            handler = factory.createContentHandler(contentType);
        }
        try {
            Class cls;
            Object obj;
            String typeClass = contentType.replace('/', '.');
            int parameterBegin = typeClass.indexOf(59);
            if (parameterBegin >= 1) {
                typeClass = typeClass.substring(0, parameterBegin);
            }
            if ((obj = (cls = Class.forName("gnu.java.net.content." + typeClass)).newInstance()) instanceof ContentHandler) {
                handler = (ContentHandler)obj;
                return handler;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return handler;
    }

    private static final synchronized void initializeDateFormats() {
        if (dateformats_initialized) {
            return;
        }
        Locale locale = new Locale("En", "Us", "Unix");
        dateFormats = new SimpleDateFormat[3];
        URLConnection.dateFormats[0] = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", locale);
        URLConnection.dateFormats[1] = new SimpleDateFormat("EEEE, dd-MMM-yy hh:mm:ss 'GMT'", locale);
        URLConnection.dateFormats[2] = new SimpleDateFormat("EEE MMM d hh:mm:ss yyyy", locale);
        dateformats_initialized = true;
    }

    private final /* synthetic */ void this() {
        this.doInput = true;
    }

    protected URLConnection(URL url) {
        this.this();
        this.url = url;
        this.allowUserInteraction = defaultAllowUserInteraction;
        this.useCaches = defaultUseCaches;
    }

    static {
        defaultUseCaches = true;
    }
}

