/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public boolean contains(double x, double y) {
        double mx = this.getX();
        double mw = this.getWidth();
        if (x < mx || x >= mx + mw) {
            return false;
        }
        double my = this.getY();
        double mh = this.getHeight();
        if (y < my || y >= my + mh) {
            return false;
        }
        double dy = Math.min(Math.abs(my - y), Math.abs(my + mh - y));
        double dx = Math.min(Math.abs(mx - x), Math.abs(mx + mw - x));
        double aw = this.getArcWidth() / (double)2;
        double ah = this.getArcHeight() / (double)2;
        if (dx > aw || dy > ah) {
            return true;
        }
        dy = (ah - dy) / ah;
        dx = (aw - dx) / aw;
        boolean bl = false;
        if (dx * dx + dy * dy <= 1.0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(double x, double y, double w, double h) {
        boolean bl = false;
        if (this.contains(x, y) && this.contains(x, y + h) && this.contains(x + w, y + h) && this.contains(x + w, y)) {
            bl = true;
        }
        return bl;
    }

    public PathIterator getPathIterator(final AffineTransform at) {
        final double minx = this.getX();
        final double miny = this.getY();
        final double maxx = minx + this.getWidth();
        final double maxy = miny + this.getHeight();
        final double arcwidth = this.getArcWidth();
        final double archeight = this.getArcHeight();
        return new PathIterator(){
            private int current;
            private PathIterator corner;
            private Arc2D arc;
            private double[] temp;

            public final int getWindingRule() {
                return 1;
            }

            public final boolean isDone() {
                boolean bl = false;
                if (this.current > 9) {
                    bl = true;
                }
                return bl;
            }

            private final void getPoint(int val) {
                switch (val) {
                    case 0: 
                    case 8: {
                        this.temp[0] = maxx;
                        this.temp[1] = miny + archeight;
                        break;
                    }
                    case 7: {
                        this.temp[0] = maxx;
                        this.temp[1] = maxy - archeight;
                        break;
                    }
                    case 6: {
                        this.temp[0] = maxx - arcwidth;
                        this.temp[1] = maxy;
                        break;
                    }
                    case 5: {
                        this.temp[0] = minx + arcwidth;
                        this.temp[1] = maxy;
                        break;
                    }
                    case 4: {
                        this.temp[0] = minx;
                        this.temp[1] = maxy - archeight;
                        break;
                    }
                    case 3: {
                        this.temp[0] = minx;
                        this.temp[1] = miny + archeight;
                        break;
                    }
                    case 2: {
                        this.temp[0] = minx + arcwidth;
                        this.temp[1] = miny;
                        break;
                    }
                    case 1: {
                        this.temp[0] = maxx - arcwidth;
                        this.temp[1] = miny;
                        break;
                    }
                }
            }

            public final void next() {
                if (this.current >= 8) {
                    ++this.current;
                } else if (this.corner != null) {
                    this.corner.next();
                    if (this.corner.isDone()) {
                        this.corner = null;
                        ++this.current;
                    }
                } else {
                    this.getPoint(this.current);
                    double x1 = this.temp[0];
                    double y1 = this.temp[1];
                    this.getPoint(this.current + 1);
                    Rectangle2D.Double r = new Rectangle2D.Double(Math.min(x1, this.temp[0]), Math.min(y1, this.temp[1]), Math.abs(x1 - this.temp[0]), Math.abs(y1 - this.temp[1]));
                    this.arc.setArc(r, (double)(this.current >> 1) * 90.0, 90.0, 0);
                    this.corner = this.arc.getPathIterator(at);
                }
            }

            public final int currentSegment(float[] coords) {
                if (this.corner != null) {
                    int r = this.corner.currentSegment(coords);
                    if (r == 0) {
                        r = 1;
                    }
                    return r;
                }
                if (this.current >= 9) {
                    if (this.current == 9) {
                        return 4;
                    }
                    throw new NoSuchElementException("rect iterator out of bounds");
                }
                this.getPoint(this.current);
                coords[0] = (float)this.temp[0];
                coords[1] = (float)this.temp[1];
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                int n = 0;
                if (this.current == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            public final int currentSegment(double[] coords) {
                if (this.corner != null) {
                    int r = this.corner.currentSegment(coords);
                    if (r == 0) {
                        r = 1;
                    }
                    return r;
                }
                if (this.current >= 9) {
                    if (this.current == 9) {
                        return 4;
                    }
                    throw new NoSuchElementException("rect iterator out of bounds");
                }
                this.getPoint(this.current);
                coords[0] = this.temp[0];
                coords[1] = this.temp[1];
                if (at != null) {
                    at.transform(coords, 0, coords, 0, 1);
                }
                int n = 0;
                if (this.current == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            private final /* synthetic */ void this() {
                this.current = 0;
                this.arc = new Arc2D.Double();
                this.temp = new double[2];
            }
            {
                this.this();
            }
        };
    }

    public boolean intersects(double x, double y, double w, double h) {
        boolean bl = false;
        if (this.contains(x, y) || this.contains(x, y + h) || this.contains(x + w, y + h) || this.contains(x + w, y)) {
            bl = true;
        }
        return bl;
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(RoundRectangle2D rr) {
        this.setRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
    }

    protected RoundRectangle2D() {
    }

    public static class Float
    extends RoundRectangle2D {
        public float archeight;
        public float arcwidth;
        public float x;
        public float y;
        public float width;
        public float height;

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0f || this.height <= 0.0f) {
                bl = true;
            }
            return bl;
        }

        public void setRoundRect(float x, float y, float w, float h, float arcWidth, float arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
            this.arcwidth = (float)arcWidth;
            this.archeight = (float)arcHeight;
        }

        public Float() {
        }

        public Float(float x, float y, float w, float h, float arcWidth, float arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }
    }

    public static class Double
    extends RoundRectangle2D {
        public double archeight;
        public double arcwidth;
        public double x;
        public double y;
        public double width;
        public double height;

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0 || this.height <= 0.0) {
                bl = true;
            }
            return bl;
        }

        public void setRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }

        public Double() {
        }

        public Double(double x, double y, double w, double h, double arcWidth, double arcHeight) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcWidth;
            this.archeight = arcHeight;
        }
    }
}

