/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GtkImageConsumer
implements ImageConsumer {
    private GtkImage target;
    private int width;
    private int height;
    private Hashtable properties;
    private int[] pixelCache;
    private ImageProducer source;

    public synchronized void imageComplete(int status) {
        if (!(this.source instanceof MemoryImageSource)) {
            this.source.removeConsumer(this);
        }
        this.target.setImage(this.width, this.height, this.pixelCache, this.properties);
    }

    public synchronized void setColorModel(ColorModel model) {
    }

    public synchronized void setDimensions(int width, int height) {
        this.pixelCache = new int[width * height];
        this.width = width;
        this.height = height;
    }

    public synchronized void setHints(int flags) {
    }

    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, byte[] pixels, int offset, int scansize) {
        this.setPixels(x, y, width, height, cm, this.convertPixels(pixels), offset, scansize);
    }

    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, int[] pixels, int offset, int scansize) {
        if (this.pixelCache == null) {
            return;
        }
        if (cm.equals(GtkImage.nativeModel)) {
            int i = 0;
            while (i < height) {
                System.arraycopy(pixels, offset + i * scansize, this.pixelCache, (y + i) * this.width + x, width);
                ++i;
            }
        } else {
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pix = cm.getRGB(pixels[offset + i * scansize + x + j]);
                    byte b = (byte)(pix & 0xFF);
                    byte r = (byte)((pix & 0xFF0000) >> 16 & 0xFF);
                    pix &= 0xFF00FF00;
                    pix |= (b & 0xFF) << 16;
                    this.pixelCache[(y + i) * this.width + x + j] = pix |= r & 0xFF;
                    ++j;
                }
                ++i;
            }
        }
    }

    private final int[] convertPixels(byte[] pixels) {
        int[] ret = new int[pixels.length];
        int i = 0;
        while (i < pixels.length) {
            ret[i] = pixels[i] & 0xFF;
            ++i;
        }
        return ret;
    }

    public synchronized void setProperties(Hashtable props) {
        this.properties = props;
    }

    private final /* synthetic */ void this() {
        this.pixelCache = null;
    }

    public GtkImageConsumer(GtkImage target, ImageProducer source) {
        this.this();
        this.target = target;
        this.source = source;
    }
}

