/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.Serializable;

public class BeanContextChildSupport
implements BeanContextChild,
BeanContextServicesListener,
Serializable {
    static final long serialVersionUID = 6328947014421475877L;
    public BeanContextChild beanContextChildPeer;
    protected transient BeanContext beanContext;
    protected transient boolean rejectedSetBCOnce;
    protected PropertyChangeSupport pcSupport;
    protected VetoableChangeSupport vcSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBeanContext(BeanContext newBeanContext) throws PropertyVetoException {
        BeanContextChild beanContextChild = this.beanContextChildPeer;
        synchronized (beanContextChild) {
            if (newBeanContext == this.beanContext) {
                return;
            }
            if (!this.rejectedSetBCOnce) {
                if (!this.validatePendingSetBeanContext(newBeanContext)) {
                    this.rejectedSetBCOnce = true;
                    throw new PropertyVetoException("validatePendingSetBeanContext() rejected change", new PropertyChangeEvent(this.beanContextChildPeer, "beanContext", this.beanContext, newBeanContext));
                }
                try {
                    this.fireVetoableChange("beanContext", this.beanContext, newBeanContext);
                }
                catch (PropertyVetoException e) {
                    this.rejectedSetBCOnce = true;
                    throw e;
                }
            }
            this.releaseBeanContextResources();
            this.beanContext = newBeanContext;
            this.rejectedSetBCOnce = false;
            this.firePropertyChange("beanContext", this.beanContext, newBeanContext);
            this.initializeBeanContextResources();
            return;
        }
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public BeanContextChild getBeanContextChildPeer() {
        return this.beanContextChildPeer;
    }

    public boolean isDelegated() {
        boolean bl = false;
        if (this.beanContextChildPeer == this) {
            bl = true;
        }
        return bl;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcSupport.addVetoableChangeListener(propertyName, listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcSupport.removeVetoableChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        this.pcSupport.firePropertyChange(propertyName, oldVal, newVal);
    }

    public void fireVetoableChange(String propertyName, Object oldVal, Object newVal) throws PropertyVetoException {
        this.vcSupport.fireVetoableChange(propertyName, oldVal, newVal);
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent event) {
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent event) {
    }

    public boolean validatePendingSetBeanContext(BeanContext newBeanContext) {
        return true;
    }

    protected void releaseBeanContextResources() {
    }

    protected void initializeBeanContextResources() {
    }

    public BeanContextChildSupport() {
        this(null);
    }

    public BeanContextChildSupport(BeanContextChild peer) {
        if (peer == null) {
            peer = this;
        }
        this.beanContextChildPeer = peer;
        this.pcSupport = new PropertyChangeSupport(peer);
        this.vcSupport = new VetoableChangeSupport(peer);
    }
}

