/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    static final int SUPER = 32;
    static final int ALL_FLAGS = 4095;

    public static boolean isAbstract(int mod) {
        boolean bl = false;
        if ((mod & 0x400) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isFinal(int mod) {
        boolean bl = false;
        if ((mod & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInterface(int mod) {
        boolean bl = false;
        if ((mod & 0x200) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNative(int mod) {
        boolean bl = false;
        if ((mod & 0x100) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPrivate(int mod) {
        boolean bl = false;
        if ((mod & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isProtected(int mod) {
        boolean bl = false;
        if ((mod & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPublic(int mod) {
        boolean bl = false;
        if ((mod & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStatic(int mod) {
        boolean bl = false;
        if ((mod & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStrict(int mod) {
        boolean bl = false;
        if ((mod & 0x800) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isSynchronized(int mod) {
        boolean bl = false;
        if ((mod & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isTransient(int mod) {
        boolean bl = false;
        if ((mod & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isVolatile(int mod) {
        boolean bl = false;
        if ((mod & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public static String toString(int mod) {
        return Modifier.toString(mod, new StringBuffer()).toString();
    }

    static StringBuffer toString(int mod, StringBuffer r) {
        if (Modifier.isPublic(mod)) {
            r.append("public ");
        }
        if (Modifier.isProtected(mod)) {
            r.append("protected ");
        }
        if (Modifier.isPrivate(mod)) {
            r.append("private ");
        }
        if (Modifier.isAbstract(mod)) {
            r.append("abstract ");
        }
        if (Modifier.isStatic(mod)) {
            r.append("static ");
        }
        if (Modifier.isFinal(mod)) {
            r.append("final ");
        }
        if (Modifier.isTransient(mod)) {
            r.append("transient ");
        }
        if (Modifier.isVolatile(mod)) {
            r.append("volatile ");
        }
        if (Modifier.isSynchronized(mod)) {
            r.append("synchronized ");
        }
        if (Modifier.isNative(mod)) {
            r.append("native ");
        }
        if (Modifier.isStrict(mod)) {
            r.append("strictfp ");
        }
        if (Modifier.isInterface(mod)) {
            r.append("interface ");
        }
        if ((mod & 0xFFF) != 0) {
            r.setLength(r.length() - 1);
        }
        return r;
    }
}

