/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESedeKeySpec
implements KeySpec {
    public static final int DES_EDE_KEY_LEN = 24;
    private byte[] key;

    public static boolean isParityAdjusted(byte[] key, int offset) throws InvalidKeyException {
        if (key.length - offset < 24) {
            throw new InvalidKeyException("DES-EDE keys must be 24 bytes long");
        }
        boolean parity = false;
        boolean oddbits = false;
        int i = 0;
        while (i < 24) {
            oddbits = false;
            int j = 0;
            while (j < 8) {
                boolean bl = false;
                if ((key[i + offset] & 1 << j) != 0) {
                    bl = true;
                }
                oddbits ^= bl;
                ++j;
            }
            parity &= oddbits;
            ++i;
        }
        return parity;
    }

    public byte[] getKey() {
        return this.key;
    }

    public DESedeKeySpec(byte[] key) throws InvalidKeyException {
        this(key, 0);
    }

    public DESedeKeySpec(byte[] key, int offset) throws InvalidKeyException {
        if (key.length - offset < 24) {
            throw new InvalidKeyException("DES-EDE keys must be 24 bytes long");
        }
        this.key = new byte[24];
        System.arraycopy(key, offset, this.key, 0, 24);
    }
}

