require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_CONF_H_)) {
    eval 'sub _SYS_CONF_H_ () {1;}' unless defined(&_SYS_CONF_H_);
    require 'sys/device_if.ph';
    require 'sys/queue.ph';
    require 'sys/types.ph';
    eval 'sub D_OTHER () {0x;}' unless defined(&D_OTHER);
    eval 'sub D_TAPE () {0x1;}' unless defined(&D_TAPE);
    eval 'sub D_DISK () {0x2;}' unless defined(&D_DISK);
    eval 'sub D_TTY () {0x3;}' unless defined(&D_TTY);
    eval 'sub D_TYPEMASK () {0xff;}' unless defined(&D_TYPEMASK);
    eval 'sub D_MPSAFE () {0x100;}' unless defined(&D_MPSAFE);
    eval 'sub D_NEGOFFSAFE () {0x200;}' unless defined(&D_NEGOFFSAFE);
    eval 'sub D_UNUSED0 () {0x400;}' unless defined(&D_UNUSED0);
    if(defined(&_KERNEL)) {
	require 'sys/mutex.ph';
	eval 'sub dev_type_open {
	    my($n) = @_;
    	    eval q( &dev_open_t $n);
	}' unless defined(&dev_type_open);
	eval 'sub dev_type_cancel {
	    my($n) = @_;
    	    eval q( &dev_cancel_t $n);
	}' unless defined(&dev_type_cancel);
	eval 'sub dev_type_close {
	    my($n) = @_;
    	    eval q( &dev_close_t $n);
	}' unless defined(&dev_type_close);
	eval 'sub dev_type_read {
	    my($n) = @_;
    	    eval q( &dev_read_t $n);
	}' unless defined(&dev_type_read);
	eval 'sub dev_type_write {
	    my($n) = @_;
    	    eval q( &dev_write_t $n);
	}' unless defined(&dev_type_write);
	eval 'sub dev_type_ioctl {
	    my($n) = @_;
    	    eval q( &dev_ioctl_t $n);
	}' unless defined(&dev_type_ioctl);
	eval 'sub dev_type_stop {
	    my($n) = @_;
    	    eval q( &dev_stop_t $n);
	}' unless defined(&dev_type_stop);
	eval 'sub dev_type_tty {
	    my($n) = @_;
    	    eval q( &dev_tty_t $n);
	}' unless defined(&dev_type_tty);
	eval 'sub dev_type_poll {
	    my($n) = @_;
    	    eval q( &dev_poll_t $n);
	}' unless defined(&dev_type_poll);
	eval 'sub dev_type_mmap {
	    my($n) = @_;
    	    eval q( &dev_mmap_t $n);
	}' unless defined(&dev_type_mmap);
	eval 'sub dev_type_strategy {
	    my($n) = @_;
    	    eval q( &dev_strategy_t $n);
	}' unless defined(&dev_type_strategy);
	eval 'sub dev_type_dump {
	    my($n) = @_;
    	    eval q( &dev_dump_t $n);
	}' unless defined(&dev_type_dump);
	eval 'sub dev_type_size {
	    my($n) = @_;
    	    eval q( &dev_size_t $n);
	}' unless defined(&dev_type_size);
	eval 'sub dev_type_kqfilter {
	    my($n) = @_;
    	    eval q( &dev_kqfilter_t $n);
	}' unless defined(&dev_type_kqfilter);
	eval 'sub dev_type_discard {
	    my($n) = @_;
    	    eval q( &dev_discard_t $n);
	}' unless defined(&dev_type_discard);
	eval 'sub noopen () {(( &dev_open_t *) &devenodev);}' unless defined(&noopen);
	eval 'sub noclose () {(( &dev_close_t *) &devenodev);}' unless defined(&noclose);
	eval 'sub noread () {(( &dev_read_t *) &devenodev);}' unless defined(&noread);
	eval 'sub nowrite () {(( &dev_write_t *) &devenodev);}' unless defined(&nowrite);
	eval 'sub noioctl () {(( &dev_ioctl_t *) &devenodev);}' unless defined(&noioctl);
	eval 'sub nostop () {(( &dev_stop_t *) &ttyvenodev);}' unless defined(&nostop);
	eval 'sub notty () { &NULL;}' unless defined(&notty);
	eval 'sub nopoll () { &seltrue;}' unless defined(&nopoll);
	eval 'sub nodump () {(( &dev_dump_t *) &devenodev);}' unless defined(&nodump);
	eval 'sub nosize () { &NULL;}' unless defined(&nosize);
	eval 'sub nokqfilter () { &seltrue_kqfilter;}' unless defined(&nokqfilter);
	eval 'sub nodiscard () {(( &dev_discard_t *) &devenodev);}' unless defined(&nodiscard);
	eval 'sub nullopen () {(( &dev_open_t *) &devnullop);}' unless defined(&nullopen);
	eval 'sub nullclose () {(( &dev_close_t *) &devnullop);}' unless defined(&nullclose);
	eval 'sub nullread () {(( &dev_read_t *) &devnullop);}' unless defined(&nullread);
	eval 'sub nullwrite () {(( &dev_write_t *) &devnullop);}' unless defined(&nullwrite);
	eval 'sub nullioctl () {(( &dev_ioctl_t *) &devnullop);}' unless defined(&nullioctl);
	eval 'sub nullstop () {(( &dev_stop_t *) &ttyvnullop);}' unless defined(&nullstop);
	eval 'sub nullpoll () {(( &dev_poll_t *) &devnullop);}' unless defined(&nullpoll);
	eval 'sub nulldump () {(( &dev_dump_t *) &devnullop);}' unless defined(&nulldump);
	eval 'sub nullkqfilter () {(( &dev_kqfilter_t *) &deveopnotsupp);}' unless defined(&nullkqfilter);
	eval 'sub nulldiscard () {(( &dev_discard_t *) &devnullop);}' unless defined(&nulldiscard);
    }
    if(defined(&_KERNEL)) {
	eval 'sub ttynodisc () {(( &int (*)( &dev_t, \'struct tty\' *)) &devenodev);}' unless defined(&ttynodisc);
	eval 'sub ttyerrclose () {(( &int (*)(\'struct tty\' *, \'int\')) &ttyenodev);}' unless defined(&ttyerrclose);
	eval 'sub ttyerrio () {(( &int (*)(\'struct tty\' *, \'struct uio\' *, \'int\')) &ttyenodev);}' unless defined(&ttyerrio);
	eval 'sub ttyerrstart () {(( &int (*)) &ttyenodev);}' unless defined(&ttyerrstart);
    }
    if(defined(&_KERNEL)) {
	eval 'sub DEV_MEM () {0;}' unless defined(&DEV_MEM);
	eval 'sub DEV_KMEM () {1;}' unless defined(&DEV_KMEM);
	eval 'sub DEV_NULL () {2;}' unless defined(&DEV_NULL);
	if(defined(&COMPAT_16)) {
	    eval 'sub _DEV_ZERO_oARM () {3;}' unless defined(&_DEV_ZERO_oARM);
	}
	eval 'sub DEV_FULL () {11;}' unless defined(&DEV_FULL);
	eval 'sub DEV_ZERO () {12;}' unless defined(&DEV_ZERO);
	eval("sub DEVNODE_DONTBOTHER () { 0; }") unless defined(&DEVNODE_DONTBOTHER);
	eval("sub DEVNODE_SINGLE () { 1; }") unless defined(&DEVNODE_SINGLE);
	eval("sub DEVNODE_VECTOR () { 2; }") unless defined(&DEVNODE_VECTOR);
	eval 'sub DEVNODE_FLAG_LINKZERO () {0x1;}' unless defined(&DEVNODE_FLAG_LINKZERO);
	eval 'sub DEVNODE_FLAG_ISMINOR0 () {0x2;}' unless defined(&DEVNODE_FLAG_ISMINOR0);
	if(defined(&notyet)) {
	    eval 'sub DEVNODE_FLAG_ISMINOR1 () {0x4;}' unless defined(&DEVNODE_FLAG_ISMINOR1);
	}
    }
    if(defined(&_KERNEL)) {
    }
}
1;
