require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_CRYPTO_H)) {
    eval 'sub HEADER_CRYPTO_H () {1;}' unless defined(&HEADER_CRYPTO_H);
    require 'stdlib.ph';
    require 'time.ph';
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
    }
    require 'openssl/safestack.ph';
    require 'openssl/opensslv.ph';
    require 'openssl/ossl_typ.ph';
    require 'openssl/opensslconf.ph';
    require 'openssl/cryptoerr.ph';
    if(defined(&CHARSET_EBCDIC)) {
	require 'openssl/ebcdic.ph';
    }
    require 'openssl/symhacks.ph';
    if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	require 'openssl/opensslv.ph';
    }
    if(defined(&__cplusplus)) {
    }
    if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	eval 'sub SSLeay () { &OpenSSL_version_num;}' unless defined(&SSLeay);
	eval 'sub SSLeay_version () { &OpenSSL_version;}' unless defined(&SSLeay_version);
	eval 'sub SSLEAY_VERSION_NUMBER () { &OPENSSL_VERSION_NUMBER;}' unless defined(&SSLEAY_VERSION_NUMBER);
	eval 'sub SSLEAY_VERSION () { &OPENSSL_VERSION;}' unless defined(&SSLEAY_VERSION);
	eval 'sub SSLEAY_CFLAGS () { &OPENSSL_CFLAGS;}' unless defined(&SSLEAY_CFLAGS);
	eval 'sub SSLEAY_BUILT_ON () { &OPENSSL_BUILT_ON;}' unless defined(&SSLEAY_BUILT_ON);
	eval 'sub SSLEAY_PLATFORM () { &OPENSSL_PLATFORM;}' unless defined(&SSLEAY_PLATFORM);
	eval 'sub SSLEAY_DIR () { &OPENSSL_DIR;}' unless defined(&SSLEAY_DIR);
    }
    eval 'sub CRYPTO_MEM_CHECK_OFF () {0x;}' unless defined(&CRYPTO_MEM_CHECK_OFF);
    eval 'sub CRYPTO_MEM_CHECK_ON () {0x1;}' unless defined(&CRYPTO_MEM_CHECK_ON);
    eval 'sub CRYPTO_MEM_CHECK_ENABLE () {0x2;}' unless defined(&CRYPTO_MEM_CHECK_ENABLE);
    eval 'sub CRYPTO_MEM_CHECK_DISABLE () {0x3;}' unless defined(&CRYPTO_MEM_CHECK_DISABLE);
    eval 'sub CRYPTO_EX_INDEX_SSL () {0;}' unless defined(&CRYPTO_EX_INDEX_SSL);
    eval 'sub CRYPTO_EX_INDEX_SSL_CTX () {1;}' unless defined(&CRYPTO_EX_INDEX_SSL_CTX);
    eval 'sub CRYPTO_EX_INDEX_SSL_SESSION () {2;}' unless defined(&CRYPTO_EX_INDEX_SSL_SESSION);
    eval 'sub CRYPTO_EX_INDEX_X509 () {3;}' unless defined(&CRYPTO_EX_INDEX_X509);
    eval 'sub CRYPTO_EX_INDEX_X509_STORE () {4;}' unless defined(&CRYPTO_EX_INDEX_X509_STORE);
    eval 'sub CRYPTO_EX_INDEX_X509_STORE_CTX () {5;}' unless defined(&CRYPTO_EX_INDEX_X509_STORE_CTX);
    eval 'sub CRYPTO_EX_INDEX_DH () {6;}' unless defined(&CRYPTO_EX_INDEX_DH);
    eval 'sub CRYPTO_EX_INDEX_DSA () {7;}' unless defined(&CRYPTO_EX_INDEX_DSA);
    eval 'sub CRYPTO_EX_INDEX_EC_KEY () {8;}' unless defined(&CRYPTO_EX_INDEX_EC_KEY);
    eval 'sub CRYPTO_EX_INDEX_RSA () {9;}' unless defined(&CRYPTO_EX_INDEX_RSA);
    eval 'sub CRYPTO_EX_INDEX_ENGINE () {10;}' unless defined(&CRYPTO_EX_INDEX_ENGINE);
    eval 'sub CRYPTO_EX_INDEX_UI () {11;}' unless defined(&CRYPTO_EX_INDEX_UI);
    eval 'sub CRYPTO_EX_INDEX_BIO () {12;}' unless defined(&CRYPTO_EX_INDEX_BIO);
    eval 'sub CRYPTO_EX_INDEX_APP () {13;}' unless defined(&CRYPTO_EX_INDEX_APP);
    eval 'sub CRYPTO_EX_INDEX_UI_METHOD () {14;}' unless defined(&CRYPTO_EX_INDEX_UI_METHOD);
    eval 'sub CRYPTO_EX_INDEX_DRBG () {15;}' unless defined(&CRYPTO_EX_INDEX_DRBG);
    eval 'sub CRYPTO_EX_INDEX__COUNT () {16;}' unless defined(&CRYPTO_EX_INDEX__COUNT);
    eval 'sub OPENSSL_malloc_init () {
        eval q( &while(0)  &continue);
    }' unless defined(&OPENSSL_malloc_init);
    eval 'sub OPENSSL_malloc {
        my($num) = @_;
	    eval q( &CRYPTO_malloc($num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_malloc);
    eval 'sub OPENSSL_zalloc {
        my($num) = @_;
	    eval q( &CRYPTO_zalloc($num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_zalloc);
    eval 'sub OPENSSL_realloc {
        my($addr, $num) = @_;
	    eval q( &CRYPTO_realloc($addr, $num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_realloc);
    eval 'sub OPENSSL_clear_realloc {
        my($addr, $old_num, $num) = @_;
	    eval q( &CRYPTO_clear_realloc($addr, $old_num, $num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_clear_realloc);
    eval 'sub OPENSSL_clear_free {
        my($addr, $num) = @_;
	    eval q( &CRYPTO_clear_free($addr, $num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_clear_free);
    eval 'sub OPENSSL_free {
        my($addr) = @_;
	    eval q( &CRYPTO_free($addr,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_free);
    eval 'sub OPENSSL_memdup {
        my($str, $s) = @_;
	    eval q( &CRYPTO_memdup(($str), $s,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_memdup);
    eval 'sub OPENSSL_strdup {
        my($str) = @_;
	    eval q( &CRYPTO_strdup($str,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_strdup);
    eval 'sub OPENSSL_strndup {
        my($str, $n) = @_;
	    eval q( &CRYPTO_strndup($str, $n,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_strndup);
    eval 'sub OPENSSL_secure_malloc {
        my($num) = @_;
	    eval q( &CRYPTO_secure_malloc($num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_secure_malloc);
    eval 'sub OPENSSL_secure_zalloc {
        my($num) = @_;
	    eval q( &CRYPTO_secure_zalloc($num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_secure_zalloc);
    eval 'sub OPENSSL_secure_free {
        my($addr) = @_;
	    eval q( &CRYPTO_secure_free($addr,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_secure_free);
    eval 'sub OPENSSL_secure_clear_free {
        my($addr, $num) = @_;
	    eval q( &CRYPTO_secure_clear_free($addr, $num,  &OPENSSL_FILE,  &OPENSSL_LINE));
    }' unless defined(&OPENSSL_secure_clear_free);
    eval 'sub OPENSSL_secure_actual_size {
        my($ptr) = @_;
	    eval q( &CRYPTO_secure_actual_size($ptr));
    }' unless defined(&OPENSSL_secure_actual_size);
    eval 'sub OPENSSL_MALLOC_MAX_NELEMS {
        my($type) = @_;
	    eval q((((1<<($sizeof{\'int\'}*8-1))-1)/$sizeof{$type}));
    }' unless defined(&OPENSSL_MALLOC_MAX_NELEMS);
    eval 'sub OPENSSL_VERSION () {0;}' unless defined(&OPENSSL_VERSION);
    eval 'sub OPENSSL_CFLAGS () {1;}' unless defined(&OPENSSL_CFLAGS);
    eval 'sub OPENSSL_BUILT_ON () {2;}' unless defined(&OPENSSL_BUILT_ON);
    eval 'sub OPENSSL_PLATFORM () {3;}' unless defined(&OPENSSL_PLATFORM);
    eval 'sub OPENSSL_DIR () {4;}' unless defined(&OPENSSL_DIR);
    eval 'sub OPENSSL_ENGINES_DIR () {5;}' unless defined(&OPENSSL_ENGINES_DIR);
    if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	eval 'sub CRYPTO_cleanup_all_ex_data () {
	    eval q( &while(0)  &continue);
	}' unless defined(&CRYPTO_cleanup_all_ex_data);
	eval 'sub CRYPTO_num_locks () {
	    eval q((1));
	}' unless defined(&CRYPTO_num_locks);
	eval 'sub CRYPTO_set_locking_callback {
	    my($func) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_set_locking_callback);
	eval 'sub CRYPTO_get_locking_callback () {
	    eval q(( &NULL));
	}' unless defined(&CRYPTO_get_locking_callback);
	eval 'sub CRYPTO_set_add_lock_callback {
	    my($func) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_set_add_lock_callback);
	eval 'sub CRYPTO_get_add_lock_callback () {
	    eval q(( &NULL));
	}' unless defined(&CRYPTO_get_add_lock_callback);
	eval 'sub CRYPTO_LOCK () {1;}' unless defined(&CRYPTO_LOCK);
	eval 'sub CRYPTO_UNLOCK () {2;}' unless defined(&CRYPTO_UNLOCK);
	eval 'sub CRYPTO_READ () {4;}' unless defined(&CRYPTO_READ);
	eval 'sub CRYPTO_WRITE () {8;}' unless defined(&CRYPTO_WRITE);
	eval 'sub CRYPTO_THREADID_set_numeric {
	    my($id, $val) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_THREADID_set_numeric);
	eval 'sub CRYPTO_THREADID_set_pointer {
	    my($id, $ptr) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_THREADID_set_pointer);
	eval 'sub CRYPTO_THREADID_set_callback {
	    my($threadid_func) = @_;
    	    eval q((0));
	}' unless defined(&CRYPTO_THREADID_set_callback);
	eval 'sub CRYPTO_THREADID_get_callback () {
	    eval q(( &NULL));
	}' unless defined(&CRYPTO_THREADID_get_callback);
	eval 'sub CRYPTO_THREADID_current {
	    my($id) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_THREADID_current);
	eval 'sub CRYPTO_THREADID_cmp {
	    my($a, $b) = @_;
    	    eval q((-1));
	}' unless defined(&CRYPTO_THREADID_cmp);
	eval 'sub CRYPTO_THREADID_cpy {
	    my($dest, $src) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_THREADID_cpy);
	eval 'sub CRYPTO_THREADID_hash {
	    my($id) = @_;
    	    eval q((0));
	}' unless defined(&CRYPTO_THREADID_hash);
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10000000) {
	    eval 'sub CRYPTO_set_id_callback {
	        my($func) = @_;
    		eval q();
	    }' unless defined(&CRYPTO_set_id_callback);
	    eval 'sub CRYPTO_get_id_callback () {
	        eval q(( &NULL));
	    }' unless defined(&CRYPTO_get_id_callback);
	    eval 'sub CRYPTO_thread_id () {
	        eval q((0));
	    }' unless defined(&CRYPTO_thread_id);
	}
	eval 'sub CRYPTO_set_dynlock_create_callback {
	    my($dyn_create_function) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_set_dynlock_create_callback);
	eval 'sub CRYPTO_set_dynlock_lock_callback {
	    my($dyn_lock_function) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_set_dynlock_lock_callback);
	eval 'sub CRYPTO_set_dynlock_destroy_callback {
	    my($dyn_destroy_function) = @_;
    	    eval q();
	}' unless defined(&CRYPTO_set_dynlock_destroy_callback);
	eval 'sub CRYPTO_get_dynlock_create_callback () {
	    eval q(( &NULL));
	}' unless defined(&CRYPTO_get_dynlock_create_callback);
	eval 'sub CRYPTO_get_dynlock_lock_callback () {
	    eval q(( &NULL));
	}' unless defined(&CRYPTO_get_dynlock_lock_callback);
	eval 'sub CRYPTO_get_dynlock_destroy_callback () {
	    eval q(( &NULL));
	}' unless defined(&CRYPTO_get_dynlock_destroy_callback);
    }
    unless(defined(&OPENSSL_NO_CRYPTO_MDEBUG)) {
	eval 'sub OPENSSL_mem_debug_push {
	    my($info) = @_;
    	    eval q( &CRYPTO_mem_debug_push($info,  &OPENSSL_FILE,  &OPENSSL_LINE));
	}' unless defined(&OPENSSL_mem_debug_push);
	eval 'sub OPENSSL_mem_debug_pop () {
	    eval q( &CRYPTO_mem_debug_pop());
	}' unless defined(&OPENSSL_mem_debug_pop);
	unless(defined(&OPENSSL_NO_STDIO)) {
	}
    }
    if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	eval 'sub OpenSSLDie {
	    my($f,$l,$a) = @_;
    	    eval q( &OPENSSL_die(($a),($f),($l)));
	}' unless defined(&OpenSSLDie);
    }
    eval 'sub OPENSSL_assert {
        my($e) = @_;
	    eval q(( &void)(($e) ? 0: ( &OPENSSL_die(\\"assertion failed: \\" $e,  &OPENSSL_FILE,  &OPENSSL_LINE), 1)));
    }' unless defined(&OPENSSL_assert);
    if(defined(&OPENSSL_SYS_UNIX)) {
    }
    eval 'sub OPENSSL_INIT_NO_LOAD_CRYPTO_STRINGS () {0x1;}' unless defined(&OPENSSL_INIT_NO_LOAD_CRYPTO_STRINGS);
    eval 'sub OPENSSL_INIT_LOAD_CRYPTO_STRINGS () {0x2;}' unless defined(&OPENSSL_INIT_LOAD_CRYPTO_STRINGS);
    eval 'sub OPENSSL_INIT_ADD_ALL_CIPHERS () {0x4;}' unless defined(&OPENSSL_INIT_ADD_ALL_CIPHERS);
    eval 'sub OPENSSL_INIT_ADD_ALL_DIGESTS () {0x8;}' unless defined(&OPENSSL_INIT_ADD_ALL_DIGESTS);
    eval 'sub OPENSSL_INIT_NO_ADD_ALL_CIPHERS () {0x10;}' unless defined(&OPENSSL_INIT_NO_ADD_ALL_CIPHERS);
    eval 'sub OPENSSL_INIT_NO_ADD_ALL_DIGESTS () {0x20;}' unless defined(&OPENSSL_INIT_NO_ADD_ALL_DIGESTS);
    eval 'sub OPENSSL_INIT_LOAD_CONFIG () {0x40;}' unless defined(&OPENSSL_INIT_LOAD_CONFIG);
    eval 'sub OPENSSL_INIT_NO_LOAD_CONFIG () {0x80;}' unless defined(&OPENSSL_INIT_NO_LOAD_CONFIG);
    eval 'sub OPENSSL_INIT_ASYNC () {0x100;}' unless defined(&OPENSSL_INIT_ASYNC);
    eval 'sub OPENSSL_INIT_ENGINE_RDRAND () {0x200;}' unless defined(&OPENSSL_INIT_ENGINE_RDRAND);
    eval 'sub OPENSSL_INIT_ENGINE_DYNAMIC () {0x400;}' unless defined(&OPENSSL_INIT_ENGINE_DYNAMIC);
    eval 'sub OPENSSL_INIT_ENGINE_OPENSSL () {0x800;}' unless defined(&OPENSSL_INIT_ENGINE_OPENSSL);
    eval 'sub OPENSSL_INIT_ENGINE_CRYPTODEV () {0x1000;}' unless defined(&OPENSSL_INIT_ENGINE_CRYPTODEV);
    eval 'sub OPENSSL_INIT_ENGINE_CAPI () {0x2000;}' unless defined(&OPENSSL_INIT_ENGINE_CAPI);
    eval 'sub OPENSSL_INIT_ENGINE_PADLOCK () {0x4000;}' unless defined(&OPENSSL_INIT_ENGINE_PADLOCK);
    eval 'sub OPENSSL_INIT_ENGINE_AFALG () {0x8000;}' unless defined(&OPENSSL_INIT_ENGINE_AFALG);
    eval 'sub OPENSSL_INIT_ATFORK () {0x20000;}' unless defined(&OPENSSL_INIT_ATFORK);
    eval 'sub OPENSSL_INIT_NO_ATEXIT () {0x80000;}' unless defined(&OPENSSL_INIT_NO_ATEXIT);
    eval 'sub OPENSSL_INIT_ENGINE_ALL_BUILTIN () {( &OPENSSL_INIT_ENGINE_RDRAND |  &OPENSSL_INIT_ENGINE_DYNAMIC |  &OPENSSL_INIT_ENGINE_CRYPTODEV |  &OPENSSL_INIT_ENGINE_CAPI |  &OPENSSL_INIT_ENGINE_PADLOCK);}' unless defined(&OPENSSL_INIT_ENGINE_ALL_BUILTIN);
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    if(defined(&OPENSSL_THREADS)  && !defined(&CRYPTO_TDEBUG)) {
	if(defined(&_WIN32)) {
	    if(defined(&BASETYPES) || defined(&_WINDEF_H)) {
		eval 'sub CRYPTO_ONCE_STATIC_INIT () {0;}' unless defined(&CRYPTO_ONCE_STATIC_INIT);
	    }
	} else {
	    require 'pthread.ph';
	    eval 'sub CRYPTO_ONCE_STATIC_INIT () { &PTHREAD_ONCE_INIT;}' unless defined(&CRYPTO_ONCE_STATIC_INIT);
	}
    }
    if(!defined(&CRYPTO_ONCE_STATIC_INIT)) {
	eval 'sub CRYPTO_ONCE_STATIC_INIT () {0;}' unless defined(&CRYPTO_ONCE_STATIC_INIT);
    }
    if(defined(&__cplusplus)) {
    }
}
1;
