require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_MOUNT_H_)) {
    eval 'sub _SYS_MOUNT_H_ () {1;}' unless defined(&_SYS_MOUNT_H_);
    unless(defined(&_KERNEL)) {
	require 'sys/featuretest.ph';
	if(defined(&_NETBSD_SOURCE)) {
	    require 'sys/stat.ph';
	}
    }
    unless(defined(&_STANDALONE)) {
	require 'sys/param.ph';
	require 'sys/time.ph';
	require 'sys/ucred.ph';
	require 'sys/fstypes.ph';
	require 'sys/statvfs.ph';
	if(defined(&_KERNEL) || defined(&__EXPOSE_MOUNT)) {
	    require 'sys/uio.ph';
	    require 'sys/queue.ph';
	    require 'sys/rwlock.ph';
	    require 'sys/specificdata.ph';
	    require 'sys/condvar.ph';
	}
    }
    eval 'sub MNAMELEN () {90;}' unless defined(&MNAMELEN);
    eval 'sub MOUNT_FFS () {"ffs";}' unless defined(&MOUNT_FFS);
    eval 'sub MOUNT_UFS () { &MOUNT_FFS;}' unless defined(&MOUNT_UFS);
    eval 'sub MOUNT_NFS () {"nfs";}' unless defined(&MOUNT_NFS);
    eval 'sub MOUNT_MFS () {"mfs";}' unless defined(&MOUNT_MFS);
    eval 'sub MOUNT_MSDOS () {"msdos";}' unless defined(&MOUNT_MSDOS);
    eval 'sub MOUNT_LFS () {"lfs";}' unless defined(&MOUNT_LFS);
    eval 'sub MOUNT_FDESC () {"fdesc";}' unless defined(&MOUNT_FDESC);
    eval 'sub MOUNT_NULL () {"null";}' unless defined(&MOUNT_NULL);
    eval 'sub MOUNT_OVERLAY () {"overlay";}' unless defined(&MOUNT_OVERLAY);
    eval 'sub MOUNT_UMAP () {"umap";}' unless defined(&MOUNT_UMAP);
    eval 'sub MOUNT_KERNFS () {"kernfs";}' unless defined(&MOUNT_KERNFS);
    eval 'sub MOUNT_PROCFS () {"procfs";}' unless defined(&MOUNT_PROCFS);
    eval 'sub MOUNT_AFS () {"afs";}' unless defined(&MOUNT_AFS);
    eval 'sub MOUNT_CD9660 () {"cd9660";}' unless defined(&MOUNT_CD9660);
    eval 'sub MOUNT_UNION () {"union";}' unless defined(&MOUNT_UNION);
    eval 'sub MOUNT_ADOSFS () {"adosfs";}' unless defined(&MOUNT_ADOSFS);
    eval 'sub MOUNT_EXT2FS () {"ext2fs";}' unless defined(&MOUNT_EXT2FS);
    eval 'sub MOUNT_CFS () {"coda";}' unless defined(&MOUNT_CFS);
    eval 'sub MOUNT_CODA () { &MOUNT_CFS;}' unless defined(&MOUNT_CODA);
    eval 'sub MOUNT_FILECORE () {"filecore";}' unless defined(&MOUNT_FILECORE);
    eval 'sub MOUNT_NTFS () {"ntfs";}' unless defined(&MOUNT_NTFS);
    eval 'sub MOUNT_SMBFS () {"smbfs";}' unless defined(&MOUNT_SMBFS);
    eval 'sub MOUNT_PTYFS () {"ptyfs";}' unless defined(&MOUNT_PTYFS);
    eval 'sub MOUNT_TMPFS () {"tmpfs";}' unless defined(&MOUNT_TMPFS);
    eval 'sub MOUNT_UDF () {"udf";}' unless defined(&MOUNT_UDF);
    eval 'sub MOUNT_SYSVBFS () {"sysvbfs";}' unless defined(&MOUNT_SYSVBFS);
    eval 'sub MOUNT_PUFFS () {"puffs";}' unless defined(&MOUNT_PUFFS);
    eval 'sub MOUNT_HFS () {"hfs";}' unless defined(&MOUNT_HFS);
    eval 'sub MOUNT_EFS () {"efs";}' unless defined(&MOUNT_EFS);
    eval 'sub MOUNT_ZFS () {"zfs";}' unless defined(&MOUNT_ZFS);
    eval 'sub MOUNT_NILFS () {"nilfs";}' unless defined(&MOUNT_NILFS);
    eval 'sub MOUNT_RUMPFS () {"rumpfs";}' unless defined(&MOUNT_RUMPFS);
    eval 'sub MOUNT_V7FS () {"v7fs";}' unless defined(&MOUNT_V7FS);
    eval 'sub MOUNT_AUTOFS () {"autofs";}' unless defined(&MOUNT_AUTOFS);
    eval 'sub VFS_GENERIC () {0;}' unless defined(&VFS_GENERIC);
    eval 'sub VFS_MAXTYPENUM () {1;}' unless defined(&VFS_MAXTYPENUM);
    eval 'sub VFS_CONF () {2;}' unless defined(&VFS_CONF);
    eval 'sub VFS_USERMOUNT () {3;}' unless defined(&VFS_USERMOUNT);
    eval 'sub VFS_MAGICLINKS () {4;}' unless defined(&VFS_MAGICLINKS);
    eval 'sub VQ_MOUNT () {0x1;}' unless defined(&VQ_MOUNT);
    eval 'sub VQ_UNMOUNT () {0x2;}' unless defined(&VQ_UNMOUNT);
    unless(defined(&_STANDALONE)) {
	if(defined(&_KERNEL) || defined(&__EXPOSE_MOUNT)) {
	}
	if(defined(&_KERNEL)) {
	    eval 'sub VFS_VGET {
	        my($MP, $INO, $VPP) = @_;
    		eval q((*($MP)-> ($mnt_op->{vfs_vget}))($MP, $INO, $VPP));
	    }' unless defined(&VFS_VGET);
	    eval 'sub VFS_LOADVNODE {
	        my($MP, $VP, $KEY, $KEY_LEN, $NEW_KEY) = @_;
    		eval q((*($MP)-> ($mnt_op->{vfs_loadvnode}))($MP, $VP, $KEY, $KEY_LEN, $NEW_KEY));
	    }' unless defined(&VFS_LOADVNODE);
	    eval 'sub VFS_NEWVNODE {
	        my($MP, $DVP, $VP, $VAP, $CRED, $EXTRA, $NEW_LEN, $NEW_KEY) = @_;
    		eval q((*($MP)-> ($mnt_op->{vfs_newvnode}))($MP, $DVP, $VP, $VAP, $CRED, $EXTRA, $NEW_LEN, $NEW_KEY));
	    }' unless defined(&VFS_NEWVNODE);
	    eval 'sub VFS_RENAMELOCK_ENTER {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_op->{vfs_renamelock_enter}))($MP));
	    }' unless defined(&VFS_RENAMELOCK_ENTER);
	    eval 'sub VFS_RENAMELOCK_EXIT {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_op->{vfs_renamelock_exit}))($MP));
	    }' unless defined(&VFS_RENAMELOCK_EXIT);
	    eval 'sub VFS_FSYNC {
	        my($MP, $VP, $FLG) = @_;
    		eval q((*($MP)-> ($mnt_op->{vfs_fsync}))($VP, $FLG));
	    }' unless defined(&VFS_FSYNC);
	    eval 'sub VFS_MAX_MOUNT_DATA () {8192;}' unless defined(&VFS_MAX_MOUNT_DATA);
	    eval 'sub VFS_PROTOS {
	        my($fsname) = @_;
    		eval q(\'int\' $fsname &_mount(\'struct mount\' *,  &const \'char\' *,  &void *, \'size_t\' *); \'int\' $fsname &_start(\'struct mount\' *, \'int\'); \'int\' $fsname &_unmount(\'struct mount\' *, \'int\'); \'int\' $fsname &_root(\'struct mount\' *, \'struct vnode\' **); \'int\' $fsname &_quotactl(\'struct mount\' *, \'struct quotactl_args\' *); \'int\' $fsname &_statvfs(\'struct mount\' *, \'struct statvfs\' *); \'int\' $fsname &_sync(\'struct mount\' *, \'int\', \'struct kauth_cred\' *); \'int\' $fsname &_vget(\'struct mount\' *,  &ino_t, \'struct vnode\' **); \'int\' $fsname &_loadvnode(\'struct mount\' *, \'struct vnode\' *,  &const  &void *, \'size_t\',  &const  &void **); \'int\' $fsname &_newvnode(\'struct mount\' *, \'struct vnode\' *, \'struct vnode\' *, \'struct vattr\' *,  &kauth_cred_t,  &void *, \'size_t\' *,  &const  &void **); \'int\' $fsname &_fhtovp(\'struct mount\' *, \'struct fid\' *, \'struct vnode\' **); \'int\' $fsname &_vptofh(\'struct vnode\' *, \'struct fid\' *, \'size_t\' *);  &void $fsname &_init( &void);  &void $fsname &_reinit( &void);  &void $fsname &_done( &void); \'int\' $fsname &_mountroot( &void); \'int\' $fsname &_snapshot(\'struct mount\' *, \'struct vnode\' *, \'struct timespec\' *); \'int\' $fsname &_extattrctl(\'struct mount\' *, \'int\', \'struct vnode\' *, \'int\',  &const \'char\' *); \'int\' $fsname &_suspendctl(\'struct mount\' *, \'int\'));
	    }' unless defined(&VFS_PROTOS);
	    eval 'sub WAPBL_DISCARD {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_discard}))(($MP)-> &mnt_wapbl));
	    }' unless defined(&WAPBL_DISCARD);
	    eval 'sub WAPBL_REPLAY_ISOPEN {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_replay_isopen}))(($MP)-> &mnt_wapbl_replay));
	    }' unless defined(&WAPBL_REPLAY_ISOPEN);
	    eval 'sub WAPBL_REPLAY_CAN_READ {
	        my($MP, $BLK, $LEN) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_replay_can_read}))(($MP)-> &mnt_wapbl_replay, ($BLK), ($LEN)));
	    }' unless defined(&WAPBL_REPLAY_CAN_READ);
	    eval 'sub WAPBL_REPLAY_READ {
	        my($MP, $DATA, $BLK, $LEN) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_replay_read}))(($MP)-> &mnt_wapbl_replay, ($DATA), ($BLK), ($LEN)));
	    }' unless defined(&WAPBL_REPLAY_READ);
	    eval 'sub WAPBL_ADD_BUF {
	        my($MP, $BP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_add_buf}))(($MP)-> &mnt_wapbl, ($BP)));
	    }' unless defined(&WAPBL_ADD_BUF);
	    eval 'sub WAPBL_REMOVE_BUF {
	        my($MP, $BP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_remove_buf}))(($MP)-> &mnt_wapbl, ($BP)));
	    }' unless defined(&WAPBL_REMOVE_BUF);
	    eval 'sub WAPBL_RESIZE_BUF {
	        my($MP, $BP, $OLDSZ, $OLDCNT) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_resize_buf}))(($MP)-> &mnt_wapbl, ($BP), ($OLDSZ), ($OLDCNT)));
	    }' unless defined(&WAPBL_RESIZE_BUF);
	    eval 'sub WAPBL_BEGIN {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_begin}))(($MP)-> &mnt_wapbl,  &__FILE__,  &__LINE__));
	    }' unless defined(&WAPBL_BEGIN);
	    eval 'sub WAPBL_END {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_end}))(($MP)-> &mnt_wapbl));
	    }' unless defined(&WAPBL_END);
	    eval 'sub WAPBL_JUNLOCK_ASSERT {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_junlock_assert}))(($MP)-> &mnt_wapbl));
	    }' unless defined(&WAPBL_JUNLOCK_ASSERT);
	    eval 'sub WAPBL_JLOCK_ASSERT {
	        my($MP) = @_;
    		eval q((*($MP)-> ($mnt_wapbl_op->{wo_wapbl_jlock_assert}))(($MP)-> &mnt_wapbl));
	    }' unless defined(&WAPBL_JLOCK_ASSERT);
	}
	if(defined(&_KERNEL)) {
	    if(defined(&DEBUG)) {
	    }
	} else {
	    require 'sys/cdefs.ph';
	    if(!defined(&__LIBC12_SOURCE__)  && !defined(&_STANDALONE)) {
	    }
	    if(defined(&_NETBSD_SOURCE)) {
		unless(defined(&__LIBC12_SOURCE__)) {
		}
	    }
	}
    }
}
1;
