# This file was created automatically, do not edit!
#############################################################################
##
#W  docxpl.tst          GAP character table library             Thomas Breuer
##
#H  @(#)$Id: docxpl.tst,v 1.1 2001/05/21 15:39:45 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains the {\GAP} code of the examples in the
##  documentation files.
##
##  In order to run the tests, one starts {\GAP} from the `tst' subdirectory
##  of the `pkg/ctbllib' directory, and calls `ReadTest( "docxpl.tst" );'.
##

gap> START_TEST("$Id: docxpl.tst,v 1.1 2001/05/21 15:39:45 gap Exp $");


gap> s5:= CharacterTable( "A5.2" );
CharacterTable( "A5.2" )
gap> sym5:= CharacterTable( "Symmetric", 5 );
CharacterTable( "Sym(5)" )
gap> TransformingPermutationsCharacterTables( s5, sym5 );
rec( columns := (2,3,4,7,5), rows := (1,7,3,4,6,5,2), group := Group(()) )

gap> CharacterTable( "J5" );
fail
gap> CharacterTable( "A5" ) mod 2;
BrauerTable( "A5", 2 )

gap> tbl:= CharacterTable( "M11" );;
gap> HasMaxes( tbl );
true
gap> maxes:= Maxes( tbl );
[ "A6.2_3", "L2(11)", "3^2:Q8.2", "A5.2", "2.S4" ]
gap> CharacterTable( maxes[1] );
CharacterTable( "A6.2_3" )

gap> names:= AllCharacterTableNames();;

gap> simpnames:= AllCharacterTableNames( IsSimple, true );;
gap> AllCharacterTableNames( IsSimple, true, Size, [ 1 .. 100 ] );
[ "A5" ]

gap> maxesnames:= AllCharacterTableNames( IsSporadicSimple, true,
>                                         HasMaxes, true,
>                                         OfThose, Maxes );;

gap> c5:= CharacterTableSpecialized( CharacterTable( "Cyclic" ), 5 );
CharacterTable( "C5" )
gap> Display( c5 );
C5

     5  1  1  1  1  1

       1a 5a 5b 5c 5d
    5P 1a 1a 1a 1a 1a

X.1     1  1  1  1  1
X.2     1  A  B /B /A
X.3     1  B /A  A /B
X.4     1 /B  A /A  B
X.5     1 /A /B  B  A

A = E(5)
B = E(5)^2

gap> HasClassParameters( c5 );  HasCharacterParameters( c5 );
true
true
gap> ClassParameters( c5 );  CharacterParameters( c5 );
[ [ 1, 0 ], [ 1, 1 ], [ 1, 2 ], [ 1, 3 ], [ 1, 4 ] ]
[ [ 1, 0 ], [ 1, 1 ], [ 1, 2 ], [ 1, 3 ], [ 1, 4 ] ]
gap> ClassParameters( CharacterTable( "Symmetric", 3 ) );
[ [ 1, [ 1, 1, 1 ] ], [ 1, [ 2, 1 ] ], [ 1, [ 3 ] ] ]

gap> CharacterTable( "Cyclic" ).irreducibles[1][1]( 5, 2, 3 );
E(5)
gap> tbl:= CharacterTable( "Symmetric" );;
gap> tbl.irreducibles[1][1]( 5, [ 3, 2 ], [ 2, 2, 1 ] );
1
gap> tbl.orders[1]( 5, [ 2, 1, 1, 1 ] );
2

gap> CharacterTable( "A5" )!.projectives;
[ rec( name := "2.A5", 
      chars := [ [ 2, 0, -1, E(5)+E(5)^4, E(5)^2+E(5)^3 ], [ 2, 0, -1, 
              E(5)^2+E(5)^3, E(5)+E(5)^4 ], [ 4, 0, 1, -1, -1 ], 
          [ 6, 0, 0, 1, 1 ] ], map := [ 1, 3, 4, 6, 8 ] ) ]

gap> AtlasLabelsOfIrreducibles( CharacterTable( "3.A7.2" ) );
[ "\\chi_{1,0}", "\\chi_{1,1}", "\\chi_{2,0}", "\\chi_{2,1}", "\\chi_{3+4}", 
  "\\chi_{5,0}", "\\chi_{5,1}", "\\chi_{6,0}", "\\chi_{6,1}", "\\chi_{7,0}", 
  "\\chi_{7,1}", "\\chi_{8,0}", "\\chi_{8,1}", "\\chi_{9,0}", "\\chi_{9,1}", 
  "\\chi_{17+17\\ast 2}", "\\chi_{18+18\\ast 2}", "\\chi_{19+19\\ast 2}", 
  "\\chi_{20+20\\ast 2}", "\\chi_{21+21\\ast 2}", "\\chi_{22+23\\ast 8}", 
  "\\chi_{22\\ast 8+23}" ]
gap> AtlasLabelsOfIrreducibles( CharacterTable( "3.A7.2" ), "short" );
[ "\\chi_{1,0}", "\\chi_{1,1}", "\\chi_{2,0}", "\\chi_{2,1}", "\\chi_{3+}", 
  "\\chi_{5,0}", "\\chi_{5,1}", "\\chi_{6,0}", "\\chi_{6,1}", "\\chi_{7,0}", 
  "\\chi_{7,1}", "\\chi_{8,0}", "\\chi_{8,1}", "\\chi_{9,0}", "\\chi_{9,1}", 
  "\\chi_{17+}", "\\chi_{18+}", "\\chi_{19+}", "\\chi_{20+}", "\\chi_{21+}", 
  "\\chi_{22+}", "\\chi_{23+}" ]

gap> tbl:= CharacterTable( "m10" );
CharacterTable( "A6.2_3" )

gap> HasCASInfo( tbl );
true
gap> CASInfo( tbl );
[ rec( name := "m10", permchars := (3,5)(4,8,7,6), permclasses := (), 
      text := "names:     m10\norder:     2^4.3^2.5 = 720\nnumber of classes: \
8\nsource:    cambridge atlas\ncomments:  point stabilizer of mathieu-group m1\
1\ntest:      orth, min, sym[3]\n" ) ]

gap> First( ComputedClassFusions( tbl ), x -> x.name = "M11" );
rec( name := "M11", map := [ 1, 2, 3, 4, 5, 4, 7, 8 ], 
  text := "fusion is unique up to table automorphisms,\nthe representative is \
equal to the fusion map on the CAS table" )

gap> CharacterTable( "private" );
fail
gap> NotifyNameOfCharacterTable( "A5", [ "private" ] );
gap> a5:= CharacterTable( "private" );
CharacterTable( "A5" )

gap> s5:= CharacterTable( "S5" );
CharacterTable( "A5.2" )
gap> fus:= PossibleClassFusions( a5, s5 );
[ [ 1, 2, 3, 4, 4 ] ]
gap> fusion:= rec( name:= Identifier( s5 ), map:= fus[1], text:= "unique" );;
gap> Print( LibraryFusion( "A5", fusion ) );
ALF("A5","A5.2",[1,2,3,4,4],[
"unique"
]);

gap> IsBound( LOADED_PACKAGES.ctbllib );
true


gap> STOP_TEST( "docxpl.tst", 10000000 );


#############################################################################
##
#E

