/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SAMFileReader reader) {
        if (reader.hasBrowseableIndex()) {
            CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.getBrowseableIndex();
            int n_ref = existingIndex.getNumberOfReferences();
            int chunkCount = 0;
            int indexCount = 0;
            for (int i = 0; i < n_ref; ++i) {
                BAMIndexContent content = existingIndex.getQueryResults(i);
                for (Chunk c : content.getAllChunks()) {
                    SAMRecordIterator iter = reader.iterator(new BAMFileSpan(c));
                    ++chunkCount;
                    BAMRecord b = null;
                    try {
                        b = (BAMRecord)iter.next();
                        iter.close();
                    }
                    catch (Exception e) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + b + " in chunk " + c + " chunkCount=" + chunkCount, e);
                    }
                }
                LinearIndex linearIndex = content.getLinearIndex();
                for (long l : linearIndex.getIndexEntries()) {
                    try {
                        if (l == 0L) continue;
                        SAMRecordIterator iter = reader.iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                        BAMRecord b = (BAMRecord)iter.next();
                        ++indexCount;
                        iter.close();
                    }
                    catch (Exception e) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + indexCount, e);
                    }
                }
            }
            return chunkCount;
        }
        return 0;
    }
}

