/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.vcf.AbstractVCFCodec;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class VCF3Codec
extends AbstractVCFCodec {
    public static final String VCF3_MAGIC_HEADER = "##fileformat=VCFv3";

    @Override
    public Object readActualHeader(LineIterator reader) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        VCFHeaderVersion version = null;
        boolean foundHeaderVersion = false;
        while (reader.hasNext()) {
            ++this.lineNo;
            String line = reader.peek();
            if (line.startsWith("##")) {
                String[] lineFields = line.substring(2).split("=");
                if (lineFields.length == 2 && VCFHeaderVersion.isFormatString(lineFields[0])) {
                    if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
                        throw new TribbleException.InvalidHeader(lineFields[1] + " is not a supported version");
                    }
                    foundHeaderVersion = true;
                    version = VCFHeaderVersion.toHeaderVersion(lineFields[1]);
                    if (version != VCFHeaderVersion.VCF3_3 && version != VCFHeaderVersion.VCF3_2) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv3 and does not support " + lineFields[1]);
                    }
                }
                headerStrings.add((String)reader.next());
                continue;
            }
            if (line.startsWith("#")) {
                if (!foundHeaderVersion) {
                    throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                }
                headerStrings.add((String)reader.next());
                return super.parseHeaderFromLines(headerStrings, version);
            }
            throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected List<String> parseFilters(String filterString) {
        if (filterString.equals(".")) {
            return null;
        }
        ArrayList<String> fFields = new ArrayList<String>();
        if (filterString.equals("0")) {
            return new ArrayList<String>(fFields);
        }
        if (filterString.isEmpty()) {
            this.generateException("The VCF specification requires a valid filter status");
        }
        if (this.filterHash.containsKey(filterString)) {
            return new ArrayList<String>((Collection)this.filterHash.get(filterString));
        }
        if (filterString.indexOf(";") == -1) {
            fFields.add(filterString);
        } else {
            fFields.addAll(Arrays.asList(filterString.split(";")));
        }
        this.filterHash.put(filterString, fFields);
        return fFields;
    }

    @Override
    public boolean canDecode(String potentialInput) {
        return VCF3Codec.canDecodeFile(potentialInput, VCF3_MAGIC_HEADER);
    }
}

