require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MAC68K_BUS_H_)) {
    eval 'sub _MAC68K_BUS_H_ () {1;}' unless defined(&_MAC68K_BUS_H_);
    eval 'sub MAC68K_BUS_SPACE_MEM () {0;}' unless defined(&MAC68K_BUS_SPACE_MEM);
    eval 'sub __BUS_SPACE_HAS_STREAM_METHODS () {1;}' unless defined(&__BUS_SPACE_HAS_STREAM_METHODS);
    eval 'sub BSH_T () {\'struct bus_space_handle_s\';}' unless defined(&BSH_T);
    undef(&BSH_T) if defined(&BSH_T);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x4;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    eval 'sub bus_space_read_1 {
        my($t,$h,$o) = @_;
	    eval q(($h). &bsr1(($t), ($h), ($o)));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        my($t,$h,$o) = @_;
	    eval q(($h). &bsr2(($t), ($h), ($o)));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        my($t,$h,$o) = @_;
	    eval q(($h). &bsr4(($t), ($h), ($o)));
    }' unless defined(&bus_space_read_4);
    eval 'sub bus_space_read_stream_1 {
        my($t,$h,$o) = @_;
	    eval q(($h). &bsrs1(($t), ($h), ($o)));
    }' unless defined(&bus_space_read_stream_1);
    eval 'sub bus_space_read_stream_2 {
        my($t,$h,$o) = @_;
	    eval q(($h). &bsrs2(($t), ($h), ($o)));
    }' unless defined(&bus_space_read_stream_2);
    eval 'sub bus_space_read_stream_4 {
        my($t,$h,$o) = @_;
	    eval q(($h). &bsrs4(($t), ($h), ($o)));
    }' unless defined(&bus_space_read_stream_4);
    if(0) {
	eval 'sub bus_space_read_8 {
	    my($t, $h, $o) = @_;
    	    eval q(!!!  &bus_space_read_8  &unimplemented !!!);
	}' unless defined(&bus_space_read_8);
	eval 'sub bus_space_read_stream_8 {
	    my($t, $h, $o) = @_;
    	    eval q(!!!  &bus_space_read_stream_8  &unimplemented !!!);
	}' unless defined(&bus_space_read_stream_8);
    }
    if(defined(&DIAGNOSTIC)) {
	eval 'sub bus_space_read_multi_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_multi_1 called with zero count.\\"); ($h). &bsrm1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_multi_1);
	eval 'sub bus_space_read_multi_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_multi_2 called with zero count.\\"); ($h). &bsrm2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_multi_2);
	eval 'sub bus_space_read_multi_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_multi_4 called with zero count.\\"); ($h). &bsrm4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_multi_4);
	eval 'sub bus_space_read_multi_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_multi_stream_1 called with count=0.\\"); ($h). &bsrms1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_multi_stream_1);
	eval 'sub bus_space_read_multi_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_multi_stream_2 called with count=0.\\"); ($h). &bsrms2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_multi_stream_2);
	eval 'sub bus_space_read_multi_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_multi_stream_4 called with count=0.\\"); ($h). &bsrms4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_multi_stream_4);
    } else {
	eval 'sub bus_space_read_multi_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrm1($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_read_multi_1);
	eval 'sub bus_space_read_multi_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrm2($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_read_multi_2);
	eval 'sub bus_space_read_multi_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrm4($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_read_multi_4);
	eval 'sub bus_space_read_multi_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrms1($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_read_multi_stream_1);
	eval 'sub bus_space_read_multi_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrms2($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_read_multi_stream_2);
	eval 'sub bus_space_read_multi_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrms4($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_read_multi_stream_4);
    }
    if(0) {
	eval 'sub bus_space_read_multi_8 () {!!!  &bus_space_read_multi_8  &unimplemented !!!;}' unless defined(&bus_space_read_multi_8);
	eval 'sub bus_space_read_multi_stream_8 () {!!!  &bus_space_read_multi_stream_8  &unimplemented !!!;}' unless defined(&bus_space_read_multi_stream_8);
    }
    if(defined(&DIAGNOSTIC)) {
	eval 'sub bus_space_read_region_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_region_1 called with zero count.\\"); ($h). &bsrr1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_1);
	eval 'sub bus_space_read_region_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_region_2 called with zero count.\\"); ($h). &bsrr2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_2);
	eval 'sub bus_space_read_region_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_region_4 called with zero count.\\"); ($h). &bsrr4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_4);
	eval 'sub bus_space_read_region_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_region_stream_1 called with count=0.\\"); ($h). &bsrrs1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_stream_1);
	eval 'sub bus_space_read_region_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_region_stream_2 called with count=0.\\"); ($h). &bsrrs2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_stream_2);
	eval 'sub bus_space_read_region_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_read_region_stream_4 called with count=0.\\"); ($h). &bsrrs4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_stream_4);
    } else {
	eval 'sub bus_space_read_region_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrr1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_1);
	eval 'sub bus_space_read_region_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrr2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_2);
	eval 'sub bus_space_read_region_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrr4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_4);
	eval 'sub bus_space_read_region_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrrs1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_stream_1);
	eval 'sub bus_space_read_region_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrrs2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_stream_2);
	eval 'sub bus_space_read_region_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bsrrs4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_read_region_stream_4);
    }
    if(0) {
	eval 'sub bus_space_read_region_8 () {!!!  &bus_space_read_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_region_8);
	eval 'sub bus_space_read_region_stream_8 () {!!!  &bus_space_read_region_stream_8  &unimplemented !!!;}' unless defined(&bus_space_read_region_stream_8);
    }
    eval 'sub bus_space_write_1 {
        my($t, $h, $o, $v) = @_;
	    eval q(($h). &bsw1($t, ($h), $o, $v));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        my($t, $h, $o, $v) = @_;
	    eval q(($h). &bsw2($t, ($h), $o, $v));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        my($t, $h, $o, $v) = @_;
	    eval q(($h). &bsw4($t, ($h), $o, $v));
    }' unless defined(&bus_space_write_4);
    eval 'sub bus_space_write_stream_1 {
        my($t, $h, $o, $v) = @_;
	    eval q(($h). &bsws1($t, ($h), $o, $v));
    }' unless defined(&bus_space_write_stream_1);
    eval 'sub bus_space_write_stream_2 {
        my($t, $h, $o, $v) = @_;
	    eval q(($h). &bsws2($t, ($h), $o, $v));
    }' unless defined(&bus_space_write_stream_2);
    eval 'sub bus_space_write_stream_4 {
        my($t, $h, $o, $v) = @_;
	    eval q(($h). &bsws4($t, ($h), $o, $v));
    }' unless defined(&bus_space_write_stream_4);
    if(0) {
	eval 'sub bus_space_write_8 () {!!!  &bus_space_write_8  &not  &implemented !!!;}' unless defined(&bus_space_write_8);
	eval 'sub bus_space_write_stream_8 () {!!!  &bus_space_write_stream_8  &not  &implemented !!!;}' unless defined(&bus_space_write_stream_8);
    }
    if(defined(&DIAGNOSTIC)) {
	eval 'sub bus_space_write_multi_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_multi_1 called with zero count.\\"); ($h). &bswm1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_multi_1);
	eval 'sub bus_space_write_multi_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_multi_2 called with zero count.\\"); ($h). &bswm2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_multi_2);
	eval 'sub bus_space_write_multi_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_multi_4 called with zero count.\\"); ($h). &bswm4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_multi_4);
	eval 'sub bus_space_write_multi_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_multi_stream_1 called with count=0.\\"); ($h). &bswms1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_multi_stream_1);
	eval 'sub bus_space_write_multi_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_multi_stream_2 called with count=0.\\"); ($h). &bswms2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_multi_stream_2);
	eval 'sub bus_space_write_multi_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_multi_stream_4 called with count=0.\\"); ($h). &bswms4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_multi_stream_4);
    } else {
	eval 'sub bus_space_write_multi_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswm1($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_write_multi_1);
	eval 'sub bus_space_write_multi_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswm2($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_write_multi_2);
	eval 'sub bus_space_write_multi_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswm4($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_write_multi_4);
	eval 'sub bus_space_write_multi_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswms1($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_write_multi_stream_1);
	eval 'sub bus_space_write_multi_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswms2($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_write_multi_stream_2);
	eval 'sub bus_space_write_multi_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswms4($t, ($h), $o, $a, $c); }  &while (0));
	}' unless defined(&bus_space_write_multi_stream_4);
    }
    if(0) {
	eval 'sub bus_space_write_multi_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q(!!!  &bus_space_write_multi_8  &unimplimented !!!);
	}' unless defined(&bus_space_write_multi_8);
	eval 'sub bus_space_write_multi_stream_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q(!!!  &bus_space_write_multi_stream_8  &unimplimented !!!);
	}' unless defined(&bus_space_write_multi_stream_8);
    }
    if(defined(&DIAGNOSTIC)) {
	eval 'sub bus_space_write_region_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_region_1 called with zero count.\\"); ($h). &bswr1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_1);
	eval 'sub bus_space_write_region_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_region_2 called with zero count.\\"); ($h). &bswr2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_2);
	eval 'sub bus_space_write_region_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_region_4 called with zero count.\\"); ($h). &bswr4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_4);
	eval 'sub bus_space_write_region_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_region_stream_1 called with count=0.\\"); ($h). &bswrs1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_stream_1);
	eval 'sub bus_space_write_region_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_region_stream_2 called with count=0.\\"); ($h). &bswrs2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_stream_2);
	eval 'sub bus_space_write_region_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_write_region_stream_4 called with count=0.\\"); ($h). &bswrs4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_stream_4);
    } else {
	eval 'sub bus_space_write_region_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswr1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_1);
	eval 'sub bus_space_write_region_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswr2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_2);
	eval 'sub bus_space_write_region_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswr4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_4);
	eval 'sub bus_space_write_region_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswrs1($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_stream_1);
	eval 'sub bus_space_write_region_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswrs2($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_stream_2);
	eval 'sub bus_space_write_region_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bswrs4($t,($h),$o,$a,$c); }  &while (0));
	}' unless defined(&bus_space_write_region_stream_4);
    }
    if(0) {
	eval 'sub bus_space_write_region_8 () {!!!  &bus_space_write_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_region_8);
	eval 'sub bus_space_write_region_stream_8 () {!!!  &bus_space_write_region_stream_8  &unimplemented !!!;}' unless defined(&bus_space_write_region_stream_8);
    }
    if(defined(&DIAGNOSTIC)) {
	eval 'sub bus_space_set_multi_1 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_set_multi_1 called with zero count.\\"); ($h). &bssm1($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_multi_1);
	eval 'sub bus_space_set_multi_2 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_set_multi_2 called with zero count.\\"); ($h). &bssm2($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_multi_2);
	eval 'sub bus_space_set_multi_4 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_set_multi_4 called with zero count.\\"); ($h). &bssm4($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_multi_4);
    } else {
	eval 'sub bus_space_set_multi_1 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bssm1($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_multi_1);
	eval 'sub bus_space_set_multi_2 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bssm2($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_multi_2);
	eval 'sub bus_space_set_multi_4 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bssm4($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_multi_4);
    }
    if(0) {
	eval 'sub bus_space_set_multi_8 () {!!!  &bus_space_set_multi_8  &unimplemented !!!;}' unless defined(&bus_space_set_multi_8);
    }
    if(defined(&DIAGNOSTIC)) {
	eval 'sub bus_space_set_region_1 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_set_region_1 called with zero count.\\"); ($h). &bssr1($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_region_1);
	eval 'sub bus_space_set_region_2 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_set_region_2 called with zero count.\\"); ($h). &bssr2($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_region_2);
	eval 'sub bus_space_set_region_4 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if (($c) == 0)  &panic(\\"bus_space_set_region_4 called with zero count.\\"); ($h). &bssr4($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_region_4);
    } else {
	eval 'sub bus_space_set_region_1 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bssr1($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_region_1);
	eval 'sub bus_space_set_region_2 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bssr2($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_region_2);
	eval 'sub bus_space_set_region_4 {
	    my($t, $h, $o, $val, $c) = @_;
    	    eval q( &do {  &if ($c) ($h). &bssr4($t,($h),$o,$val,$c); }  &while (0));
	}' unless defined(&bus_space_set_region_4);
    }
    if(0) {
	eval 'sub bus_space_set_region_8 () {!!!  &bus_space_set_region_8  &unimplemented !!!;}' unless defined(&bus_space_set_region_8);
    }
    eval 'sub __MAC68K_copy_region_N {
        my($BYTES) = @_;
	    eval q( &static  &__inline  &void  &__CONCAT( &bus_space_copy_region_,$BYTES) ( &bus_space_tag_t,  &bus_space_handle_t,  &bus_size_t,  &bus_space_handle_t,  &bus_size_t,  &bus_size_t);  &static  &__inline  &void  &__CONCAT( &bus_space_copy_region_,$BYTES)(  &bus_space_tag_t  &t,  &bus_space_handle_t  &h1,  &bus_size_t  &o1,  &bus_space_handle_t  &h2,  &bus_size_t  &o2,  &bus_size_t  &c) {  &bus_size_t  &o;  &if (( ($h1->{base}) +  &o1) >= ( ($h2->{base}) +  &o2)) {  &for ( &o = 0;  &c != 0;  &c--,  &o += $BYTES)  &__CONCAT( &bus_space_write_,$BYTES)( &t,  &h2,  &o2 +  &o,  &__CONCAT( &bus_space_read_,$BYTES)( &t,  &h1,  &o1 +  &o)); }  &else {  &for ( &o = ( &c - 1) * $BYTES;  &c != 0;  &c--,  &o -= $BYTES)  &__CONCAT( &bus_space_write_,$BYTES)( &t,  &h2,  &o2 +  &o,  &__CONCAT( &bus_space_read_,$BYTES)( &t,  &h1,  &o1 +  &o)); } });
    }' unless defined(&__MAC68K_copy_region_N);
    if(0) {
	eval 'sub bus_space_copy_8 () {!!!  &bus_space_copy_8  &unimplemented !!!;}' unless defined(&bus_space_copy_8);
    }
    undef(&__MAC68K_copy_region_N) if defined(&__MAC68K_copy_region_N);
    eval 'sub bus_space_barrier {
        my($t, $h, $o, $l, $f) = @_;
	    eval q((( &void)(( &void)($t), ( &void)($h), ( &void)($o), ( &void)($l), ( &void)($f))));
    }' unless defined(&bus_space_barrier);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub bus_space_vaddr {
        my($t, $h) = @_;
	    eval q((( &void)($t), ( &void *)( ($h->{base}))));
    }' unless defined(&bus_space_vaddr);
    eval 'sub BUS_SPACE_ALIGNED_POINTER {
        my($p, $t) = @_;
	    eval q( &ALIGNED_POINTER($p, $t));
    }' unless defined(&BUS_SPACE_ALIGNED_POINTER);
    require 'm68k/bus_dma.ph';
}
1;
