/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="9V Battery Snap", category="Electromechanical", author="Branislav Stojkovic", description="", stretchable=false, zOrder=4.0, instanceNamePrefix="BTR", autoEdit=false)
public class BatterySnap9V
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    private static Color BODY_COLOR = Color.darkGray;
    private static Size WIDTH = new Size(Double.valueOf(0.5), SizeUnit.in);
    private static Size LENGTH = new Size(Double.valueOf(0.75), SizeUnit.in);
    private static Size TERMINAL_DIAMETER = new Size(Double.valueOf(0.3), SizeUnit.in);
    private static Size TERMINAL_SPACING = new Size(Double.valueOf(0.5), SizeUnit.in);
    private static Size TERMINAL_BORDER = new Size(Double.valueOf(0.7), SizeUnit.mm);
    private String value = "";
    private Point controlPoint = new Point(0, 0);
    transient Shape[] body;
    private Orientation orientation = Orientation.DEFAULT;
    private Color color = BODY_COLOR;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.color);
            g2d.fill(body[0]);
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : METAL_COLOR);
            g2d.fill(body[1]);
            g2d.fill(body[2]);
            g2d.setComposite(oldComposite);
        }
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color.brighter();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        g2d.setColor(METAL_COLOR.darker());
        g2d.draw(body[1]);
        g2d.setColor(METAL_COLOR.darker());
        g2d.draw(body[2]);
    }

    public Shape[] getBody() {
        if (this.body == null) {
            int i;
            this.body = new Shape[3];
            int x = this.controlPoint.x;
            int y = this.controlPoint.y;
            int width = (int)WIDTH.convertToPixels();
            int length = (int)LENGTH.convertToPixels();
            int totalLength = length + width / 2;
            int terminalDiameter = (int)TERMINAL_DIAMETER.convertToPixels();
            int terminalSpacing = (int)TERMINAL_SPACING.convertToPixels();
            int terminalBorder = (int)TERMINAL_BORDER.convertToPixels();
            Area mainArea = new Area(new Rectangle2D.Double(x, y - width / 2, length, width));
            mainArea.add(new Area(new Ellipse2D.Double(x + length - width / 2, y - width / 2, width, width)));
            this.body[0] = mainArea;
            Area terminalArea = new Area(new Ellipse2D.Double(x + (totalLength - terminalSpacing) / 2 - terminalDiameter / 2, y - terminalDiameter / 2, terminalDiameter, terminalDiameter));
            int centerX = x + (totalLength + terminalSpacing) / 2;
            int[] terminalX = new int[6];
            int[] terminalY = new int[6];
            for (i = 0; i < 6; ++i) {
                terminalX[i] = (int)((double)centerX + Math.cos(1.0471975511965976 * (double)i) * (double)terminalDiameter / 2.0);
                terminalY[i] = (int)((double)y + Math.sin(1.0471975511965976 * (double)i) * (double)terminalDiameter / 2.0);
            }
            terminalArea.add(new Area(new Polygon(terminalX, terminalY, 6)));
            this.body[1] = terminalArea;
            terminalArea = new Area(new Ellipse2D.Double(x + (totalLength - terminalSpacing) / 2 - terminalDiameter / 2 + terminalBorder, y - terminalDiameter / 2 + terminalBorder, terminalDiameter - 2 * terminalBorder, terminalDiameter - 2 * terminalBorder));
            for (i = 0; i < 6; ++i) {
                terminalX[i] = (int)((double)centerX + Math.cos(1.0471975511965976 * (double)i) * (double)(terminalDiameter / 2 + terminalBorder));
                terminalY[i] = (int)((double)y + Math.sin(1.0471975511965976 * (double)i) * (double)(terminalDiameter / 2 + terminalBorder));
            }
            terminalArea.add(new Area(new Polygon(terminalX, terminalY, 6)));
            this.body[2] = terminalArea;
            if (this.orientation != Orientation.DEFAULT) {
                double theta = 0.0;
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
                for (Shape shape : this.body) {
                    Area area = (Area)shape;
                    area.transform(rotation);
                }
            }
        }
        return this.body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(BODY_COLOR);
        g2d.fillOval(width / 4, width / 32, width / 2, width / 2);
        g2d.setColor(BODY_COLOR.darker());
        g2d.drawOval(width / 4, width / 32, width / 2, width / 2);
        g2d.setColor(BODY_COLOR);
        g2d.fillRect(width / 4, width / 32 + width / 4, width / 2, width * 3 / 4 - 2 * width / 32);
        g2d.setColor(BODY_COLOR.darker());
        g2d.drawRect(width / 4, width / 32 + width / 4, width / 2, width * 3 / 4 - 2 * width / 32);
        g2d.setColor(METAL_COLOR);
        g2d.fillOval(width / 4 + 3 * width / 32, width / 32 + 3 * width / 32, width / 2 - 6 * width / 32, width / 2 - 6 * width / 32);
        int centerX = width / 2;
        int centerY = height * 7 / 9;
        int terminalDiameter = width / 2 - 4 * width / 32;
        int[] terminalX = new int[6];
        int[] terminalY = new int[6];
        for (int i = 0; i < 6; ++i) {
            terminalX[i] = (int)((double)centerX + Math.cos(1.0471975511965976 * (double)i) * (double)terminalDiameter / 2.0);
            terminalY[i] = (int)((double)centerY + Math.sin(1.0471975511965976 * (double)i) * (double)terminalDiameter / 2.0);
        }
        g2d.fillPolygon(terminalX, terminalY, 6);
        g2d.setColor(METAL_COLOR.darker());
        g2d.drawOval(width / 4 + 3 * width / 32, width / 32 + 3 * width / 32, width / 2 - 6 * width / 32, width / 2 - 6 * width / 32);
        g2d.drawPolygon(terminalX, terminalY, 6);
    }

    public int getControlPointCount() {
        return 1;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public Point getControlPoint(int index) {
        return this.controlPoint;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoint.setLocation(point);
        this.body = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.body = null;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

