/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.LoadingStateChangeEvent;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasKeyProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class HasDataPresenter<T>
implements HasData<T>,
HasKeyProvider<T>,
HasKeyboardPagingPolicy {
    static final int PAGE_INCREMENT = 30;
    private static final int LOOP_MAXIMUM = 10;
    private static final int REDRAW_MINIMUM = 5;
    private static final double REDRAW_THRESHOLD = 0.3;
    private final HasData<T> display;
    private boolean isResolvingState;
    private HasKeyboardPagingPolicy.KeyboardPagingPolicy keyboardPagingPolicy = HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE;
    private HasKeyboardSelectionPolicy.KeyboardSelectionPolicy keyboardSelectionPolicy = HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED;
    private final ProvidesKey<T> keyProvider;
    private PendingState<T> pendingState;
    private Scheduler.ScheduledCommand pendingStateCommand;
    private int pendingStateLoop = 0;
    private HandlerRegistration selectionHandler;
    private SelectionModel<? super T> selectionModel;
    private State<T> state;
    private final View<T> view;

    private static native void sortJsArrayInteger(JsArrayInteger var0);

    public HasDataPresenter(HasData<T> display, View<T> view, int pageSize, ProvidesKey<T> keyProvider) {
        this.display = display;
        this.view = view;
        this.keyProvider = keyProvider;
        this.state = new DefaultState(pageSize);
    }

    @Override
    public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<T> handler) {
        return this.view.addHandler(handler, CellPreviewEvent.getType());
    }

    public HandlerRegistration addLoadingStateChangeHandler(LoadingStateChangeEvent.Handler handler) {
        return this.view.addHandler(handler, LoadingStateChangeEvent.TYPE);
    }

    @Override
    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.view.addHandler(handler, RangeChangeEvent.getType());
    }

    @Override
    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.view.addHandler(handler, RowCountChangeEvent.getType());
    }

    public void clearKeyboardSelectedRowValue() {
        if (this.getKeyboardSelectedRowValue() != null) {
            this.ensurePendingState().keyboardSelectedRowValue = null;
        }
    }

    public void clearSelectionModel() {
        if (this.selectionHandler != null) {
            this.selectionHandler.removeHandler();
            this.selectionHandler = null;
        }
        this.selectionModel = null;
    }

    @Override
    public void fireEvent(GwtEvent<?> event) {
        throw new UnsupportedOperationException();
    }

    public void flush() {
        this.resolvePendingState(null);
    }

    public int getCurrentPageSize() {
        return Math.min(this.getPageSize(), this.getRowCount() - this.getPageStart());
    }

    @Override
    public HasKeyboardPagingPolicy.KeyboardPagingPolicy getKeyboardPagingPolicy() {
        return this.keyboardPagingPolicy;
    }

    public int getKeyboardSelectedRow() {
        return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy ? -1 : this.getCurrentState().getKeyboardSelectedRow();
    }

    public int getKeyboardSelectedRowInView() {
        return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy ? -1 : this.state.getKeyboardSelectedRow();
    }

    public T getKeyboardSelectedRowValue() {
        return HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy ? null : (T)this.getCurrentState().getKeyboardSelectedRowValue();
    }

    @Override
    public HasKeyboardSelectionPolicy.KeyboardSelectionPolicy getKeyboardSelectionPolicy() {
        return this.keyboardSelectionPolicy;
    }

    @Override
    public ProvidesKey<T> getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    public int getRowCount() {
        return this.getCurrentState().getRowCount();
    }

    @Override
    public SelectionModel<? super T> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public T getVisibleItem(int indexOnPage) {
        return this.getCurrentState().getRowDataValue(indexOnPage);
    }

    @Override
    public int getVisibleItemCount() {
        return this.getCurrentState().getRowDataSize();
    }

    @Override
    public List<T> getVisibleItems() {
        return this.getCurrentState().getRowDataValues();
    }

    @Override
    public Range getVisibleRange() {
        return new Range(this.getPageStart(), this.getPageSize());
    }

    public boolean hasPendingState() {
        return this.pendingState != null;
    }

    public boolean isEmpty() {
        return this.isRowCountExact() && this.getRowCount() == 0;
    }

    @Override
    public boolean isRowCountExact() {
        return this.getCurrentState().isRowCountExact();
    }

    public void redraw() {
        ((PendingState)this.ensurePendingState()).redrawRequired = true;
    }

    @Override
    public void setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("KeyboardPagingPolicy cannot be null");
        }
        this.keyboardPagingPolicy = policy;
    }

    public void setKeyboardSelectedRow(int index, boolean stealFocus, boolean forceUpdate) {
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy) {
            return;
        }
        if (this.keyboardPagingPolicy.isLimitedToRange()) {
            index = Math.max(0, Math.min(index, this.getVisibleItemCount() - 1));
        }
        this.ensurePendingState().viewTouched = true;
        if (!forceUpdate && this.getKeyboardSelectedRow() == index && this.getKeyboardSelectedRowValue() != null) {
            return;
        }
        int pageStart = this.getPageStart();
        int pageSize = this.getPageSize();
        int absIndex = pageStart + index;
        int rowCount = this.getRowCount();
        if (absIndex >= rowCount && this.isRowCountExact()) {
            absIndex = rowCount - 1;
        }
        index = Math.max(0, absIndex) - pageStart;
        if (this.keyboardPagingPolicy.isLimitedToRange()) {
            index = Math.max(0, Math.min(index, pageSize - 1));
        }
        int newPageStart = pageStart;
        int newPageSize = pageSize;
        PendingState<T> pending = this.ensurePendingState();
        pending.keyboardSelectedRow = 0;
        pending.keyboardSelectedRowValue = null;
        ((PendingState)pending).keyboardSelectedRowChanged = true;
        if (index >= 0 && index < pageSize) {
            pending.keyboardSelectedRow = index;
            pending.keyboardSelectedRowValue = index < pending.getRowDataSize() ? this.ensurePendingState().getRowDataValue(index) : null;
            ((PendingState)pending).keyboardStealFocus = stealFocus;
            return;
        }
        if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE == this.keyboardPagingPolicy) {
            while (index < 0) {
                int shift = Math.min(pageSize, newPageStart);
                newPageStart -= shift;
                index += shift;
            }
            while (index >= pageSize) {
                newPageStart += pageSize;
                index -= pageSize;
            }
        } else if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE == this.keyboardPagingPolicy) {
            while (index < 0) {
                int shift = Math.min(30, newPageStart);
                newPageSize += shift;
                newPageStart -= shift;
                index += shift;
            }
            while (index >= newPageSize) {
                newPageSize += 30;
            }
            if (this.isRowCountExact()) {
                newPageSize = Math.min(newPageSize, rowCount - newPageStart);
                if (index >= rowCount) {
                    index = rowCount - 1;
                }
            }
        }
        if (newPageStart != pageStart || newPageSize != pageSize) {
            pending.keyboardSelectedRow = index;
            this.setVisibleRange(new Range(newPageStart, newPageSize), false, false);
        }
    }

    @Override
    public void setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy policy) {
        if (policy == null) {
            throw new NullPointerException("KeyboardSelectionPolicy cannot be null");
        }
        this.keyboardSelectionPolicy = policy;
    }

    @Override
    public final void setRowCount(int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowCount(int count, boolean isExact) {
        if (count == this.getRowCount() && isExact == this.isRowCountExact()) {
            return;
        }
        this.ensurePendingState().rowCount = count;
        this.ensurePendingState().rowCountIsExact = isExact;
        this.updateCachedData();
        RowCountChangeEvent.fire(this.display, count, isExact);
    }

    @Override
    public void setRowData(int start, List<? extends T> values) {
        int i;
        int valuesLength = values.size();
        int valuesEnd = start + valuesLength;
        int pageStart = this.getPageStart();
        int pageEnd = this.getPageStart() + this.getPageSize();
        int boundedStart = Math.max(start, pageStart);
        int boundedEnd = Math.min(valuesEnd, pageEnd);
        if (start != pageStart && boundedStart >= boundedEnd) {
            return;
        }
        PendingState<T> pending = this.ensurePendingState();
        int cacheOffset = Math.max(0, boundedStart - pageStart - this.getVisibleItemCount());
        for (i = 0; i < cacheOffset; ++i) {
            pending.rowData.add(null);
        }
        for (i = boundedStart; i < boundedEnd; ++i) {
            T value = values.get(i - start);
            int dataIndex = i - pageStart;
            if (dataIndex < this.getVisibleItemCount()) {
                pending.rowData.set(dataIndex, value);
                continue;
            }
            pending.rowData.add(value);
        }
        pending.replaceRange(boundedStart - cacheOffset, boundedEnd);
        if (valuesEnd > this.getRowCount()) {
            this.setRowCount(valuesEnd, this.isRowCountExact());
        }
    }

    @Override
    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.clearSelectionModel();
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            this.selectionHandler = selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

                @Override
                public void onSelectionChange(SelectionChangeEvent event) {
                    HasDataPresenter.this.ensurePendingState();
                }
            });
        }
        this.ensurePendingState();
    }

    @Override
    public final void setVisibleRange(int start, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVisibleRange(Range range) {
        this.setVisibleRange(range, false, false);
    }

    @Override
    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.setVisibleRange(range, true, forceRangeChangeEvent);
    }

    protected void scheduleFinally(Scheduler.ScheduledCommand command) {
        Scheduler.get().scheduleFinally(command);
    }

    List<Range> calculateModifiedRanges(JsArrayInteger modifiedRows, int pageStart, int pageEnd) {
        HasDataPresenter.sortJsArrayInteger(modifiedRows);
        int rangeStart0 = -1;
        int rangeEnd0 = -1;
        int rangeStart1 = -1;
        int rangeEnd1 = -1;
        int maxDiff = 0;
        for (int i = 0; i < modifiedRows.length(); ++i) {
            int index = modifiedRows.get(i);
            if (index < pageStart || index >= pageEnd) continue;
            if (rangeStart0 == -1) {
                rangeStart0 = index;
                rangeEnd0 = index;
                continue;
            }
            if (rangeStart1 == -1) {
                maxDiff = index - rangeEnd0;
                rangeStart1 = index;
                rangeEnd1 = index;
                continue;
            }
            int diff = index - rangeEnd1;
            if (diff > maxDiff) {
                rangeEnd0 = rangeEnd1;
                rangeStart1 = index;
                rangeEnd1 = index;
                maxDiff = diff;
                continue;
            }
            rangeEnd1 = index;
        }
        ++rangeEnd1;
        if (rangeStart1 == ++rangeEnd0) {
            rangeEnd0 = rangeEnd1;
            rangeStart1 = -1;
            rangeEnd1 = -1;
        }
        ArrayList<Range> toRet = new ArrayList<Range>();
        if (rangeStart0 != -1) {
            int rangeLength0 = rangeEnd0 - rangeStart0;
            toRet.add(new Range(rangeStart0, rangeLength0));
        }
        if (rangeStart1 != -1) {
            int rangeLength1 = rangeEnd1 - rangeStart1;
            toRet.add(new Range(rangeStart1, rangeLength1));
        }
        return toRet;
    }

    private PendingState<T> ensurePendingState() {
        if (this.pendingState == null) {
            this.pendingState = new PendingState<T>(this.state);
        }
        this.pendingStateCommand = new Scheduler.ScheduledCommand(){

            @Override
            public void execute() {
                if (HasDataPresenter.this.pendingStateCommand == this) {
                    HasDataPresenter.this.resolvePendingState(null);
                }
            }
        };
        this.scheduleFinally(this.pendingStateCommand);
        return this.pendingState;
    }

    private int findIndexOfBestMatch(State<T> state, T value, int initialIndex) {
        Object key = this.getRowValueKey(value);
        if (key == null) {
            return -1;
        }
        int bestMatchIndex = -1;
        int bestMatchDiff = Integer.MAX_VALUE;
        int rowDataCount = state.getRowDataSize();
        for (int i = 0; i < rowDataCount; ++i) {
            int diff;
            T curValue = state.getRowDataValue(i);
            Object curKey = this.getRowValueKey(curValue);
            if (!key.equals(curKey) || (diff = Math.abs(initialIndex - i)) >= bestMatchDiff) continue;
            bestMatchIndex = i;
            bestMatchDiff = diff;
        }
        return bestMatchIndex;
    }

    private State<T> getCurrentState() {
        return this.pendingState == null ? this.state : this.pendingState;
    }

    private int getPageSize() {
        return this.getCurrentState().getPageSize();
    }

    private int getPageStart() {
        return this.getCurrentState().getPageStart();
    }

    private Object getRowValueKey(T rowValue) {
        return this.keyProvider == null || rowValue == null ? rowValue : this.keyProvider.getKey(rowValue);
    }

    private boolean resolvePendingState(JsArrayInteger modifiedRows) {
        List<Range> modifiedRanges;
        this.pendingStateCommand = null;
        if (this.isResolvingState) {
            return false;
        }
        this.isResolvingState = true;
        if (this.pendingState == null) {
            this.isResolvingState = false;
            this.pendingStateLoop = 0;
            return false;
        }
        ++this.pendingStateLoop;
        if (this.pendingStateLoop > 10) {
            this.isResolvingState = false;
            this.pendingStateLoop = 0;
            throw new IllegalStateException("A possible infinite loop has been detected in a Cell Widget. This usually happens when your SelectionModel triggers a SelectionChangeEvent when SelectionModel.isSelection() is called, which causes the table to redraw continuously.");
        }
        State<T> oldState = this.state;
        PendingState<T> newState = this.pendingState;
        this.state = this.pendingState;
        this.pendingState = null;
        if (modifiedRows == null) {
            modifiedRows = (JsArrayInteger)JavaScriptObject.createArray().cast();
        }
        int pageStart = newState.getPageStart();
        int pageSize = newState.getPageSize();
        int pageEnd = pageStart + pageSize;
        int rowDataCount = newState.getRowDataSize();
        newState.keyboardSelectedRow = Math.max(0, Math.min(newState.keyboardSelectedRow, rowDataCount - 1));
        if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED == this.keyboardSelectionPolicy) {
            newState.keyboardSelectedRow = 0;
            newState.keyboardSelectedRowValue = null;
        } else if (((PendingState)newState).keyboardSelectedRowChanged) {
            newState.keyboardSelectedRowValue = rowDataCount > 0 ? newState.getRowDataValue(newState.keyboardSelectedRow) : null;
        } else if (newState.keyboardSelectedRowValue != null) {
            int bestMatchIndex = this.findIndexOfBestMatch(newState, newState.keyboardSelectedRowValue, newState.keyboardSelectedRow);
            if (bestMatchIndex >= 0) {
                newState.keyboardSelectedRow = bestMatchIndex;
                newState.keyboardSelectedRowValue = rowDataCount > 0 ? newState.getRowDataValue(newState.keyboardSelectedRow) : null;
            } else {
                newState.keyboardSelectedRow = 0;
                newState.keyboardSelectedRowValue = null;
            }
        }
        try {
            if (HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION == this.keyboardSelectionPolicy && this.selectionModel != null && newState.viewTouched) {
                T oldValue = oldState.getSelectedValue();
                Object oldKey = this.getRowValueKey(oldValue);
                Object newValue = rowDataCount > 0 ? (Object)newState.getRowDataValue(newState.getKeyboardSelectedRow()) : null;
                Object newKey = this.getRowValueKey(newValue);
                if (newKey != null) {
                    boolean newValueWasSelected;
                    boolean oldValueWasSelected = oldValue == null ? false : this.selectionModel.isSelected(oldValue);
                    boolean bl = newValueWasSelected = newValue == null ? false : this.selectionModel.isSelected(newValue);
                    if (!newKey.equals(oldKey)) {
                        if (oldValueWasSelected) {
                            this.selectionModel.setSelected(oldValue, false);
                        }
                        newState.selectedValue = newValue;
                        if (newValue != null && !newValueWasSelected) {
                            this.selectionModel.setSelected(newValue, true);
                        }
                    } else if (!newValueWasSelected) {
                        newState.selectedValue = null;
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.isResolvingState = false;
            this.pendingStateLoop = 0;
            throw e;
        }
        boolean keyboardRowChanged = ((PendingState)newState).keyboardSelectedRowChanged || oldState.getKeyboardSelectedRow() != newState.keyboardSelectedRow || oldState.getKeyboardSelectedRowValue() == null && newState.keyboardSelectedRowValue != null;
        HashSet<Integer> newlySelectedRows = new HashSet<Integer>();
        try {
            for (int i = pageStart; i < pageStart + rowDataCount; ++i) {
                Object rowValue = newState.getRowDataValue(i - pageStart);
                boolean isSelected = rowValue != null && this.selectionModel != null && this.selectionModel.isSelected(rowValue);
                boolean wasSelected = oldState.isRowSelected(i);
                if (isSelected) {
                    newState.selectedRows.add(i);
                    newlySelectedRows.add(i);
                    if (wasSelected) continue;
                    modifiedRows.push(i);
                    continue;
                }
                if (!wasSelected) continue;
                modifiedRows.push(i);
            }
        }
        catch (RuntimeException e) {
            this.isResolvingState = false;
            this.pendingStateLoop = 0;
            throw e;
        }
        boolean replacedEmptyRange = false;
        for (Range replacedRange : ((PendingState)newState).replacedRanges) {
            int start = replacedRange.getStart();
            int length = replacedRange.getLength();
            if (length == 0) {
                replacedEmptyRange = true;
            }
            for (int i = start; i < start + length; ++i) {
                modifiedRows.push(i);
            }
        }
        if (modifiedRows.length() > 0 && keyboardRowChanged) {
            modifiedRows.push(oldState.getKeyboardSelectedRow());
            modifiedRows.push(newState.keyboardSelectedRow);
        }
        if (this.pendingState != null) {
            this.isResolvingState = false;
            this.pendingState.selectedValue = newState.selectedValue;
            this.pendingState.selectedRows.addAll(newlySelectedRows);
            if (keyboardRowChanged) {
                ((PendingState)this.pendingState).keyboardSelectedRowChanged = true;
            }
            if (((PendingState)newState).keyboardStealFocus) {
                ((PendingState)this.pendingState).keyboardStealFocus = true;
            }
            modifiedRows.push(oldState.getKeyboardSelectedRow());
            modifiedRows.push(newState.keyboardSelectedRow);
            if (this.resolvePendingState(modifiedRows)) {
                return true;
            }
        }
        Range range0 = (modifiedRanges = this.calculateModifiedRanges(modifiedRows, pageStart, pageEnd)).size() > 0 ? modifiedRanges.get(0) : null;
        Range range1 = modifiedRanges.size() > 1 ? modifiedRanges.get(1) : null;
        int replaceDiff = 0;
        for (Range range : modifiedRanges) {
            replaceDiff += range.getLength();
        }
        int oldPageStart = oldState.getPageStart();
        int oldPageSize = oldState.getPageSize();
        int oldRowDataCount = oldState.getRowDataSize();
        boolean redrawRequired = ((PendingState)newState).redrawRequired;
        if (pageStart != oldPageStart) {
            redrawRequired = true;
        } else if (rowDataCount < oldRowDataCount) {
            redrawRequired = true;
        } else if (range1 == null && range0 != null && range0.getStart() == pageStart && (replaceDiff >= oldRowDataCount || replaceDiff > oldPageSize)) {
            redrawRequired = true;
        } else if (replaceDiff >= 5 && (double)replaceDiff > 0.3 * (double)oldRowDataCount) {
            redrawRequired = true;
        } else if (replacedEmptyRange && oldRowDataCount == 0) {
            redrawRequired = true;
        }
        this.updateLoadingState();
        try {
            if (redrawRequired) {
                SafeHtmlBuilder sb = new SafeHtmlBuilder();
                this.view.replaceAllChildren(newState.rowData, this.selectionModel, ((PendingState)newState).keyboardStealFocus);
                this.view.resetFocus();
            } else if (range0 != null) {
                int absStart = range0.getStart();
                int relStart = absStart - pageStart;
                SafeHtmlBuilder sb = new SafeHtmlBuilder();
                List replaceValues = newState.rowData.subList(relStart, relStart + range0.getLength());
                this.view.replaceChildren(replaceValues, relStart, this.selectionModel, ((PendingState)newState).keyboardStealFocus);
                if (range1 != null) {
                    absStart = range1.getStart();
                    relStart = absStart - pageStart;
                    sb = new SafeHtmlBuilder();
                    replaceValues = newState.rowData.subList(relStart, relStart + range1.getLength());
                    this.view.replaceChildren(replaceValues, relStart, this.selectionModel, ((PendingState)newState).keyboardStealFocus);
                }
                this.view.resetFocus();
            } else if (keyboardRowChanged) {
                int newSelectedRow;
                int oldSelectedRow = oldState.getKeyboardSelectedRow();
                if (oldSelectedRow >= 0 && oldSelectedRow < rowDataCount) {
                    this.view.setKeyboardSelected(oldSelectedRow, false, false);
                }
                if ((newSelectedRow = newState.getKeyboardSelectedRow()) >= 0 && newSelectedRow < rowDataCount) {
                    this.view.setKeyboardSelected(newSelectedRow, true, ((PendingState)newState).keyboardStealFocus);
                }
            }
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
        finally {
            this.isResolvingState = false;
        }
        this.resolvePendingState(null);
        return true;
    }

    private void setVisibleRange(Range range, boolean clearData, boolean forceRangeChangeEvent) {
        boolean pageSizeChanged;
        boolean pageStartChanged;
        int start = range.getStart();
        int length = range.getLength();
        if (start < 0) {
            throw new IllegalArgumentException("Range start cannot be less than 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Range length cannot be less than 0");
        }
        int pageStart = this.getPageStart();
        int pageSize = this.getPageSize();
        boolean bl = pageStartChanged = pageStart != start;
        if (pageStartChanged) {
            PendingState<T> pending = this.ensurePendingState();
            if (!clearData) {
                if (start > pageStart) {
                    int increase = start - pageStart;
                    if (this.getVisibleItemCount() > increase) {
                        for (int i = 0; i < increase; ++i) {
                            pending.rowData.remove(0);
                        }
                    } else {
                        pending.rowData.clear();
                    }
                } else {
                    int decrease = pageStart - start;
                    if (this.getVisibleItemCount() > 0 && decrease < pageSize) {
                        for (int i = 0; i < decrease; ++i) {
                            pending.rowData.add(0, null);
                        }
                        pending.replaceRange(start, start + decrease);
                    } else {
                        pending.rowData.clear();
                    }
                }
            }
            pending.pageStart = start;
        }
        boolean bl2 = pageSizeChanged = pageSize != length;
        if (pageSizeChanged) {
            this.ensurePendingState().pageSize = length;
        }
        if (clearData) {
            this.ensurePendingState().rowData.clear();
        }
        this.updateCachedData();
        if (pageStartChanged || pageSizeChanged || forceRangeChangeEvent) {
            RangeChangeEvent.fire(this.display, this.getVisibleRange());
        }
    }

    private void updateCachedData() {
        int pageStart = this.getPageStart();
        int expectedLastIndex = Math.max(0, Math.min(this.getPageSize(), this.getRowCount() - pageStart));
        for (int lastIndex = this.getVisibleItemCount() - 1; lastIndex >= expectedLastIndex; --lastIndex) {
            this.ensurePendingState().rowData.remove(lastIndex);
        }
    }

    private void updateLoadingState() {
        int curPageSize;
        int cacheSize = this.getVisibleItemCount();
        int n = curPageSize = this.isRowCountExact() ? this.getCurrentPageSize() : this.getPageSize();
        if (cacheSize >= curPageSize) {
            this.view.setLoadingState(LoadingStateChangeEvent.LoadingState.LOADED);
        } else if (cacheSize == 0) {
            this.view.setLoadingState(LoadingStateChangeEvent.LoadingState.LOADING);
        } else {
            this.view.setLoadingState(LoadingStateChangeEvent.LoadingState.PARTIALLY_LOADED);
        }
    }

    private static interface State<T> {
        public int getKeyboardSelectedRow();

        public T getKeyboardSelectedRowValue();

        public int getPageSize();

        public int getPageStart();

        public int getRowCount();

        public int getRowDataSize();

        public T getRowDataValue(int var1);

        public List<T> getRowDataValues();

        public T getSelectedValue();

        public boolean isRowCountExact();

        public boolean isRowSelected(int var1);

        public boolean isViewTouched();
    }

    private static class PendingState<T>
    extends DefaultState<T> {
        private boolean keyboardSelectedRowChanged;
        private boolean keyboardStealFocus = false;
        private boolean redrawRequired = false;
        private final List<Range> replacedRanges = new ArrayList<Range>();

        public PendingState(State<T> state) {
            super(state.getPageSize());
            this.keyboardSelectedRow = state.getKeyboardSelectedRow();
            this.keyboardSelectedRowValue = state.getKeyboardSelectedRowValue();
            this.pageSize = state.getPageSize();
            this.pageStart = state.getPageStart();
            this.rowCount = state.getRowCount();
            this.rowCountIsExact = state.isRowCountExact();
            this.selectedValue = state.getSelectedValue();
            this.viewTouched = state.isViewTouched();
            int rowDataSize = state.getRowDataSize();
            for (int i = 0; i < rowDataSize; ++i) {
                this.rowData.add(state.getRowDataValue(i));
            }
        }

        public void replaceRange(int start, int end) {
            this.replacedRanges.add(new Range(start, end - start));
        }
    }

    private static class DefaultState<T>
    implements State<T> {
        int keyboardSelectedRow = 0;
        T keyboardSelectedRowValue = null;
        int pageSize;
        int pageStart = 0;
        int rowCount = 0;
        boolean rowCountIsExact = false;
        final List<T> rowData = new ArrayList<T>();
        final Set<Integer> selectedRows = new HashSet<Integer>();
        T selectedValue = null;
        boolean viewTouched;

        public DefaultState(int pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public int getKeyboardSelectedRow() {
            return this.keyboardSelectedRow;
        }

        @Override
        public T getKeyboardSelectedRowValue() {
            return this.keyboardSelectedRowValue;
        }

        @Override
        public int getPageSize() {
            return this.pageSize;
        }

        @Override
        public int getPageStart() {
            return this.pageStart;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public int getRowDataSize() {
            return this.rowData.size();
        }

        @Override
        public T getRowDataValue(int index) {
            return this.rowData.get(index);
        }

        @Override
        public List<T> getRowDataValues() {
            return Collections.unmodifiableList(this.rowData);
        }

        @Override
        public T getSelectedValue() {
            return this.selectedValue;
        }

        @Override
        public boolean isRowCountExact() {
            return this.rowCountIsExact;
        }

        @Override
        public boolean isRowSelected(int index) {
            return this.selectedRows.contains(index);
        }

        @Override
        public boolean isViewTouched() {
            return this.viewTouched;
        }
    }

    static interface View<T> {
        public <H extends EventHandler> HandlerRegistration addHandler(H var1, GwtEvent.Type<H> var2);

        public void replaceAllChildren(List<T> var1, SelectionModel<? super T> var2, boolean var3);

        public void replaceChildren(List<T> var1, int var2, SelectionModel<? super T> var3, boolean var4);

        public void resetFocus();

        public void setKeyboardSelected(int var1, boolean var2, boolean var3);

        public void setLoadingState(LoadingStateChangeEvent.LoadingState var1);
    }

    static interface ElementIterator
    extends Iterator<Element> {
        public void setSelected(boolean var1) throws IllegalStateException;
    }
}

