/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.stat;

import edu.cornell.med.icb.stat.PredictionStatisticCalculator;
import edu.cornell.med.icb.stat.ZScoreCalculator;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AreaUnderTheRocCurveCalculator
extends PredictionStatisticCalculator {
    private static final Log LOG = LogFactory.getLog(AreaUnderTheRocCurveCalculator.class);

    @Override
    public String getMeasureName() {
        return "AUC";
    }

    public AreaUnderTheRocCurveCalculator() {
        this.highestStatisticIsBest = true;
        this.zero = 0.5;
    }

    @Override
    public double evaluateStatisticAtThreshold(double threshold, double[] decisionValues, double[] labels) {
        return this.statistic;
    }

    @Override
    public double thresholdIndependentStatistic(double[] decisionValues, double[] labels) {
        return this.evaluateStatistic(decisionValues, labels);
    }

    public double evaluateStatistic(double[] decisionValues, double[] labels) {
        double auc;
        double sum = 0.0;
        double numPositive = 0.0;
        double numNegative = 0.0;
        DoubleArrayList truePositiveDecisions = new DoubleArrayList();
        DoubleArrayList trueNegativeDecisions = new DoubleArrayList();
        for (int i = 0; i < decisionValues.length; ++i) {
            if (decisionValues[i] != decisionValues[i]) {
                LOG.warn((Object)"NaN found instead of a decision value. NaN are always interpreted as wrong predictions. ");
            }
            if (labels[i] >= 0.0) {
                truePositiveDecisions.add(decisionValues[i]);
                continue;
            }
            trueNegativeDecisions.add(decisionValues[i]);
        }
        DoubleListIterator i = truePositiveDecisions.iterator();
        while (i.hasNext()) {
            double decisionPositive = (Double)i.next();
            DoubleListIterator doubleListIterator = trueNegativeDecisions.iterator();
            while (doubleListIterator.hasNext()) {
                double decisionNegative = (Double)doubleListIterator.next();
                sum += decisionPositive > decisionNegative ? 1.0 : 0.0;
                sum += decisionPositive == decisionNegative ? 0.5 : 0.0;
            }
        }
        numPositive = truePositiveDecisions.size();
        numNegative = trueNegativeDecisions.size();
        this.statistic = auc = sum / numPositive / numNegative;
        return auc;
    }

    @Override
    public double thresholdIndependentStatistic(ObjectList<double[]> decisionValueList, ObjectList<double[]> labelList) {
        double averageStatistic = 0.0;
        double count = 0.0;
        for (int i = 0; i < decisionValueList.size(); ++i) {
            double statisticSingleSplit = this.thresholdIndependentStatistic((double[])decisionValueList.get(i), (double[])labelList.get(i));
            averageStatistic += statisticSingleSplit;
            count += 1.0;
        }
        return averageStatistic / count;
    }

    @Override
    public double thresholdIndependentStatisticStd(ObjectList<double[]> decisionValueList, ObjectList<double[]> trueLabelList) {
        ZScoreCalculator calc = new ZScoreCalculator();
        for (int i = 0; i < decisionValueList.size(); ++i) {
            double aucSingleSplit = this.evaluateStatistic((double[])decisionValueList.get(i), (double[])trueLabelList.get(i));
            calc.observe(aucSingleSplit);
        }
        calc.calculateStats();
        return calc.stdDev();
    }
}

