/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.fonts.cmaps;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.fonts.cmaps.CodespaceRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMap {
    private List<CodespaceRange> codeSpaceRanges = new ArrayList<CodespaceRange>();
    private Map<Integer, String> singleByteMappings = new HashMap<Integer, String>();
    private Map<Integer, String> doubleByteMappings = new HashMap<Integer, String>();

    public boolean hasOneByteMappings() {
        return !this.singleByteMappings.isEmpty();
    }

    public boolean hasTwoByteMappings() {
        return !this.doubleByteMappings.isEmpty();
    }

    public String lookup(byte[] code, int offset, int length) {
        String result = null;
        Integer key = null;
        if (length == 1) {
            key = code[offset] & 0xFF;
            result = this.singleByteMappings.get(key);
        } else if (length == 2) {
            int intKey = code[offset] & 0xFF;
            intKey <<= 8;
            key = intKey += code[offset + 1] & 0xFF;
            result = this.doubleByteMappings.get(key);
        }
        return result;
    }

    public void addMapping(byte[] src, String dest) throws IOException {
        if (src.length == 1) {
            this.singleByteMappings.put(src[0] & 0xFF, dest);
        } else if (src.length == 2) {
            int intSrc = src[0] & 0xFF;
            intSrc <<= 8;
            this.doubleByteMappings.put(intSrc |= src[1] & 0xFF, dest);
        } else {
            throw new IOException(MessageLocalization.getComposedMessage("mapping.code.should.be.1.or.two.bytes.and.not.1", src.length));
        }
    }

    public void addCodespaceRange(CodespaceRange range) {
        this.codeSpaceRanges.add(range);
    }

    public List<CodespaceRange> getCodeSpaceRanges() {
        return this.codeSpaceRanges;
    }

    public Map<Integer, Integer> createReverseMapping() throws IOException {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, String> entry : this.singleByteMappings.entrySet()) {
            result.put(this.convertToInt(entry.getValue()), entry.getKey());
        }
        for (Map.Entry<Integer, String> entry : this.doubleByteMappings.entrySet()) {
            result.put(this.convertToInt(entry.getValue()), entry.getKey());
        }
        return result;
    }

    private int convertToInt(String s) throws IOException {
        byte[] b = s.getBytes("UTF-16BE");
        int value = 0;
        for (int i = 0; i < b.length - 1; ++i) {
            value += b[i] & 0xFF;
            value <<= 8;
        }
        return value += b[b.length - 1] & 0xFF;
    }
}

