/*
 * Decompiled with CFR 0.152.
 */
package imp;

import blbutil.Utilities;
import imp.CodedSteps;
import imp.ImpData;
import ints.IndexArray;
import ints.IntArray;
import ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import main.Par;

public final class ImpIbs {
    private final ImpData impData;
    private final int nRefHaps;
    private final long seed;
    private final int nSteps;
    private final int nHapsPerStep;
    private final CodedSteps codedSteps;
    private final int[][][] ibsHaps;

    public ImpIbs(ImpData impData) {
        Par par = impData.par();
        this.impData = impData;
        this.seed = par.seed();
        this.nRefHaps = impData.nRefHaps();
        this.nSteps = par.imp_nsteps();
        int n2 = Math.round(par.imp_segment() / par.imp_step());
        this.nHapsPerStep = par.imp_states() / n2;
        this.codedSteps = new CodedSteps(impData);
        this.ibsHaps = (int[][][])IntStream.range(0, this.codedSteps.nSteps()).parallel().mapToObj(n -> this.getIbsHaps(this.codedSteps, n)).toArray(n -> new int[n][][]);
    }

    private int[][] getIbsHaps(CodedSteps codedSteps, int n) {
        int n2 = this.impData.nTargHaps();
        int[][] nArrayArray = new int[n2][];
        int n3 = Math.min(this.nSteps, codedSteps.nSteps() - n);
        List<IntList> list = this.initPartition(codedSteps.get(n));
        ArrayList<IntList> arrayList = new ArrayList<IntList>(list.size());
        this.initUpdateResults(list, arrayList, nArrayArray);
        for (int i = 1; i < n3; ++i) {
            int n4 = Math.min(n2, 2 * arrayList.size());
            ArrayList<IntList> arrayList2 = arrayList;
            arrayList = new ArrayList(n4);
            IndexArray indexArray = codedSteps.get(n + i);
            int n5 = arrayList2.size();
            for (int j = 0; j < n5; ++j) {
                IntList intList = (IntList)arrayList2.get(j);
                list = this.partition(intList, indexArray);
                this.updateResults(intList, list, arrayList, nArrayArray);
            }
        }
        this.finalUpdateResults(arrayList, nArrayArray);
        return nArrayArray;
    }

    private List<IntList> initPartition(IndexArray indexArray) {
        int n;
        int n2;
        IntList[] intListArray = new IntList[indexArray.valueSize()];
        IntArray intArray = indexArray.intArray();
        int n3 = intArray.size();
        ArrayList<IntList> arrayList = new ArrayList<IntList>();
        for (n2 = this.nRefHaps; n2 < n3; ++n2) {
            n = intArray.get(n2);
            if (intListArray[n] != null) continue;
            intListArray[n] = new IntList();
            arrayList.add(intListArray[n]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = intArray.get(n2);
            if (intListArray[n] == null) continue;
            intListArray[n].add(n2);
        }
        return arrayList;
    }

    private List<IntList> partition(IntList intList, IndexArray indexArray) {
        int n;
        int n2;
        int n3;
        int n4;
        IntList[] intListArray = new IntList[indexArray.valueSize()];
        IntArray intArray = indexArray.intArray();
        int n5 = intList.size();
        ArrayList<IntList> arrayList = new ArrayList<IntList>();
        for (n4 = n3 = ImpIbs.insPt(intList, this.nRefHaps); n4 < n5; ++n4) {
            n2 = intList.get(n4);
            n = intArray.get(n2);
            if (intListArray[n] != null) continue;
            intListArray[n] = new IntList();
            arrayList.add(intListArray[n]);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n2 = intList.get(n4);
            n = intArray.get(n2);
            if (intListArray[n] == null) continue;
            intListArray[n].add(n2);
        }
        return arrayList;
    }

    private void initUpdateResults(List<IntList> list, List<IntList> list2, int[][] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IntList intList = list.get(i);
            int n2 = ImpIbs.insPt(intList, this.nRefHaps);
            if (n2 <= this.nHapsPerStep) {
                this.setResult(intList, n2, intList.copyOf(n2), nArray);
                continue;
            }
            list2.add(intList);
        }
    }

    private void updateResults(IntList intList, List<IntList> list, List<IntList> list2, int[][] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IntList intList2 = list.get(i);
            int n2 = ImpIbs.insPt(intList2, this.nRefHaps);
            if (n2 <= this.nHapsPerStep) {
                int[] nArray2 = this.ibsHaps(intList, intList2, n2);
                this.setResult(intList2, n2, nArray2, nArray);
                intList2.clear();
                continue;
            }
            list2.add(intList2);
        }
    }

    private int[] ibsHaps(IntList intList, IntList intList2, int n) {
        int[] nArray;
        int n2;
        IntList intList3 = new IntList(this.nHapsPerStep);
        for (n2 = 0; n2 < n; ++n2) {
            intList3.add(intList2.get(n2));
        }
        n2 = this.nHapsPerStep - n;
        Random random = new Random(this.seed + (long)intList.get(0));
        IntList intList4 = this.uniqToParent(intList, intList2, n);
        for (int n3 : nArray = ImpIbs.randomSubset(intList4, n2, random)) {
            intList3.add(n3);
        }
        int[] nArray2 = intList3.toArray();
        Arrays.sort(nArray2);
        return nArray2;
    }

    private IntList uniqToParent(IntList intList, IntList intList2, int n) {
        int n2 = n - 1;
        int n3 = ImpIbs.insPt(intList, this.nRefHaps);
        IntList intList3 = new IntList(intList.size());
        int n4 = 0;
        int n5 = intList2.get(n4);
        for (int i = 0; i < n3; ++i) {
            int n6 = intList.get(i);
            while (n5 < n6 && n4 < n2) {
                n5 = intList2.get(++n4);
            }
            if (n6 == n5) continue;
            intList3.add(n6);
        }
        return intList3;
    }

    private static int[] randomSubset(IntList intList, int n, Random random) {
        if (intList.size() < n) {
            n = intList.size();
        }
        int[] nArray = intList.toArray();
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(nArray.length - i);
            int n3 = nArray[i];
            nArray[i] = nArray[i + n2];
            nArray[i + n2] = n3;
        }
        return Arrays.copyOf(nArray, n);
    }

    private void finalUpdateResults(List<IntList> list, int[][] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            IntList intList = list.get(i);
            int[] nArray2 = intList.copyOf(n2 = ImpIbs.insPt(intList, this.nRefHaps));
            if (this.nHapsPerStep < nArray2.length) {
                Random random = new Random(this.seed + (long)intList.get(0));
                Utilities.shuffle(nArray2, random);
                nArray2 = Arrays.copyOf(nArray2, this.nHapsPerStep);
                Arrays.sort(nArray2);
            }
            this.setResult(intList, n2, nArray2, nArray);
        }
    }

    private void setResult(IntList intList, int n, int[] nArray, int[][] nArray2) {
        int n2 = intList.size();
        for (int i = n; i < n2; ++i) {
            nArray2[intList.get((int)i) - this.nRefHaps] = nArray;
        }
    }

    private static int insPt(IntList intList, int n) {
        int n2 = intList.binarySearch(n);
        return n2 >= 0 ? n2 : -n2 - 1;
    }

    public int[] ibsHaps(int n, int n2) {
        return (int[])this.ibsHaps[n2][n].clone();
    }

    public ImpData impData() {
        return this.impData;
    }

    public CodedSteps codedSteps() {
        return this.codedSteps;
    }
}

