/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.events.PromptOutputEvent;

public class YesNoQuestionPromptEvent
extends PromptOutputEvent {
    public static final List<String> YES_NO_CHOICES = Lists.newArrayList((Object[])new String[]{"yes", "no"});
    private final String question;

    public YesNoQuestionPromptEvent(long timestamp, String question) {
        super(timestamp);
        this.question = question;
    }

    public String getQuestion() {
        return this.question;
    }

    @Override
    public String getPrompt() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.question);
        builder.append(" [");
        builder.append(StringUtils.join(YES_NO_CHOICES, (String)", "));
        builder.append("] ");
        return builder.toString();
    }

    public PromptOutputEvent.PromptResult<Boolean> convert(String text) {
        String trimmed = text.trim();
        if (YES_NO_CHOICES.contains(trimmed)) {
            return PromptOutputEvent.PromptResult.response(BooleanUtils.toBoolean((String)trimmed));
        }
        return PromptOutputEvent.PromptResult.newPrompt("Please enter 'yes' or 'no': ");
    }
}

