/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLSocket;
import gnu.javax.net.ssl.provider.Session;
import gnu.javax.net.ssl.provider.SessionContext;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.net.ssl.SSLSession;

class JDBCSessionContext
extends SessionContext {
    protected Connection connection;
    protected PreparedStatement selectById;
    protected PreparedStatement insert;
    protected PreparedStatement selectTimestamp;
    protected PreparedStatement updateTimestamp;
    protected PreparedStatement deleteSession;

    public synchronized Enumeration getIds() {
        Vector vector = new Vector();
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT ID FROM SESSIONS");
            while (resultSet.next()) {
                byte[] byArray = resultSet.getBytes("ID");
                vector.add(byArray);
            }
        }
        catch (SQLException sQLException) {}
        return vector.elements();
    }

    public synchronized SSLSession getSession(byte[] byArray) {
        Session session = (Session)super.getSession(byArray);
        if (session == null) {
            try {
                this.selectById.setBytes(1, byArray);
                ResultSet resultSet = this.selectById.executeQuery();
                if (resultSet.next()) {
                    CertificateFactory certificateFactory;
                    session = new Session(resultSet.getTimestamp("CREATED").getTime());
                    session.enabledSuites = new ArrayList(SSLSocket.supportedSuites);
                    session.enabledProtocols = new TreeSet(SSLSocket.supportedProtocols);
                    session.random = new SecureRandom();
                    session.context = this;
                    session.sessionId = new Session.ID(resultSet.getBytes("ID"));
                    session.setLastAccessedTime(resultSet.getTimestamp("LAST_ACCESSED").getTime());
                    long l = System.currentTimeMillis() - session.getLastAccessedTime();
                    if ((int)(l / 1000L) > this.timeout) {
                        this.removeSession(session.sessionId);
                        return null;
                    }
                    session.peerHost = resultSet.getString("PEER_HOST");
                    String string = resultSet.getString("PROTOCOL");
                    if (string.equals("SSLv3")) {
                        session.protocol = ProtocolVersion.SSL_3;
                    } else if (string.equals("TLSv1")) {
                        session.protocol = ProtocolVersion.TLS_1;
                    } else if (string.equals("TLSv1.1")) {
                        session.protocol = ProtocolVersion.TLS_1_1;
                    } else {
                        return null;
                    }
                    session.cipherSuite = CipherSuite.forName(resultSet.getString("SUITE"));
                    String string2 = resultSet.getString("PEER_CERT_TYPE");
                    boolean bl = resultSet.wasNull();
                    InputStream inputStream = null;
                    if (!bl) {
                        inputStream = resultSet.getBinaryStream("PEER_CERTS");
                        bl = resultSet.wasNull();
                    }
                    if (!bl) {
                        certificateFactory = CertificateFactory.getInstance(string2);
                        session.peerCerts = (Certificate[])certificateFactory.generateCertificates(inputStream).toArray(new Certificate[0]);
                        session.peerVerified = true;
                    }
                    string2 = resultSet.getString("CERT_TYPE");
                    bl = resultSet.wasNull();
                    if (!bl) {
                        inputStream = resultSet.getBinaryStream("CERTS");
                        bl = resultSet.wasNull();
                    }
                    if (!bl) {
                        certificateFactory = CertificateFactory.getInstance(string2);
                        session.localCerts = (Certificate[])certificateFactory.generateCertificates(inputStream).toArray(new Certificate[0]);
                    }
                    session.masterSecret = resultSet.getBytes("SECRET");
                    if (this.cacheSize == 0 || this.sessions.size() < this.cacheSize) {
                        this.sessions.put(session.sessionId, session);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return session;
    }

    synchronized boolean addSession(Session.ID iD, Session session) {
        if (this.containsSessionID(iD)) {
            return false;
        }
        try {
            this.insert.setBytes(1, iD.getId());
            this.insert.setTimestamp(2, new Timestamp(session.getCreationTime()));
            this.insert.setTimestamp(3, new Timestamp(session.getLastAccessedTime()));
            this.insert.setString(4, session.getProtocol());
            this.insert.setString(5, session.getCipherSuite());
            this.insert.setString(6, session.peerHost);
            if (session.peerCerts != null && session.peerCerts.length > 0) {
                this.insert.setString(7, session.peerCerts[0].getType());
                this.insert.setBytes(8, this.certs(session.peerCerts));
            } else {
                this.insert.setNull(7, 12);
                this.insert.setNull(8, -4);
            }
            if (session.localCerts != null && session.localCerts.length > 0) {
                this.insert.setString(9, session.localCerts[0].getType());
                this.insert.setBytes(10, this.certs(session.localCerts));
            } else {
                this.insert.setNull(9, 12);
                this.insert.setNull(10, -4);
            }
            this.insert.setBytes(11, session.masterSecret);
            this.insert.executeUpdate();
            super.addSession(iD, session);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    synchronized boolean containsSessionID(Session.ID iD) {
        try {
            this.selectTimestamp.setBytes(1, iD.getId());
            ResultSet resultSet = this.selectTimestamp.executeQuery();
            if (!resultSet.next()) {
                return false;
            }
            Timestamp timestamp = resultSet.getTimestamp("CREATED");
            if (resultSet.wasNull()) {
                return false;
            }
            long l = System.currentTimeMillis() - timestamp.getTime();
            if ((int)(l / 1000L) > this.timeout) {
                this.removeSession(iD);
                return false;
            }
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    protected boolean removeSession(Session.ID iD) {
        super.removeSession(iD);
        try {
            this.deleteSession.setBytes(1, iD.getId());
            boolean bl = false;
            if (this.deleteSession.executeUpdate() > 0) {
                bl = true;
            }
            return bl;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    synchronized void notifyAccess(Session session) {
        try {
            this.updateTimestamp.setTimestamp(1, new Timestamp(session.getLastAccessedTime()));
            this.updateTimestamp.setBytes(2, session.getId());
            this.updateTimestamp.executeUpdate();
        }
        catch (SQLException sQLException) {}
    }

    private final byte[] certs(Certificate[] certificateArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        int n = 0;
        while (n < certificateArray.length) {
            try {
                byteArrayOutputStream.write(certificateArray[n].getEncoded());
            }
            catch (Exception exception) {}
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    JDBCSessionContext() throws SQLException {
        String string = Util.getSecurityProperty("jessie.SessionContext.jdbc.url");
        String string2 = Util.getSecurityProperty("jessie.SessionContext.jdbc.user");
        String string3 = Util.getSecurityProperty("jessie.SessionContext.jdbc.password");
        if (string == null) {
            throw new IllegalArgumentException("no JDBC URL");
        }
        this.connection = string2 == null || string3 == null ? DriverManager.getConnection(string) : DriverManager.getConnection(string, string2, string3);
        this.selectById = this.connection.prepareStatement("SELECT * FROM SESSIONS WHERE ID = ?");
        this.insert = this.connection.prepareStatement("INSERT INTO SESSIONS VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.selectTimestamp = this.connection.prepareStatement("SELECT CREATED FROM SESSIONS WHERE ID = ?");
        this.updateTimestamp = this.connection.prepareStatement("UPDATE SESSIONS SET LAST_ACCESSED = ? WHERE ID = ?");
        this.deleteSession = this.connection.prepareStatement("DELETE FROM SESSIONS WHERE ID = ?");
    }
}

