/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import gnu.java.rmi.RMIMarshalledObjectInputStream;
import gnu.java.rmi.RMIMarshalledObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class MarshalledObject
implements Serializable {
    private static final long serialVersionUID = 8988374069173025854L;
    byte[] objBytes;
    byte[] locBytes;
    int hash;

    public final boolean equals(Object object) {
        if (!(object instanceof MarshalledObject)) {
            return false;
        }
        if (object.hashCode() != this.hash) {
            return false;
        }
        MarshalledObject marshalledObject = (MarshalledObject)object;
        if (this.objBytes == null || marshalledObject.objBytes == null) {
            boolean bl = false;
            if (this.objBytes == marshalledObject.objBytes) {
                bl = true;
            }
            return bl;
        }
        if (this.objBytes.length != marshalledObject.objBytes.length) {
            return false;
        }
        int n = 0;
        while (n < this.objBytes.length) {
            if (this.objBytes[n] != marshalledObject.objBytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        RMIMarshalledObjectInputStream rMIMarshalledObjectInputStream = new RMIMarshalledObjectInputStream(this.objBytes, this.locBytes);
        return rMIMarshalledObjectInputStream.readObject();
    }

    public final int hashCode() {
        return this.hash;
    }

    public MarshalledObject(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RMIMarshalledObjectOutputStream rMIMarshalledObjectOutputStream = new RMIMarshalledObjectOutputStream(byteArrayOutputStream);
        rMIMarshalledObjectOutputStream.writeObject(object);
        rMIMarshalledObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        this.locBytes = rMIMarshalledObjectOutputStream.getLocBytes();
        this.hash = 0;
        int n = 0;
        while (n < this.objBytes.length) {
            this.hash = this.hash * 31 + this.objBytes[n];
            ++n;
        }
        if (this.locBytes != null) {
            n = 0;
            while (n < this.locBytes.length) {
                this.hash = this.hash * 31 + this.locBytes[n];
                ++n;
            }
        }
    }
}

