/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_H__
#define __SG_PLUGIN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gmodule.h>

#define SG_PLUGIN(obj)        GTK_CHECK_CAST (obj, sg_plugin_get_type (), SGplugin)
#define GTK_TYPE_SG_PLUGIN   (sg_plugin_get_type ())

#define SG_PLUGIN_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_get_type(), SGpluginClass)
#define GTK_IS_SG_PLUGIN(obj)     GTK_CHECK_TYPE (obj, sg_plugin_get_type ())

typedef struct _SGplugin SGplugin;
typedef struct _SGpluginClass SGpluginClass;

struct _SGplugin 
{
  GObject object;

  gchar *name;
  gchar *description;

  GModule *handle;
};

struct _SGpluginClass
{
  GObjectClass parent_class;
};


GType		sg_plugin_get_type			(void);
SGplugin	*sg_plugin_new				(void);

void		sg_plugin_set_name			(SGplugin *plugin,
							 const gchar *name);
void		sg_plugin_set_description		(SGplugin *plugin,
							 const gchar *desc);
GList *		sg_plugins				(void);
void		sg_plugins_init				(void);
void		sg_plugins_quit				(void);
void		sg_plugin_add				(SGplugin *plugin);
SGplugin*	sg_plugin_get   			(const gchar *name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_H__ */
