#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
author: Francisco Munoz (@fmunoz)
description:
  - Get all networks _wireless _ssids _splash _settings.
  - Display the splash page settings for the given SSID.
extends_documentation_fragment:
  - cisco.meraki.module_info
module: networks_wireless_ssids_splash_settings_info
notes:
  - SDK Method used are wireless.Wireless.get_network_wireless_ssid_splash_settings,
  - Paths used are get /networks/{networkId}/wireless/ssids/{number}/splash/settings,
options:
  headers:
    description: Additional headers.
    type: dict
  networkId:
    description:
      - NetworkId path parameter. Network ID.
    type: str
  number:
    description:
      - Number path parameter.
    type: str
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - description: Complete reference of the getNetworkWirelessSsidSplashSettings API.
    link: https://developer.cisco.com/meraki/api-v1/#!get-network-wireless-ssid-splash-settings
    name: Cisco Meraki documentation for wireless getNetworkWirelessSsidSplashSettings
short_description: Information module for networks _wireless _ssids _splash _settings
version_added: 2.16.0
"""

EXAMPLES = r"""
- name: Get all networks _wireless _ssids _splash _settings
  cisco.meraki.networks_wireless_ssids_splash_settings_info:
    meraki_api_key: '{{ meraki_api_key }}'
    meraki_base_url: '{{ meraki_base_url }}'
    meraki_single_request_timeout: '{{ meraki_single_request_timeout }}'
    meraki_certificate_path: '{{ meraki_certificate_path }}'
    meraki_requests_proxy: '{{ meraki_requests_proxy }}'
    meraki_wait_on_rate_limit: '{{ meraki_wait_on_rate_limit }}'
    meraki_nginx_429_retry_wait_time: '{{ meraki_nginx_429_retry_wait_time }}'
    meraki_action_batch_retry_wait_time: '{{ meraki_action_batch_retry_wait_time }}'
    meraki_retry_4xx_error: '{{ meraki_retry_4xx_error }}'
    meraki_retry_4xx_error_wait_time: '{{ meraki_retry_4xx_error_wait_time }}'
    meraki_maximum_retries: '{{ meraki_maximum_retries }}'
    meraki_output_log: '{{ meraki_output_log }}'
    meraki_log_file_prefix: '{{ meraki_log_file_prefix }}'
    meraki_log_path: '{{ meraki_log_path }}'
    meraki_print_console: '{{ meraki_print_console }}'
    meraki_suppress_logging: '{{ meraki_suppress_logging }}'
    meraki_simulate: '{{ meraki_simulate }}'
    meraki_be_geo_id: '{{ meraki_be_geo_id }}'
    meraki_use_iterator_for_get_pages: '{{ meraki_use_iterator_for_get_pages }}'
    meraki_inherit_logging_config: '{{ meraki_inherit_logging_config }}'
    networkId: string
    number: string
  register: result
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "allowSimultaneousLogins": true,
      "billing": {
        "freeAccess": {
          "durationInMinutes": 0,
          "enabled": true
        },
        "prepaidAccessFastLoginEnabled": true,
        "replyToEmailAddress": "string"
      },
      "blockAllTrafficBeforeSignOn": true,
      "controllerDisconnectionBehavior": "string",
      "guestSponsorship": {
        "durationInMinutes": 0,
        "guestCanRequestTimeframe": true
      },
      "redirectUrl": "string",
      "selfRegistration": {
        "authorizationType": "string",
        "enabled": true
      },
      "sentryEnrollment": {
        "enforcedSystems": [
          "string"
        ],
        "strength": "string",
        "systemsManagerNetwork": {
          "id": "string"
        }
      },
      "splashImage": {
        "extension": "string",
        "md5": "string"
      },
      "splashLogo": {
        "extension": "string",
        "md5": "string"
      },
      "splashPage": "string",
      "splashPrepaidFront": {
        "extension": "string",
        "md5": "string"
      },
      "splashTimeout": 0,
      "splashUrl": "string",
      "ssidNumber": 0,
      "themeId": "string",
      "useRedirectUrl": true,
      "useSplashUrl": true,
      "welcomeMessage": "string"
    }
"""
