/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.CallStack;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;

class BSHCastExpression
extends SimpleNode {
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        Class clazz = ((BSHType)this.jjtGetChild(0)).getType(nameSpace);
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(1);
        Object object = simpleNode.eval(callStack, interpreter);
        Class<?> clazz2 = object.getClass();
        try {
            return BSHCastExpression.castObject(object, clazz);
        }
        catch (EvalError evalError) {
            evalError.reThrow(this);
            throw new InterpreterError("can't happen");
        }
    }

    public static Object castObject(Object object, Class clazz) throws EvalError {
        Class<?> clazz2 = object.getClass();
        Object object2 = null;
        if (clazz.isPrimitive()) {
            if (object instanceof Primitive) {
                object2 = BSHCastExpression.castPrimitive((Primitive)object, clazz);
            } else {
                BSHCastExpression.castError(object.getClass(), clazz);
            }
        } else if (object instanceof Primitive) {
            object2 = BSHCastExpression.castPrimitive((Primitive)object, clazz);
        } else if (Capabilities.canGenerateInterfaces() && object instanceof This && clazz.isInterface()) {
            object2 = ((This)object).getInterface(clazz);
        } else if (clazz.isInstance(object)) {
            object2 = object;
        } else {
            BSHCastExpression.castError(clazz2, clazz);
        }
        if (object2 == null) {
            throw new InternalError("bad construct somewhere...");
        }
        return object2;
    }

    public static void castError(Class clazz, Class clazz2) throws EvalError {
        BSHCastExpression.castError(Reflect.normalizeClassName(clazz), Reflect.normalizeClassName(clazz2));
    }

    public static void castError(String string, String string2) throws EvalError {
        ClassCastException classCastException = new ClassCastException("Illegal cast. Cannot cast " + string + " to " + string2);
        throw new TargetError("Cast", classCastException);
    }

    public static Primitive castPrimitive(Primitive primitive, Class clazz) throws EvalError {
        if (primitive == Primitive.VOID) {
            BSHCastExpression.castError("void value", Reflect.normalizeClassName(clazz));
        }
        Object object = primitive.getValue();
        Class clazz2 = primitive.getType();
        if (!clazz.isPrimitive()) {
            if (primitive != Primitive.NULL) {
                BSHCastExpression.castError("primitive value", "object type:" + clazz);
            } else {
                return primitive;
            }
        }
        if (clazz2 == Boolean.TYPE) {
            if (clazz != Boolean.TYPE) {
                BSHCastExpression.castError(clazz2, clazz);
            } else {
                return primitive;
            }
        }
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (clazz == Byte.TYPE) {
                object = new Primitive(number.byteValue());
            } else if (clazz == Short.TYPE) {
                object = new Primitive(number.shortValue());
            } else if (clazz == Character.TYPE) {
                object = new Primitive((char)number.intValue());
            } else if (clazz == Integer.TYPE) {
                object = new Primitive(number.intValue());
            } else if (clazz == Long.TYPE) {
                object = new Primitive(number.longValue());
            } else if (clazz == Float.TYPE) {
                object = new Primitive(number.floatValue());
            } else if (clazz == Double.TYPE) {
                object = new Primitive(number.doubleValue());
            } else {
                BSHCastExpression.castError(clazz2, clazz);
            }
            return (Primitive)object;
        }
        throw new EvalError("unknown type in cast");
    }

    public BSHCastExpression(int n) {
        super(n);
    }
}

