/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.AWTUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.WeakHashMap;

class LightweightDispatcher {
    private static WeakHashMap instances = new WeakHashMap();
    private Component dragTarget;
    private Component lastTarget;

    static LightweightDispatcher getInstance() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        LightweightDispatcher lightweightDispatcher = (LightweightDispatcher)instances.get(threadGroup);
        if (lightweightDispatcher == null) {
            lightweightDispatcher = new LightweightDispatcher();
            instances.put(threadGroup, lightweightDispatcher);
        }
        return lightweightDispatcher;
    }

    public boolean dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent && aWTEvent.getSource() instanceof Window) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            return this.handleMouseEvent(mouseEvent);
        }
        return false;
    }

    private final boolean handleMouseEvent(MouseEvent mouseEvent) {
        Window window = (Window)mouseEvent.getSource();
        Component component = window.findComponentAt(mouseEvent.getX(), mouseEvent.getY());
        if (component != null && component.isLightweight()) {
            Point point;
            if (component != this.lastTarget) {
                MouseEvent mouseEvent2;
                if (this.lastTarget != null) {
                    point = AWTUtilities.convertPoint(window, mouseEvent.getX(), mouseEvent.getY(), this.lastTarget);
                    mouseEvent2 = new MouseEvent(this.lastTarget, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    this.lastTarget.dispatchEvent(mouseEvent2);
                }
                point = AWTUtilities.convertPoint(window, mouseEvent.getX(), mouseEvent.getY(), component);
                mouseEvent2 = new MouseEvent(component, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                component.dispatchEvent(mouseEvent2);
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    this.dragTarget = component;
                    break;
                }
                case 502: {
                    if (this.dragTarget != null) {
                        component = this.dragTarget;
                    }
                    this.dragTarget = null;
                    break;
                }
                case 500: {
                    component = this.lastTarget;
                    break;
                }
                case 506: {
                    component = this.dragTarget;
                    break;
                }
            }
            this.lastTarget = component;
            point = AWTUtilities.convertPoint(window, mouseEvent.getX(), mouseEvent.getY(), component);
            int n = point.x - mouseEvent.getX();
            int n2 = point.y - mouseEvent.getY();
            mouseEvent.translatePoint(n, n2);
            mouseEvent.setSource(component);
            component.dispatchEvent(mouseEvent);
            mouseEvent.setSource(window);
            mouseEvent.translatePoint(-n, -n2);
            return true;
        }
        return false;
    }

    private LightweightDispatcher() {
    }
}

