/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_DATASET_H__
#define __SG_DATASET_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin_style.h"

#define SG_DATASET(obj)        GTK_CHECK_CAST (obj, sg_dataset_get_type (), SGdataset)
#define GTK_TYPE_SG_DATASET   (sg_dataset_get_type ())

#define SG_DATASET_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_dataset_get_type(), SGdatasetClass)
#define GTK_IS_SG_DATASET(obj)     GTK_CHECK_TYPE (obj, sg_dataset_get_type ())

typedef struct _SGdataset SGdataset;
typedef struct _SGdatasetClass SGdatasetClass;

struct _SGdataset 
{
  GObject object;

  gchar *name;
  gchar *description;
  GList *children;
  GtkPlotArrayList *arrays;

  gint id;

  SGpluginStyle *constructor;
  SGplugin *plugin;

  gint ref_count;
};

struct _SGdatasetClass 
{
  GObjectClass parent_class;

  void (*set_iterator) (SGdataset *dataset);
  void (*refresh) (SGdataset *dataset);
  GtkPlotData * (*new_child) (SGdataset *dataset);
  gboolean (*connected) (SGdataset *dataset, gpointer data);
};

GType		sg_dataset_get_type		(void);
SGdataset*	sg_dataset_new			(); 
void		sg_dataset_construct		(SGdataset *dataset,
						 SGpluginStyle *style);
GtkPlotData *	sg_dataset_new_child		(SGdataset *dataset);
void		sg_dataset_add_child		(SGdataset *dataset,
						 GtkPlotData *child);
void		sg_dataset_remove_child		(SGdataset *dataset,
						 GtkPlotData *child);
void		sg_dataset_set_name		(SGdataset *dataset,
						 const gchar *name); 
void		sg_dataset_set_description	(SGdataset *dataset,
						 const gchar *description); 
void		sg_dataset_refresh		(SGdataset *dataset); 
GtkPlotArray *	sg_dataset_set_points		(SGdataset *dataset,
						 const gchar *array,
						 gdouble *points,
						 gint npoints);
GtkPlotArray *	sg_dataset_set_labels		(SGdataset *dataset,
						 gchar **labels,
						 gint npoints);
void		sg_dataset_set_arrays		(SGdataset *dataset,
						 GtkPlotArrayList *arrays);
void		sg_dataset_refresh_arrays	(SGdataset *dataset);
void		sg_dataset_free_points		(SGdataset *dataset); 
gboolean	sg_dataset_is_connected		(SGdataset *dataset,
						 gpointer data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_DATASET_H__ */

