require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__NVMEREG_H__)) {
    eval 'sub __NVMEREG_H__ () {1;}' unless defined(&__NVMEREG_H__);
    unless(defined(&NVME_CTASSERT)) {
	eval 'sub NVME_CTASSERT {
	    my($x, $s) = @_;
    	    eval q( &__CTASSERT($x));
	}' unless defined(&NVME_CTASSERT);
    }
    eval 'sub NVME_CAP () {0x;}' unless defined(&NVME_CAP);
    eval 'sub NVME_CAP_MPSMAX {
        my($_r) = @_;
	    eval q((12+ ((($_r) >> 52) & 0xf)));
    }' unless defined(&NVME_CAP_MPSMAX);
    eval 'sub NVME_CAP_MPSMIN {
        my($_r) = @_;
	    eval q((12+ ((($_r) >> 48) & 0xf)));
    }' unless defined(&NVME_CAP_MPSMIN);
    eval 'sub NVME_CAP_CSS {
        my($_r) = @_;
	    eval q(((($_r) >> 37) & 0x7f));
    }' unless defined(&NVME_CAP_CSS);
    eval 'sub NVME_CAP_CSS_NVM () { &__BIT(0);}' unless defined(&NVME_CAP_CSS_NVM);
    eval 'sub NVME_CAP_NSSRS {
        my($_r) = @_;
	    eval q( &ISSET(($_r),  &__BIT(36)));
    }' unless defined(&NVME_CAP_NSSRS);
    eval 'sub NVME_CAP_DSTRD {
        my($_r) = @_;
	    eval q( &__BIT(2+ ((($_r) >> 32) & 0xf)));
    }' unless defined(&NVME_CAP_DSTRD);
    eval 'sub NVME_CAP_TO {
        my($_r) = @_;
	    eval q((500* ((($_r) >> 24) & 0xff)));
    }' unless defined(&NVME_CAP_TO);
    eval 'sub NVME_CAP_AMS {
        my($_r) = @_;
	    eval q(((($_r) >> 17) & 0x3));
    }' unless defined(&NVME_CAP_AMS);
    eval 'sub NVME_CAP_AMS_WRR () { &__BIT(0);}' unless defined(&NVME_CAP_AMS_WRR);
    eval 'sub NVME_CAP_AMS_VENDOR () { &__BIT(1);}' unless defined(&NVME_CAP_AMS_VENDOR);
    eval 'sub NVME_CAP_CQR {
        my($_r) = @_;
	    eval q( &ISSET(($_r),  &__BIT(16)));
    }' unless defined(&NVME_CAP_CQR);
    eval 'sub NVME_CAP_MQES {
        my($_r) = @_;
	    eval q(((($_r) & 0xffff) + 1));
    }' unless defined(&NVME_CAP_MQES);
    eval 'sub NVME_CAP_LO () {0x;}' unless defined(&NVME_CAP_LO);
    eval 'sub NVME_CAP_HI () {0x4;}' unless defined(&NVME_CAP_HI);
    eval 'sub NVME_VS () {0x8;}' unless defined(&NVME_VS);
    eval 'sub NVME_VS_MJR {
        my($_r) = @_;
	    eval q(((($_r) >> 16) & 0xffff));
    }' unless defined(&NVME_VS_MJR);
    eval 'sub NVME_VS_MNR {
        my($_r) = @_;
	    eval q(((($_r) >> 8) & 0xff));
    }' unless defined(&NVME_VS_MNR);
    eval 'sub NVME_VS_TER {
        my($_r) = @_;
	    eval q((($_r) & 0xff));
    }' unless defined(&NVME_VS_TER);
    eval 'sub NVME_INTMS () {0xc;}' unless defined(&NVME_INTMS);
    eval 'sub NVME_INTMC () {0x10;}' unless defined(&NVME_INTMC);
    eval 'sub NVME_CC () {0x14;}' unless defined(&NVME_CC);
    eval 'sub NVME_CC_IOCQES {
        my($_v) = @_;
	    eval q(((($_v) & 0xf) << 20));
    }' unless defined(&NVME_CC_IOCQES);
    eval 'sub NVME_CC_IOCQES_MASK () { &NVME_CC_IOCQES(0xf);}' unless defined(&NVME_CC_IOCQES_MASK);
    eval 'sub NVME_CC_IOCQES_R {
        my($_v) = @_;
	    eval q(((($_v) >> 20) & 0xf));
    }' unless defined(&NVME_CC_IOCQES_R);
    eval 'sub NVME_CC_IOSQES {
        my($_v) = @_;
	    eval q(((($_v) & 0xf) << 16));
    }' unless defined(&NVME_CC_IOSQES);
    eval 'sub NVME_CC_IOSQES_MASK () { &NVME_CC_IOSQES(0xf);}' unless defined(&NVME_CC_IOSQES_MASK);
    eval 'sub NVME_CC_IOSQES_R {
        my($_v) = @_;
	    eval q(((($_v) >> 16) & 0xf));
    }' unless defined(&NVME_CC_IOSQES_R);
    eval 'sub NVME_CC_SHN {
        my($_v) = @_;
	    eval q(((($_v) & 0x3) << 14));
    }' unless defined(&NVME_CC_SHN);
    eval 'sub NVME_CC_SHN_MASK () { &NVME_CC_SHN(0x3);}' unless defined(&NVME_CC_SHN_MASK);
    eval 'sub NVME_CC_SHN_R {
        my($_v) = @_;
	    eval q(((($_v) >> 15) & 0x3));
    }' unless defined(&NVME_CC_SHN_R);
    eval 'sub NVME_CC_SHN_NONE () {0;}' unless defined(&NVME_CC_SHN_NONE);
    eval 'sub NVME_CC_SHN_NORMAL () {1;}' unless defined(&NVME_CC_SHN_NORMAL);
    eval 'sub NVME_CC_SHN_ABRUPT () {2;}' unless defined(&NVME_CC_SHN_ABRUPT);
    eval 'sub NVME_CC_AMS {
        my($_v) = @_;
	    eval q(((($_v) & 0x7) << 11));
    }' unless defined(&NVME_CC_AMS);
    eval 'sub NVME_CC_AMS_MASK () { &NVME_CC_AMS(0x7);}' unless defined(&NVME_CC_AMS_MASK);
    eval 'sub NVME_CC_AMS_R {
        my($_v) = @_;
	    eval q(((($_v) >> 11) & 0xf));
    }' unless defined(&NVME_CC_AMS_R);
    eval 'sub NVME_CC_AMS_RR () {0;}' unless defined(&NVME_CC_AMS_RR);
    eval 'sub NVME_CC_AMS_WRR_U () {1;}' unless defined(&NVME_CC_AMS_WRR_U);
    eval 'sub NVME_CC_AMS_VENDOR () {7;}' unless defined(&NVME_CC_AMS_VENDOR);
    eval 'sub NVME_CC_MPS {
        my($_v) = @_;
	    eval q((((($_v) - 12) & 0xf) << 7));
    }' unless defined(&NVME_CC_MPS);
    eval 'sub NVME_CC_MPS_MASK () {(0xf << 7);}' unless defined(&NVME_CC_MPS_MASK);
    eval 'sub NVME_CC_MPS_R {
        my($_v) = @_;
	    eval q((12+ ((($_v) >> 7) & 0xf)));
    }' unless defined(&NVME_CC_MPS_R);
    eval 'sub NVME_CC_CSS {
        my($_v) = @_;
	    eval q(((($_v) & 0x7) << 4));
    }' unless defined(&NVME_CC_CSS);
    eval 'sub NVME_CC_CSS_MASK () { &NVME_CC_CSS(0x7);}' unless defined(&NVME_CC_CSS_MASK);
    eval 'sub NVME_CC_CSS_R {
        my($_v) = @_;
	    eval q(((($_v) >> 4) & 0x7));
    }' unless defined(&NVME_CC_CSS_R);
    eval 'sub NVME_CC_CSS_NVM () {0;}' unless defined(&NVME_CC_CSS_NVM);
    eval 'sub NVME_CC_EN () { &__BIT(0);}' unless defined(&NVME_CC_EN);
    eval 'sub NVME_CSTS () {0x1c;}' unless defined(&NVME_CSTS);
    eval 'sub NVME_CSTS_SHST_MASK () {(0x3 << 2);}' unless defined(&NVME_CSTS_SHST_MASK);
    eval 'sub NVME_CSTS_SHST_NONE () {(0x << 2);}' unless defined(&NVME_CSTS_SHST_NONE);
    eval 'sub NVME_CSTS_SHST_WAIT () {(0x1 << 2);}' unless defined(&NVME_CSTS_SHST_WAIT);
    eval 'sub NVME_CSTS_SHST_DONE () {(0x2 << 2);}' unless defined(&NVME_CSTS_SHST_DONE);
    eval 'sub NVME_CSTS_CFS () { &__BIT(1);}' unless defined(&NVME_CSTS_CFS);
    eval 'sub NVME_CSTS_RDY () { &__BIT(0);}' unless defined(&NVME_CSTS_RDY);
    eval 'sub NVME_NSSR () {0x20;}' unless defined(&NVME_NSSR);
    eval 'sub NVME_AQA () {0x24;}' unless defined(&NVME_AQA);
    eval 'sub NVME_AQA_ACQS {
        my($_v) = @_;
	    eval q(((($_v) - 1) << 16));
    }' unless defined(&NVME_AQA_ACQS);
    eval 'sub NVME_AQA_ACQS_R {
        my($_v) = @_;
	    eval q((($_v >> 16) & ( &__BIT(12) - 1)));
    }' unless defined(&NVME_AQA_ACQS_R);
    eval 'sub NVME_AQA_ASQS {
        my($_v) = @_;
	    eval q(((($_v) - 1) << 0));
    }' unless defined(&NVME_AQA_ASQS);
    eval 'sub NVME_AQA_ASQS_R {
        my($_v) = @_;
	    eval q(($_v & ( &__BIT(12) - 1)));
    }' unless defined(&NVME_AQA_ASQS_R);
    eval 'sub NVME_ASQ () {0x28;}' unless defined(&NVME_ASQ);
    eval 'sub NVME_ACQ () {0x30;}' unless defined(&NVME_ACQ);
    eval 'sub NVME_ADMIN_Q () {0;}' unless defined(&NVME_ADMIN_Q);
    eval 'sub NVME_SQTDBL {
        my($_q, $_s) = @_;
	    eval q((0x1000 + (2* ($_q) + 0) * ($_s)));
    }' unless defined(&NVME_SQTDBL);
    eval 'sub NVME_CQHDBL {
        my($_q, $_s) = @_;
	    eval q((0x1000 + (2* ($_q) + 1) * ($_s)));
    }' unless defined(&NVME_CQHDBL);
    eval 'sub NVM_SQE_SQ_QPRIO_URG () {(0x << 1);}' unless defined(&NVM_SQE_SQ_QPRIO_URG);
    eval 'sub NVM_SQE_SQ_QPRIO_HI () {(0x1 << 1);}' unless defined(&NVM_SQE_SQ_QPRIO_HI);
    eval 'sub NVM_SQE_SQ_QPRIO_MED () {(0x2 << 1);}' unless defined(&NVM_SQE_SQ_QPRIO_MED);
    eval 'sub NVM_SQE_SQ_QPRIO_LOW () {(0x3 << 1);}' unless defined(&NVM_SQE_SQ_QPRIO_LOW);
    eval 'sub NVM_SQE_CQ_IEN () { &__BIT(1);}' unless defined(&NVM_SQE_CQ_IEN);
    eval 'sub NVM_SQE_Q_PC () { &__BIT(0);}' unless defined(&NVM_SQE_Q_PC);
    eval 'sub NVM_SQE_IO_LR () { &__BIT(15);}' unless defined(&NVM_SQE_IO_LR);
    eval 'sub NVM_SQE_IO_FUA () { &__BIT(14);}' unless defined(&NVM_SQE_IO_FUA);
    eval 'sub NVM_SQE_IO_INCOMP () { &__BIT(7);}' unless defined(&NVM_SQE_IO_INCOMP);
    eval 'sub NVM_SQE_IO_SEQ () { &__BIT(6);}' unless defined(&NVM_SQE_IO_SEQ);
    eval 'sub NVM_SQE_IO_LAT_MASK () { &__BITS(4, 5);}' unless defined(&NVM_SQE_IO_LAT_MASK);
    eval 'sub NVM_SQE_IO_LAT_NONE () {0;}' unless defined(&NVM_SQE_IO_LAT_NONE);
    eval 'sub NVM_SQE_IO_LAT_IDLE () { &__BIT(4);}' unless defined(&NVM_SQE_IO_LAT_IDLE);
    eval 'sub NVM_SQE_IO_LAT_NORMAL () { &__BIT(5);}' unless defined(&NVM_SQE_IO_LAT_NORMAL);
    eval 'sub NVM_SQE_IO_LAT_LOW () { &__BITS(4, 5);}' unless defined(&NVM_SQE_IO_LAT_LOW);
    eval 'sub NVM_SQE_IO_FREQ_MASK () { &__BITS(0, 3);}' unless defined(&NVM_SQE_IO_FREQ_MASK);
    eval 'sub NVM_SQE_IO_FREQ_TYPICAL () {0x1;}' unless defined(&NVM_SQE_IO_FREQ_TYPICAL);
    eval 'sub NVM_SQE_IO_FREQ_INFR_INFW () {0x2;}' unless defined(&NVM_SQE_IO_FREQ_INFR_INFW);
    eval 'sub NVM_SQE_IO_FREQ_FRR_INFW () {0x3;}' unless defined(&NVM_SQE_IO_FREQ_FRR_INFW);
    eval 'sub NVM_SQE_IO_FREQ_INFR_FRW () {0x4;}' unless defined(&NVM_SQE_IO_FREQ_INFR_FRW);
    eval 'sub NVM_SQE_IO_FREQ_FRR_FRW () {0x5;}' unless defined(&NVM_SQE_IO_FREQ_FRR_FRW);
    eval 'sub NVM_SQE_IO_FREQ_ONCE () {0x6;}' unless defined(&NVM_SQE_IO_FREQ_ONCE);
    eval 'sub NVM_SQE_IO_FREQ_SPEC () {0x7;}' unless defined(&NVM_SQE_IO_FREQ_SPEC);
    eval 'sub NVM_SQE_IO_FREQ_OVERWRITE () {0x8;}' unless defined(&NVM_SQE_IO_FREQ_OVERWRITE);
    eval 'sub NVME_CQE_DNR () { &__BIT(15);}' unless defined(&NVME_CQE_DNR);
    eval 'sub NVME_CQE_M () { &__BIT(14);}' unless defined(&NVME_CQE_M);
    eval 'sub NVME_CQE_SCT_MASK () { &__BITS(9, 11);}' unless defined(&NVME_CQE_SCT_MASK);
    eval 'sub NVME_CQE_SCT {
        my($_f) = @_;
	    eval q((($_f) &  &NVME_CQE_SCT_MASK));
    }' unless defined(&NVME_CQE_SCT);
    eval 'sub NVME_CQE_SCT_GENERIC () {(0x << 9);}' unless defined(&NVME_CQE_SCT_GENERIC);
    eval 'sub NVME_CQE_SCT_COMMAND () {(0x1 << 9);}' unless defined(&NVME_CQE_SCT_COMMAND);
    eval 'sub NVME_CQE_SCT_MEDIAERR () {(0x2 << 9);}' unless defined(&NVME_CQE_SCT_MEDIAERR);
    eval 'sub NVME_CQE_SCT_VENDOR () {(0x7 << 9);}' unless defined(&NVME_CQE_SCT_VENDOR);
    eval 'sub NVME_CQE_SC_MASK () { &__BITS(1, 8);}' unless defined(&NVME_CQE_SC_MASK);
    eval 'sub NVME_CQE_SC {
        my($_f) = @_;
	    eval q((($_f) &  &NVME_CQE_SC_MASK));
    }' unless defined(&NVME_CQE_SC);
    eval 'sub NVME_CQE_SC_SUCCESS () {(0x << 1);}' unless defined(&NVME_CQE_SC_SUCCESS);
    eval 'sub NVME_CQE_SC_INVALID_OPCODE () {(0x1 << 1);}' unless defined(&NVME_CQE_SC_INVALID_OPCODE);
    eval 'sub NVME_CQE_SC_INVALID_FIELD () {(0x2 << 1);}' unless defined(&NVME_CQE_SC_INVALID_FIELD);
    eval 'sub NVME_CQE_SC_CID_CONFLICT () {(0x3 << 1);}' unless defined(&NVME_CQE_SC_CID_CONFLICT);
    eval 'sub NVME_CQE_SC_DATA_XFER_ERR () {(0x4 << 1);}' unless defined(&NVME_CQE_SC_DATA_XFER_ERR);
    eval 'sub NVME_CQE_SC_ABRT_BY_NO_PWR () {(0x5 << 1);}' unless defined(&NVME_CQE_SC_ABRT_BY_NO_PWR);
    eval 'sub NVME_CQE_SC_INTERNAL_DEV_ERR () {(0x6 << 1);}' unless defined(&NVME_CQE_SC_INTERNAL_DEV_ERR);
    eval 'sub NVME_CQE_SC_CMD_ABRT_REQD () {(0x7 << 1);}' unless defined(&NVME_CQE_SC_CMD_ABRT_REQD);
    eval 'sub NVME_CQE_SC_CMD_ABDR_SQ_DEL () {(0x8 << 1);}' unless defined(&NVME_CQE_SC_CMD_ABDR_SQ_DEL);
    eval 'sub NVME_CQE_SC_CMD_ABDR_FUSE_ERR () {(0x9 << 1);}' unless defined(&NVME_CQE_SC_CMD_ABDR_FUSE_ERR);
    eval 'sub NVME_CQE_SC_CMD_ABDR_FUSE_MISS () {(0xa << 1);}' unless defined(&NVME_CQE_SC_CMD_ABDR_FUSE_MISS);
    eval 'sub NVME_CQE_SC_INVALID_NS () {(0xb << 1);}' unless defined(&NVME_CQE_SC_INVALID_NS);
    eval 'sub NVME_CQE_SC_CMD_SEQ_ERR () {(0xc << 1);}' unless defined(&NVME_CQE_SC_CMD_SEQ_ERR);
    eval 'sub NVME_CQE_SC_INVALID_LAST_SGL () {(0xd << 1);}' unless defined(&NVME_CQE_SC_INVALID_LAST_SGL);
    eval 'sub NVME_CQE_SC_INVALID_NUM_SGL () {(0xe << 1);}' unless defined(&NVME_CQE_SC_INVALID_NUM_SGL);
    eval 'sub NVME_CQE_SC_DATA_SGL_LEN () {(0xf << 1);}' unless defined(&NVME_CQE_SC_DATA_SGL_LEN);
    eval 'sub NVME_CQE_SC_MDATA_SGL_LEN () {(0x10 << 1);}' unless defined(&NVME_CQE_SC_MDATA_SGL_LEN);
    eval 'sub NVME_CQE_SC_SGL_TYPE_INVALID () {(0x11 << 1);}' unless defined(&NVME_CQE_SC_SGL_TYPE_INVALID);
    eval 'sub NVME_CQE_SC_LBA_RANGE () {(0x80 << 1);}' unless defined(&NVME_CQE_SC_LBA_RANGE);
    eval 'sub NVME_CQE_SC_CAP_EXCEEDED () {(0x81 << 1);}' unless defined(&NVME_CQE_SC_CAP_EXCEEDED);
    eval 'sub NVME_CQE_SC_NS_NOT_RDY () {(0x82 << 1);}' unless defined(&NVME_CQE_SC_NS_NOT_RDY);
    eval 'sub NVME_CQE_SC_RSV_CONFLICT () {(0x83 << 1);}' unless defined(&NVME_CQE_SC_RSV_CONFLICT);
    eval 'sub NVME_CQE_SC_CQE_INVALID () {(0x << 1);}' unless defined(&NVME_CQE_SC_CQE_INVALID);
    eval 'sub NVME_CQE_SC_INVALID_QID () {(0x1 << 1);}' unless defined(&NVME_CQE_SC_INVALID_QID);
    eval 'sub NVME_CQE_SC_MAX_Q_SIZE () {(0x2 << 1);}' unless defined(&NVME_CQE_SC_MAX_Q_SIZE);
    eval 'sub NVME_CQE_SC_ABORT_LIMIT () {(0x3 << 1);}' unless defined(&NVME_CQE_SC_ABORT_LIMIT);
    eval 'sub NVME_CQE_SC_ASYNC_EV_REQ_LIMIT () {(0x5 << 1);}' unless defined(&NVME_CQE_SC_ASYNC_EV_REQ_LIMIT);
    eval 'sub NVME_CQE_SC_INVALID_FW_SLOT () {(0x6 << 1);}' unless defined(&NVME_CQE_SC_INVALID_FW_SLOT);
    eval 'sub NVME_CQE_SC_INVALID_FW_IMAGE () {(0x7 << 1);}' unless defined(&NVME_CQE_SC_INVALID_FW_IMAGE);
    eval 'sub NVME_CQE_SC_INVALID_INT_VEC () {(0x8 << 1);}' unless defined(&NVME_CQE_SC_INVALID_INT_VEC);
    eval 'sub NVME_CQE_SC_INVALID_LOG_PAGE () {(0x9 << 1);}' unless defined(&NVME_CQE_SC_INVALID_LOG_PAGE);
    eval 'sub NVME_CQE_SC_INVALID_FORMAT () {(0xa << 1);}' unless defined(&NVME_CQE_SC_INVALID_FORMAT);
    eval 'sub NVME_CQE_SC_FW_REQ_CNV_RESET () {(0xb << 1);}' unless defined(&NVME_CQE_SC_FW_REQ_CNV_RESET);
    eval 'sub NVME_CQE_SC_FW_REQ_NVM_RESET () {(0x10 << 1);}' unless defined(&NVME_CQE_SC_FW_REQ_NVM_RESET);
    eval 'sub NVME_CQE_SC_FW_REQ_RESET () {(0x11 << 1);}' unless defined(&NVME_CQE_SC_FW_REQ_RESET);
    eval 'sub NVME_CQE_SC_FW_MAX_TIME_VIO () {(0x12 << 1);}' unless defined(&NVME_CQE_SC_FW_MAX_TIME_VIO);
    eval 'sub NVME_CQE_SC_FW_PROHIBIT () {(0x13 << 1);}' unless defined(&NVME_CQE_SC_FW_PROHIBIT);
    eval 'sub NVME_CQE_SC_OVERLAP_RANGE () {(0x14 << 1);}' unless defined(&NVME_CQE_SC_OVERLAP_RANGE);
    eval 'sub NVME_CQE_SC_CONFLICT_ATTRS () {(0x80 << 1);}' unless defined(&NVME_CQE_SC_CONFLICT_ATTRS);
    eval 'sub NVME_CQE_SC_INVALID_PROT_INFO () {(0x81 << 1);}' unless defined(&NVME_CQE_SC_INVALID_PROT_INFO);
    eval 'sub NVME_CQE_SC_ATT_WR_TO_RO_PAGE () {(0x82 << 1);}' unless defined(&NVME_CQE_SC_ATT_WR_TO_RO_PAGE);
    eval 'sub NVME_CQE_SC_WRITE_FAULTS () {(0x80 << 1);}' unless defined(&NVME_CQE_SC_WRITE_FAULTS);
    eval 'sub NVME_CQE_SC_UNRECV_READ_ERR () {(0x81 << 1);}' unless defined(&NVME_CQE_SC_UNRECV_READ_ERR);
    eval 'sub NVME_CQE_SC_GUARD_CHECK_ERR () {(0x82 << 1);}' unless defined(&NVME_CQE_SC_GUARD_CHECK_ERR);
    eval 'sub NVME_CQE_SC_APPL_TAG_CHECK_ERR () {(0x83 << 1);}' unless defined(&NVME_CQE_SC_APPL_TAG_CHECK_ERR);
    eval 'sub NVME_CQE_SC_REF_TAG_CHECK_ERR () {(0x84 << 1);}' unless defined(&NVME_CQE_SC_REF_TAG_CHECK_ERR);
    eval 'sub NVME_CQE_SC_CMP_FAIL () {(0x85 << 1);}' unless defined(&NVME_CQE_SC_CMP_FAIL);
    eval 'sub NVME_CQE_SC_ACCESS_DENIED () {(0x86 << 1);}' unless defined(&NVME_CQE_SC_ACCESS_DENIED);
    eval 'sub NVME_CQE_PHASE () { &__BIT(0);}' unless defined(&NVME_CQE_PHASE);
    eval 'sub NVM_ADMIN_DEL_IOSQ () {0x;}' unless defined(&NVM_ADMIN_DEL_IOSQ);
    eval 'sub NVM_ADMIN_ADD_IOSQ () {0x1;}' unless defined(&NVM_ADMIN_ADD_IOSQ);
    eval 'sub NVM_ADMIN_GET_LOG_PG () {0x2;}' unless defined(&NVM_ADMIN_GET_LOG_PG);
    eval 'sub NVM_ADMIN_DEL_IOCQ () {0x4;}' unless defined(&NVM_ADMIN_DEL_IOCQ);
    eval 'sub NVM_ADMIN_ADD_IOCQ () {0x5;}' unless defined(&NVM_ADMIN_ADD_IOCQ);
    eval 'sub NVM_ADMIN_IDENTIFY () {0x6;}' unless defined(&NVM_ADMIN_IDENTIFY);
    eval 'sub NVM_ADMIN_ABORT () {0x8;}' unless defined(&NVM_ADMIN_ABORT);
    eval 'sub NVM_ADMIN_SET_FEATURES () {0x9;}' unless defined(&NVM_ADMIN_SET_FEATURES);
    eval 'sub NVM_ADMIN_GET_FEATURES () {0xa;}' unless defined(&NVM_ADMIN_GET_FEATURES);
    eval 'sub NVM_ADMIN_ASYNC_EV_REQ () {0xc;}' unless defined(&NVM_ADMIN_ASYNC_EV_REQ);
    eval 'sub NVM_ADMIN_NS_MANAGEMENT () {0xd;}' unless defined(&NVM_ADMIN_NS_MANAGEMENT);
    eval 'sub NVM_ADMIN_FW_COMMIT () {0x10;}' unless defined(&NVM_ADMIN_FW_COMMIT);
    eval 'sub NVM_ADMIN_FW_DOWNLOAD () {0x11;}' unless defined(&NVM_ADMIN_FW_DOWNLOAD);
    eval 'sub NVM_ADMIN_DEV_SELFTEST () {0x14;}' unless defined(&NVM_ADMIN_DEV_SELFTEST);
    eval 'sub NVM_ADMIN_NS_ATTACHMENT () {0x15;}' unless defined(&NVM_ADMIN_NS_ATTACHMENT);
    eval 'sub NVM_ADMIN_KEEP_ALIVE () {0x18;}' unless defined(&NVM_ADMIN_KEEP_ALIVE);
    eval 'sub NVM_ADMIN_DIRECTIVE_SND () {0x19;}' unless defined(&NVM_ADMIN_DIRECTIVE_SND);
    eval 'sub NVM_ADMIN_DIRECTIVE_RCV () {0x1a;}' unless defined(&NVM_ADMIN_DIRECTIVE_RCV);
    eval 'sub NVM_ADMIN_VIRT_MGMT () {0x1c;}' unless defined(&NVM_ADMIN_VIRT_MGMT);
    eval 'sub NVM_ADMIN_NVME_MI_SEND () {0x1d;}' unless defined(&NVM_ADMIN_NVME_MI_SEND);
    eval 'sub NVM_ADMIN_NVME_MI_RECV () {0x1e;}' unless defined(&NVM_ADMIN_NVME_MI_RECV);
    eval 'sub NVM_ADMIN_DOORBELL_BC () {0x7c;}' unless defined(&NVM_ADMIN_DOORBELL_BC);
    eval 'sub NVM_ADMIN_FORMAT_NVM () {0x80;}' unless defined(&NVM_ADMIN_FORMAT_NVM);
    eval 'sub NVM_ADMIN_SECURITY_SND () {0x81;}' unless defined(&NVM_ADMIN_SECURITY_SND);
    eval 'sub NVM_ADMIN_SECURITY_RCV () {0x82;}' unless defined(&NVM_ADMIN_SECURITY_RCV);
    eval 'sub NVM_ADMIN_SANITIZE () {0x84;}' unless defined(&NVM_ADMIN_SANITIZE);
    eval 'sub NVM_CMD_FLUSH () {0x;}' unless defined(&NVM_CMD_FLUSH);
    eval 'sub NVM_CMD_WRITE () {0x1;}' unless defined(&NVM_CMD_WRITE);
    eval 'sub NVM_CMD_READ () {0x2;}' unless defined(&NVM_CMD_READ);
    eval 'sub NVM_CMD_WR_UNCOR () {0x4;}' unless defined(&NVM_CMD_WR_UNCOR);
    eval 'sub NVM_CMD_COMPARE () {0x5;}' unless defined(&NVM_CMD_COMPARE);
    eval 'sub NVM_CMD_WRITE_ZEROES () {0x8;}' unless defined(&NVM_CMD_WRITE_ZEROES);
    eval 'sub NVM_CMD_DSM () {0x9;}' unless defined(&NVM_CMD_DSM);
    eval 'sub NVM_FEAT_ARBITRATION () {0x1;}' unless defined(&NVM_FEAT_ARBITRATION);
    eval 'sub NVM_FEAT_POWER_MANAGEMENT () {0x2;}' unless defined(&NVM_FEAT_POWER_MANAGEMENT);
    eval 'sub NVM_FEAT_LBA_RANGE_TYPE () {0x3;}' unless defined(&NVM_FEAT_LBA_RANGE_TYPE);
    eval 'sub NVM_FEAT_TEMPERATURE_THRESHOLD () {0x4;}' unless defined(&NVM_FEAT_TEMPERATURE_THRESHOLD);
    eval 'sub NVM_FEAT_ERROR_RECOVERY () {0x5;}' unless defined(&NVM_FEAT_ERROR_RECOVERY);
    eval 'sub NVM_FEATURE_VOLATILE_WRITE_CACHE () {0x6;}' unless defined(&NVM_FEATURE_VOLATILE_WRITE_CACHE);
    eval 'sub NVM_FEATURE_NUMBER_OF_QUEUES () {0x7;}' unless defined(&NVM_FEATURE_NUMBER_OF_QUEUES);
    eval 'sub NVM_FEAT_INTERRUPT_COALESCING () {0x8;}' unless defined(&NVM_FEAT_INTERRUPT_COALESCING);
    eval 'sub NVM_FEAT_INTERRUPT_VECTOR_CONFIGURATION () {0x9;}' unless defined(&NVM_FEAT_INTERRUPT_VECTOR_CONFIGURATION);
    eval 'sub NVM_FEAT_WRITE_ATOMICITY () {0xa;}' unless defined(&NVM_FEAT_WRITE_ATOMICITY);
    eval 'sub NVM_FEAT_ASYNC_EVENT_CONFIGURATION () {0xb;}' unless defined(&NVM_FEAT_ASYNC_EVENT_CONFIGURATION);
    eval 'sub NVM_FEAT_AUTONOMOUS_POWER_STATE_TRANSITION () {0xc;}' unless defined(&NVM_FEAT_AUTONOMOUS_POWER_STATE_TRANSITION);
    eval 'sub NVM_FEAT_HOST_MEMORY_BUFFER () {0xd;}' unless defined(&NVM_FEAT_HOST_MEMORY_BUFFER);
    eval 'sub NVM_FEAT_TIMESTAMP () {0xe;}' unless defined(&NVM_FEAT_TIMESTAMP);
    eval 'sub NVM_FEAT_KEEP_ALIVE_TIMER () {0xf;}' unless defined(&NVM_FEAT_KEEP_ALIVE_TIMER);
    eval 'sub NVM_FEAT_HOST_CONTROLLED_THERMAL_MGMT () {0x10;}' unless defined(&NVM_FEAT_HOST_CONTROLLED_THERMAL_MGMT);
    eval 'sub NVM_FEAT_NON_OP_POWER_STATE_CONFIG () {0x11;}' unless defined(&NVM_FEAT_NON_OP_POWER_STATE_CONFIG);
    eval 'sub NVM_FEAT_SOFTWARE_PROGRESS_MARKER () {0x80;}' unless defined(&NVM_FEAT_SOFTWARE_PROGRESS_MARKER);
    eval 'sub NVM_FEAT_HOST_IDENTIFIER () {0x81;}' unless defined(&NVM_FEAT_HOST_IDENTIFIER);
    eval 'sub NVM_FEAT_RESERVATION_NOTIFICATION_MASK () {0x82;}' unless defined(&NVM_FEAT_RESERVATION_NOTIFICATION_MASK);
    eval 'sub NVM_FEAT_RESERVATION_PERSISTANCE () {0x83;}' unless defined(&NVM_FEAT_RESERVATION_PERSISTANCE);
    eval 'sub NVM_SET_FEATURES_SV () { &__BIT(31);}' unless defined(&NVM_SET_FEATURES_SV);
    eval 'sub NVM_VOLATILE_WRITE_CACHE_WCE () { &__BIT(0);}' unless defined(&NVM_VOLATILE_WRITE_CACHE_WCE);
    eval 'sub NVME_PSD_NOPS () { &__BIT(1);}' unless defined(&NVME_PSD_NOPS);
    eval 'sub NVME_PSD_MPS () { &__BIT(0);}' unless defined(&NVME_PSD_MPS);
    eval 'sub NVME_PSD_RRT_MASK () { &__BITS(0, 4);}' unless defined(&NVME_PSD_RRT_MASK);
    eval 'sub NVME_PSD_RRL_MASK () { &__BITS(0, 4);}' unless defined(&NVME_PSD_RRL_MASK);
    eval 'sub NVME_PSD_RWT_MASK () { &__BITS(0, 4);}' unless defined(&NVME_PSD_RWT_MASK);
    eval 'sub NVME_PSD_RWL_MASK () { &__BITS(0, 4);}' unless defined(&NVME_PSD_RWL_MASK);
    eval 'sub NVME_PSD_IPS_MASK () { &__BITS(0, 1);}' unless defined(&NVME_PSD_IPS_MASK);
    eval 'sub NVME_PSD_APW_MASK () { &__BITS(0, 2);}' unless defined(&NVME_PSD_APW_MASK);
    eval 'sub NVME_PSD_APS_MASK () { &__BITS(6, 7);}' unless defined(&NVME_PSD_APS_MASK);
    eval 'sub NVME_ID_CTRLR_OACS_DOORBELL_BC () { &__BIT(8);}' unless defined(&NVME_ID_CTRLR_OACS_DOORBELL_BC);
    eval 'sub NVME_ID_CTRLR_OACS_VIRT_MGMT () { &__BIT(7);}' unless defined(&NVME_ID_CTRLR_OACS_VIRT_MGMT);
    eval 'sub NVME_ID_CTRLR_OACS_NVME_MI () { &__BIT(6);}' unless defined(&NVME_ID_CTRLR_OACS_NVME_MI);
    eval 'sub NVME_ID_CTRLR_OACS_DIRECTIVES () { &__BIT(5);}' unless defined(&NVME_ID_CTRLR_OACS_DIRECTIVES);
    eval 'sub NVME_ID_CTRLR_OACS_DEV_SELFTEST () { &__BIT(4);}' unless defined(&NVME_ID_CTRLR_OACS_DEV_SELFTEST);
    eval 'sub NVME_ID_CTRLR_OACS_NS () { &__BIT(3);}' unless defined(&NVME_ID_CTRLR_OACS_NS);
    eval 'sub NVME_ID_CTRLR_OACS_FW () { &__BIT(2);}' unless defined(&NVME_ID_CTRLR_OACS_FW);
    eval 'sub NVME_ID_CTRLR_OACS_FORMAT () { &__BIT(1);}' unless defined(&NVME_ID_CTRLR_OACS_FORMAT);
    eval 'sub NVME_ID_CTRLR_OACS_SECURITY () { &__BIT(0);}' unless defined(&NVME_ID_CTRLR_OACS_SECURITY);
    eval 'sub NVME_ID_CTRLR_FRMW_NOREQ_RESET () { &__BIT(4);}' unless defined(&NVME_ID_CTRLR_FRMW_NOREQ_RESET);
    eval 'sub NVME_ID_CTRLR_FRMW_NSLOT () { &__BITS(1, 3);}' unless defined(&NVME_ID_CTRLR_FRMW_NSLOT);
    eval 'sub NVME_ID_CTRLR_FRMW_SLOT1_RO () { &__BIT(0);}' unless defined(&NVME_ID_CTRLR_FRMW_SLOT1_RO);
    eval 'sub NVME_ID_CTRLR_LPA_CMD_EFFECT () { &__BIT(1);}' unless defined(&NVME_ID_CTRLR_LPA_CMD_EFFECT);
    eval 'sub NVME_ID_CTRLR_LPA_NS_SMART () { &__BIT(0);}' unless defined(&NVME_ID_CTRLR_LPA_NS_SMART);
    eval 'sub NVME_ID_CTRLR_APSTA_PRESENT () { &__BIT(0);}' unless defined(&NVME_ID_CTRLR_APSTA_PRESENT);
    eval 'sub NVME_ID_CTRLR_SQES_MAX () { &__BITS(4, 7);}' unless defined(&NVME_ID_CTRLR_SQES_MAX);
    eval 'sub NVME_ID_CTRLR_SQES_MIN () { &__BITS(0, 3);}' unless defined(&NVME_ID_CTRLR_SQES_MIN);
    eval 'sub NVME_ID_CTRLR_CQES_MAX () { &__BITS(4, 7);}' unless defined(&NVME_ID_CTRLR_CQES_MAX);
    eval 'sub NVME_ID_CTRLR_CQES_MIN () { &__BITS(0, 3);}' unless defined(&NVME_ID_CTRLR_CQES_MIN);
    eval 'sub NVME_ID_CTRLR_ONCS_TIMESTAMP () { &__BIT(6);}' unless defined(&NVME_ID_CTRLR_ONCS_TIMESTAMP);
    eval 'sub NVME_ID_CTRLR_ONCS_RESERVATION () { &__BIT(5);}' unless defined(&NVME_ID_CTRLR_ONCS_RESERVATION);
    eval 'sub NVME_ID_CTRLR_ONCS_SET_FEATURES () { &__BIT(4);}' unless defined(&NVME_ID_CTRLR_ONCS_SET_FEATURES);
    eval 'sub NVME_ID_CTRLR_ONCS_WRITE_ZERO () { &__BIT(3);}' unless defined(&NVME_ID_CTRLR_ONCS_WRITE_ZERO);
    eval 'sub NVME_ID_CTRLR_ONCS_DSM () { &__BIT(2);}' unless defined(&NVME_ID_CTRLR_ONCS_DSM);
    eval 'sub NVME_ID_CTRLR_ONCS_WRITE_UNC () { &__BIT(1);}' unless defined(&NVME_ID_CTRLR_ONCS_WRITE_UNC);
    eval 'sub NVME_ID_CTRLR_ONCS_COMPARE () { &__BIT(0);}' unless defined(&NVME_ID_CTRLR_ONCS_COMPARE);
    eval 'sub NVME_ID_CTRLR_FNA_CRYPTO_ERASE () { &__BIT(2);}' unless defined(&NVME_ID_CTRLR_FNA_CRYPTO_ERASE);
    eval 'sub NVME_ID_CTRLR_FNA_ERASE_ALL () { &__BIT(1);}' unless defined(&NVME_ID_CTRLR_FNA_ERASE_ALL);
    eval 'sub NVME_ID_CTRLR_FNA_FORMAT_ALL () { &__BIT(0);}' unless defined(&NVME_ID_CTRLR_FNA_FORMAT_ALL);
    eval 'sub NVME_ID_CTRLR_VWC_PRESENT () { &__BIT(0);}' unless defined(&NVME_ID_CTRLR_VWC_PRESENT);
    eval 'sub NVME_ID_NS_NSFEAT_LOGICAL_BLK_ERR () { &__BIT(2);}' unless defined(&NVME_ID_NS_NSFEAT_LOGICAL_BLK_ERR);
    eval 'sub NVME_ID_NS_NSFEAT_NS () { &__BIT(1);}' unless defined(&NVME_ID_NS_NSFEAT_NS);
    eval 'sub NVME_ID_NS_NSFEAT_THIN_PROV () { &__BIT(0);}' unless defined(&NVME_ID_NS_NSFEAT_THIN_PROV);
    eval 'sub NVME_ID_NS_FLBAS {
        my($_f) = @_;
	    eval q((($_f) & 0xf));
    }' unless defined(&NVME_ID_NS_FLBAS);
    eval 'sub NVME_ID_NS_FLBAS_MD () {0x10;}' unless defined(&NVME_ID_NS_FLBAS_MD);
    eval 'sub NVME_ID_NS_DPS_MD_START () { &__BIT(3);}' unless defined(&NVME_ID_NS_DPS_MD_START);
    eval 'sub NVME_ID_NS_DPS_PIT {
        my($_f) = @_;
	    eval q((($_f) & 0x7));
    }' unless defined(&NVME_ID_NS_DPS_PIT);
}
1;
