#ifndef __STK_TEXT
#define __STK_TEXT

#include <list>
#include <string>
using namespace std;


#include "stk_window.h"
#include "../kernel/kernel.h"
#include "stk_fnt.h"






/** This is a widget to draw some string.
 */
class Stk_Gui_Text:public Stk_Gui_Widget
{
public:
        /// Constructor with default font (very slow)
    Stk_Gui_Text(char *txt,char mode);
        /// Constructor 
    Stk_Gui_Text(Stk_Font *,char *txt,char mode);
        /// Destructor
    ~Stk_Gui_Text();
    
        /// Draw Text
    virtual void Draw();

        /// Set Font Size
    void SetFontSize(float);
        /// Get Font Size
    float GetFontSize();
    
protected:
        // the text 
    string  text;
private:
        // the font (&flag to know if we have allocate this font)
    Stk_Font *font;
    char allocate_font;
        /// Mode ( Right:0 Left:1 Center:2 )
    char mode;
};

/** This is an one line edit widget
 */

class Stk_Gui_EditLine:public Stk_Gui_Text
{
public:
        /// Constructor
    Stk_Gui_EditLine(Stk_Font *,char md);

        /// State of this Stk_Gui_EditLine
    int IsActive() const;
        /// Set state
    void SetActive(int);

        /// Message Received
    void MessageReceived(Stk_Message *);

        /// Overload this function: This is called when click with mouse
    virtual void Click();
    
        /// Overload this function: This is called when return or enter is pressed
    virtual void Enter();
    
private:
        /// active to key events ?
    int active;

};


#endif
