/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import gnu.java.math.MPN;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BigInteger
extends Number
implements Comparable {
    private static final long serialVersionUID = -8287574255936472291L;
    private static final int minFixNum = -100;
    private static final int maxFixNum = 1024;
    private static final int numFixNum = 1125;
    private static final BigInteger[] smallFixNums = new BigInteger[1125];
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    public static final BigInteger TEN;
    private static final int FLOOR = 1;
    private static final int CEILING = 2;
    private static final int TRUNCATE = 3;
    private static final int ROUND = 4;
    private static final int[] primes;
    private static final int[] k;
    private static final int[] t;
    private static final byte[] bit4_count;
    private transient int ival;
    private transient int[] words;
    private int bitCount;
    private int bitLength;
    private int firstNonzeroByteNum;
    private int lowestSetBit;
    private byte[] magnitude;
    private int signum;

    private final void init(int n, Random random) {
        int n2 = n & 0x1F;
        if (n2 > 0) {
            n2 = random.nextInt() >>> 32 - n2;
        }
        int n3 = n / 32;
        while (n2 == 0 && n3 > 0) {
            n2 = random.nextInt();
            --n3;
        }
        if (n3 == 0 && n2 >= 0) {
            this.ival = n2;
        } else {
            this.ival = n2 < 0 ? n3 + 2 : n3 + 1;
            this.words = new int[this.ival];
            this.words[n3] = n2;
            while (--n3 >= 0) {
                this.words[n3] = random.nextInt();
            }
        }
    }

    public static BigInteger probablePrime(int n, Random random) {
        if (n < 2) {
            throw new ArithmeticException();
        }
        return new BigInteger(n, 100, random);
    }

    public static BigInteger valueOf(long l) {
        if (l >= -100L && l <= 1024L) {
            return smallFixNums[(int)l - -100];
        }
        int n = (int)l;
        if ((long)n == l) {
            return new BigInteger(n);
        }
        BigInteger bigInteger = BigInteger.alloc(2);
        bigInteger.ival = 2;
        bigInteger.words[0] = n;
        bigInteger.words[1] = (int)(l >> 32);
        return bigInteger;
    }

    private static final BigInteger make(int[] nArray, int n) {
        if (nArray == null) {
            return BigInteger.valueOf(n);
        }
        if ((n = BigInteger.wordsNeeded(nArray, n)) <= 1) {
            return n == 0 ? ZERO : BigInteger.valueOf(nArray[0]);
        }
        BigInteger bigInteger = new BigInteger();
        bigInteger.words = nArray;
        bigInteger.ival = n;
        return bigInteger;
    }

    private static final int[] byteArrayToIntArray(byte[] byArray, int n) {
        int[] nArray = new int[byArray.length / 4 + 1];
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        int n5 = byArray.length % 4;
        while (n5 > 0) {
            n4 = n4 << 8 | byArray[n3] & 0xFF;
            --n5;
            ++n3;
        }
        nArray[--n2] = n4;
        while (n2 > 0) {
            nArray[--n2] = byArray[n3++] << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        }
        return nArray;
    }

    private static final BigInteger alloc(int n) {
        BigInteger bigInteger = new BigInteger();
        if (n > 1) {
            bigInteger.words = new int[n];
        }
        return bigInteger;
    }

    private final void realloc(int n) {
        if (n == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < n || this.words.length > n + 2) {
            int[] nArray = new int[n];
            if (this.words == null) {
                nArray[0] = this.ival;
                this.ival = 1;
            } else {
                if (n < this.ival) {
                    this.ival = n;
                }
                System.arraycopy(this.words, 0, nArray, 0, this.ival);
            }
            this.words = nArray;
        }
    }

    private final boolean isNegative() {
        boolean bl = false;
        if ((this.words == null ? this.ival : this.words[this.ival - 1]) < 0) {
            bl = true;
        }
        return bl;
    }

    public int signum() {
        if (this.ival == 0 && this.words == null) {
            return 0;
        }
        int n = this.words == null ? this.ival : this.words[this.ival - 1];
        return n < 0 ? -1 : 1;
    }

    private static final int compareTo(BigInteger bigInteger, BigInteger bigInteger2) {
        int n;
        boolean bl;
        if (bigInteger.words == null && bigInteger2.words == null) {
            int n2;
            if (bigInteger.ival < bigInteger2.ival) {
                n2 = -1;
            } else {
                n2 = 0;
                if (bigInteger.ival > bigInteger2.ival) {
                    n2 = 1;
                }
            }
            return n2;
        }
        boolean bl2 = bigInteger.isNegative();
        if (bl2 != (bl = bigInteger2.isNegative())) {
            return bl2 ? -1 : 1;
        }
        int n3 = 1;
        if (bigInteger.words != null) {
            n3 = bigInteger.ival;
        }
        int n4 = n3;
        int n5 = 1;
        if (bigInteger2.words != null) {
            n5 = bigInteger2.ival;
        }
        if (n4 != (n = n5)) {
            boolean bl3 = false;
            if (n4 > n) {
                bl3 = true;
            }
            return bl3 != bl2 ? 1 : -1;
        }
        return MPN.cmp(bigInteger.words, bigInteger2.words, n4);
    }

    public int compareTo(Object object) {
        if (object instanceof BigInteger) {
            return BigInteger.compareTo(this, (BigInteger)object);
        }
        throw new ClassCastException();
    }

    public int compareTo(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger);
    }

    public BigInteger min(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger) < 0 ? this : bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        return BigInteger.compareTo(this, bigInteger) > 0 ? this : bigInteger;
    }

    private final boolean isZero() {
        boolean bl = false;
        if (this.words == null && this.ival == 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean isOne() {
        boolean bl = false;
        if (this.words == null && this.ival == 1) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private static final int wordsNeeded(int[] var0, int var1_1) {
        block3: {
            var2_2 = var1_1;
            if (var2_2 <= 0) break block3;
            if ((var3_3 = var0[--var2_2]) != -1) ** GOTO lbl11
            while (var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) < 0) {
                --var2_2;
                if (var3_3 == -1) {
                    continue;
                }
                break block3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl11:
                // 2 sources

                ** while (var3_3 == 0 && var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) >= 0)
            }
        }
        return var2_2 + 1;
    }

    private final BigInteger canonicalize() {
        if (this.words != null && (this.ival = BigInteger.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            this.words = null;
        }
        if (this.words == null && this.ival >= -100 && this.ival <= 1024) {
            return smallFixNums[this.ival - -100];
        }
        return this;
    }

    private static final BigInteger add(int n, int n2) {
        return BigInteger.valueOf((long)n + (long)n2);
    }

    private static final BigInteger add(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger.ival, n);
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setAdd(bigInteger, n);
        return bigInteger2.canonicalize();
    }

    private final void setAdd(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            this.set((long)bigInteger.ival + (long)n);
            return;
        }
        int n2 = bigInteger.ival;
        this.realloc(n2 + 1);
        long l = n;
        int n3 = 0;
        while (n3 < n2) {
            this.words[n3] = (int)(l += (long)bigInteger.words[n3] & 0xFFFFFFFFL);
            l >>= 32;
            ++n3;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            --l;
        }
        this.words[n2] = (int)l;
        this.ival = BigInteger.wordsNeeded(this.words, n2 + 1);
    }

    private final void setAdd(int n) {
        this.setAdd(this, n);
    }

    private final void set(long l) {
        int n = (int)l;
        if ((long)n == l) {
            this.ival = n;
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = n;
            this.words[1] = (int)(l >> 32);
            this.ival = 2;
        }
    }

    private final void set(int[] nArray, int n) {
        this.ival = n;
        this.words = nArray;
    }

    private final void set(BigInteger bigInteger) {
        if (bigInteger.words == null) {
            this.set(bigInteger.ival);
        } else if (this != bigInteger) {
            this.realloc(bigInteger.ival);
            System.arraycopy(bigInteger.words, 0, this.words, 0, bigInteger.ival);
            this.ival = bigInteger.ival;
        }
    }

    private static final BigInteger add(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        BigInteger bigInteger3;
        if (bigInteger.words == null && bigInteger2.words == null) {
            return BigInteger.valueOf((long)n * (long)bigInteger2.ival + (long)bigInteger.ival);
        }
        if (n != 1) {
            bigInteger2 = n == -1 ? BigInteger.neg(bigInteger2) : BigInteger.times(bigInteger2, BigInteger.valueOf(n));
        }
        if (bigInteger.words == null) {
            return BigInteger.add(bigInteger2, bigInteger.ival);
        }
        if (bigInteger2.words == null) {
            return BigInteger.add(bigInteger, bigInteger2.ival);
        }
        if (bigInteger2.ival > bigInteger.ival) {
            bigInteger3 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger3;
        }
        bigInteger3 = BigInteger.alloc(bigInteger.ival + 1);
        int n2 = bigInteger2.ival;
        long l = MPN.add_n(bigInteger3.words, bigInteger.words, bigInteger2.words, n2);
        long l2 = bigInteger2.words[n2 - 1] < 0 ? 0xFFFFFFFFL : 0L;
        while (n2 < bigInteger.ival) {
            bigInteger3.words[n2] = (int)(l += ((long)bigInteger.words[n2] & 0xFFFFFFFFL) + l2);
            l >>>= 32;
            ++n2;
        }
        if (bigInteger.words[n2 - 1] < 0) {
            --l2;
        }
        bigInteger3.words[n2] = (int)(l + l2);
        bigInteger3.ival = n2 + 1;
        return bigInteger3.canonicalize();
    }

    public BigInteger add(BigInteger bigInteger) {
        return BigInteger.add(this, bigInteger, 1);
    }

    public BigInteger subtract(BigInteger bigInteger) {
        return BigInteger.add(this, bigInteger, -1);
    }

    private static final BigInteger times(BigInteger bigInteger, int n) {
        boolean bl;
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return bigInteger;
        }
        int[] nArray = bigInteger.words;
        int n2 = bigInteger.ival;
        if (nArray == null) {
            return BigInteger.valueOf((long)n2 * (long)n);
        }
        BigInteger bigInteger2 = BigInteger.alloc(n2 + 1);
        if (nArray[n2 - 1] < 0) {
            bl = true;
            BigInteger.negate(bigInteger2.words, nArray, n2);
            nArray = bigInteger2.words;
        } else {
            bl = false;
        }
        if (n < 0) {
            bl ^= true;
            n = -n;
        }
        bigInteger2.words[n2] = MPN.mul_1(bigInteger2.words, nArray, n2, n);
        bigInteger2.ival = n2 + 1;
        if (bl) {
            bigInteger2.setNegative();
        }
        return bigInteger2.canonicalize();
    }

    private static final BigInteger times(BigInteger bigInteger, BigInteger bigInteger2) {
        Object object;
        int[] nArray;
        int[] nArray2;
        if (bigInteger2.words == null) {
            return BigInteger.times(bigInteger, bigInteger2.ival);
        }
        if (bigInteger.words == null) {
            return BigInteger.times(bigInteger2, bigInteger.ival);
        }
        boolean bl = false;
        int n = bigInteger.ival;
        int n2 = bigInteger2.ival;
        if (bigInteger.isNegative()) {
            bl = true;
            nArray2 = new int[n];
            BigInteger.negate(nArray2, bigInteger.words, n);
        } else {
            bl = false;
            nArray2 = bigInteger.words;
        }
        if (bigInteger2.isNegative()) {
            bl ^= true;
            nArray = new int[n2];
            BigInteger.negate(nArray, bigInteger2.words, n2);
        } else {
            nArray = bigInteger2.words;
        }
        if (n < n2) {
            object = nArray2;
            nArray2 = nArray;
            nArray = object;
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        object = BigInteger.alloc(n + n2);
        MPN.mul(((BigInteger)object).words, nArray2, n, nArray, n2);
        ((BigInteger)object).ival = n + n2;
        if (bl) {
            super.setNegative();
        }
        return super.canonicalize();
    }

    public BigInteger multiply(BigInteger bigInteger) {
        return BigInteger.times(this, bigInteger);
    }

    private static final void divide(long l, long l2, BigInteger bigInteger, BigInteger bigInteger2, int n) {
        boolean bl;
        boolean bl2;
        if (l < 0L) {
            bl2 = true;
            if (l == Long.MIN_VALUE) {
                BigInteger.divide(BigInteger.valueOf(l), BigInteger.valueOf(l2), bigInteger, bigInteger2, n);
                return;
            }
            l = -l;
        } else {
            bl2 = false;
        }
        if (l2 < 0L) {
            bl = true;
            if (l2 == Long.MIN_VALUE) {
                if (n == 3) {
                    if (bigInteger != null) {
                        bigInteger.set(0L);
                    }
                    if (bigInteger2 != null) {
                        bigInteger2.set(l);
                    }
                } else {
                    BigInteger.divide(BigInteger.valueOf(l), BigInteger.valueOf(l2), bigInteger, bigInteger2, n);
                }
                return;
            }
            l2 = -l2;
        } else {
            bl = false;
        }
        long l3 = l / l2;
        long l4 = l % l2;
        boolean bl3 = bl2 ^ bl;
        boolean bl4 = false;
        if (l4 != 0L) {
            switch (n) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    boolean bl5 = false;
                    if (n == 1) {
                        bl5 = true;
                    }
                    if (bl3 != bl5) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    boolean bl6 = false;
                    if (l4 > l2 - (l3 & 1L) >> 1) {
                        bl6 = true;
                    }
                    bl4 = bl6;
                    break;
                }
            }
        }
        if (bigInteger != null) {
            if (bl4) {
                ++l3;
            }
            if (bl3) {
                l3 = -l3;
            }
            bigInteger.set(l3);
        }
        if (bigInteger2 != null) {
            if (bl4) {
                l4 = l2 - l4;
                bl2 ^= true;
            }
            if (bl2) {
                l4 = -l4;
            }
            bigInteger2.set(l4);
        }
    }

    private static final void divide(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n) {
        int n2;
        int n3;
        if (!(bigInteger.words != null && bigInteger.ival > 2 || bigInteger2.words != null && bigInteger2.ival > 2)) {
            long l = bigInteger.longValue();
            long l2 = bigInteger2.longValue();
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                BigInteger.divide(l, l2, bigInteger3, bigInteger4, n);
                return;
            }
        }
        boolean bl = bigInteger.isNegative();
        boolean bl2 = bigInteger2.isNegative();
        boolean bl3 = bl ^ bl2;
        int n4 = 1;
        if (bigInteger2.words != null) {
            n4 = bigInteger2.ival;
        }
        int n5 = n4;
        int[] nArray = new int[n5];
        bigInteger2.getAbsolute(nArray);
        while (n5 > 1 && nArray[n5 - 1] == 0) {
            --n5;
        }
        int n6 = 1;
        if (bigInteger.words != null) {
            n6 = bigInteger.ival;
        }
        int n7 = n6;
        int[] nArray2 = new int[n7 + 2];
        bigInteger.getAbsolute(nArray2);
        while (n7 > 1 && nArray2[n7 - 1] == 0) {
            --n7;
        }
        int n8 = MPN.cmp(nArray2, n7, nArray, n5);
        if (n8 < 0) {
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n3 = n7;
            n2 = 1;
            nArray2[0] = 0;
        } else if (n8 == 0) {
            nArray2[0] = 1;
            n2 = 1;
            nArray[0] = 0;
            n3 = 1;
        } else if (n5 == 1) {
            n2 = n7;
            if (nArray[0] == 1 && nArray2[n7 - 1] < 0) {
                ++n2;
            }
            n3 = 1;
            nArray[0] = MPN.divmod_1(nArray2, nArray2, n7, nArray[0]);
        } else {
            int n9;
            int n10 = MPN.count_leading_zeros(nArray[n5 - 1]);
            if (n10 != 0) {
                MPN.lshift(nArray, 0, nArray, n5, n10);
                n9 = MPN.lshift(nArray2, 0, nArray2, n7, n10);
                nArray2[n7++] = n9;
            }
            if (n7 == n5) {
                nArray2[n7++] = 0;
            }
            MPN.divide(nArray2, n7, nArray, n5);
            n3 = n5;
            MPN.rshift0(nArray, nArray2, 0, n3, n10);
            n2 = n7 + 1 - n5;
            if (bigInteger3 != null) {
                n9 = 0;
                while (n9 < n2) {
                    nArray2[n9] = nArray2[n9 + n5];
                    ++n9;
                }
            }
        }
        if (nArray[n3 - 1] < 0) {
            nArray[n3] = 0;
            ++n3;
        }
        boolean bl4 = false;
        if (n3 > 1 || nArray[0] != 0) {
            switch (n) {
                case 3: {
                    break;
                }
                case 1: 
                case 2: {
                    boolean bl5 = false;
                    if (n == 1) {
                        bl5 = true;
                    }
                    if (bl3 != bl5) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    BigInteger bigInteger5 = bigInteger4 == null ? new BigInteger() : bigInteger4;
                    bigInteger5.set(nArray, n3);
                    bigInteger5 = BigInteger.shift(bigInteger5, 1);
                    if (bl2) {
                        bigInteger5.setNegative();
                    }
                    int n11 = BigInteger.compareTo(bigInteger5, bigInteger2);
                    if (bl2) {
                        n11 = -n11;
                    }
                    boolean bl6 = false;
                    if (n11 != 1 && (n11 != 0 || (nArray2[0] & 1) == 0)) break;
                    bl6 = bl4 = true;
                }
            }
        }
        if (bigInteger3 != null) {
            bigInteger3.set(nArray2, n2);
            if (bl3) {
                if (bl4) {
                    bigInteger3.setInvert();
                } else {
                    bigInteger3.setNegative();
                }
            } else if (bl4) {
                bigInteger3.setAdd(1);
            }
        }
        if (bigInteger4 != null) {
            bigInteger4.set(nArray, n3);
            if (bl4) {
                BigInteger bigInteger6;
                if (bigInteger2.words == null) {
                    bigInteger6 = bigInteger4;
                    bigInteger6.set(bl2 ? nArray[0] + bigInteger2.ival : nArray[0] - bigInteger2.ival);
                } else {
                    bigInteger6 = BigInteger.add(bigInteger4, bigInteger2, bl2 ? 1 : -1);
                }
                if (bl) {
                    bigInteger4.setNegative(bigInteger6);
                } else {
                    bigInteger4.set(bigInteger6);
                }
            } else if (bl) {
                bigInteger4.setNegative();
            }
        }
    }

    public BigInteger divide(BigInteger bigInteger) {
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger.divide(this, bigInteger, bigInteger2, null, 3);
        return bigInteger2.canonicalize();
    }

    public BigInteger remainder(BigInteger bigInteger) {
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger.divide(this, bigInteger, null, bigInteger2, 3);
        return bigInteger2.canonicalize();
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        if (bigInteger.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{new BigInteger(), new BigInteger()};
        BigInteger.divide(this, bigInteger, bigIntegerArray[0], bigIntegerArray[1], 3);
        bigIntegerArray[0].canonicalize();
        bigIntegerArray[1].canonicalize();
        return bigIntegerArray;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.isNegative() || bigInteger.isZero()) {
            throw new ArithmeticException("non-positive modulus");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger.divide(this, bigInteger, null, bigInteger2, 1);
        return bigInteger2.canonicalize();
    }

    public BigInteger pow(int n) {
        if (n <= 0) {
            if (n == 0) {
                return ONE;
            }
            throw new ArithmeticException("negative exponent");
        }
        if (this.isZero()) {
            return this;
        }
        int n2 = 1;
        if (this.words != null) {
            n2 = this.ival;
        }
        int n3 = n2;
        int n4 = (this.bitLength() * n >> 5) + 2 * n3;
        boolean bl = false;
        if (this.isNegative() && (n & 1) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        this.getAbsolute(nArray);
        int n5 = 1;
        nArray2[0] = 1;
        block0: while (true) {
            int[] nArray4;
            if ((n & 1) != 0) {
                MPN.mul(nArray3, nArray, n3, nArray2, n5);
                nArray4 = nArray3;
                nArray3 = nArray2;
                nArray2 = nArray4;
                n5 += n3;
                while (nArray2[n5 - 1] == 0) {
                    --n5;
                }
            }
            if ((n >>= 1) == 0) break;
            MPN.mul(nArray3, nArray, n3, nArray, n3);
            nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
            n3 *= 2;
            while (true) {
                if (nArray[n3 - 1] != 0) continue block0;
                --n3;
            }
            break;
        }
        if (nArray2[n5 - 1] < 0) {
            ++n5;
        }
        if (bl2) {
            BigInteger.negate(nArray2, nArray2, n5);
        }
        return BigInteger.make(nArray2, n5);
    }

    private static final int[] euclidInv(int n, int n2, int n3) {
        if (n2 == 0) {
            throw new ArithmeticException("not invertible");
        }
        if (n2 == 1) {
            return new int[]{-n3, 1};
        }
        int[] nArray = BigInteger.euclidInv(n2, n % n2, n / n2);
        n = nArray[0];
        nArray[0] = n * -n3 + nArray[1];
        nArray[1] = n;
        return nArray;
    }

    private static final void euclidInv(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger[] bigIntegerArray) {
        Object object;
        if (bigInteger2.isZero()) {
            throw new ArithmeticException("not invertible");
        }
        if (bigInteger2.isOne()) {
            bigIntegerArray[0] = BigInteger.neg(bigInteger3);
            bigIntegerArray[1] = ONE;
            return;
        }
        if (bigInteger.words == null) {
            object = BigInteger.euclidInv(bigInteger2.ival, bigInteger.ival % bigInteger2.ival, bigInteger.ival / bigInteger2.ival);
            bigIntegerArray[0] = new BigInteger((int)object[0]);
            bigIntegerArray[1] = new BigInteger((int)object[1]);
        } else {
            object = new BigInteger();
            BigInteger bigInteger4 = new BigInteger();
            BigInteger.divide(bigInteger, bigInteger2, bigInteger4, (BigInteger)object, 1);
            super.canonicalize();
            bigInteger4.canonicalize();
            BigInteger.euclidInv(bigInteger2, (BigInteger)object, bigInteger4, bigIntegerArray);
        }
        object = bigIntegerArray[0];
        bigIntegerArray[0] = BigInteger.add(bigIntegerArray[1], BigInteger.times((BigInteger)object, bigInteger3), -1);
        bigIntegerArray[1] = object;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (bigInteger.isNegative() || bigInteger.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInteger.isOne()) {
            return ZERO;
        }
        if (this.isOne()) {
            return ONE;
        }
        BigInteger bigInteger2 = new BigInteger();
        int n = 0;
        if (bigInteger.words == null) {
            int n2 = bigInteger.ival;
            int n3 = this.words != null || this.isNegative() ? this.mod((BigInteger)bigInteger).ival : this.ival;
            if (n2 > n3) {
                int n4 = n3;
                n3 = n2;
                n2 = n4;
                n = 1;
            }
            bigInteger2.ival = BigInteger.euclidInv(n2, n3 % n2, n3 / n2)[1 - n];
            if (bigInteger2.ival < 0) {
                bigInteger2.ival += bigInteger.ival;
            }
        } else {
            BigInteger bigInteger3;
            BigInteger bigInteger4 = bigInteger3 = this.isNegative() ? this.mod(bigInteger) : this;
            if (bigInteger3.compareTo(bigInteger) < 0) {
                bigInteger2 = bigInteger3;
                bigInteger3 = bigInteger;
                bigInteger = bigInteger2;
                n = 1;
            }
            BigInteger bigInteger5 = new BigInteger();
            BigInteger bigInteger6 = new BigInteger();
            BigInteger.divide(bigInteger3, bigInteger, bigInteger6, bigInteger5, 1);
            bigInteger5.canonicalize();
            bigInteger6.canonicalize();
            BigInteger[] bigIntegerArray = new BigInteger[2];
            BigInteger.euclidInv(bigInteger, bigInteger5, bigInteger6, bigIntegerArray);
            BigInteger bigInteger7 = bigInteger2 = n != 0 ? bigIntegerArray[0] : bigIntegerArray[1];
            if (bigInteger2.isNegative()) {
                bigInteger2 = BigInteger.add(bigInteger2, n != 0 ? bigInteger3 : bigInteger, 1);
            }
        }
        return bigInteger2;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.isNegative() || bigInteger2.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInteger.isNegative()) {
            return this.modInverse(bigInteger2);
        }
        if (bigInteger.isOne()) {
            return this.mod(bigInteger2);
        }
        BigInteger bigInteger3 = ONE;
        BigInteger bigInteger4 = this;
        BigInteger bigInteger5 = bigInteger;
        while (!bigInteger5.isZero()) {
            if (bigInteger5.and(ONE).isOne()) {
                bigInteger3 = BigInteger.times(bigInteger3, bigInteger4).mod(bigInteger2);
            }
            bigInteger5 = bigInteger5.shiftRight(1);
            bigInteger4 = BigInteger.times(bigInteger4, bigInteger4).mod(bigInteger2);
        }
        return bigInteger3;
    }

    private static final int gcd(int n, int n2) {
        int n3;
        if (n2 > n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n2 != 0) {
            if (n2 == 1) {
                return n2;
            }
            n3 = n2;
            n2 = n % n2;
            n = n3;
        }
        return n;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        int n = this.ival;
        int n2 = bigInteger.ival;
        if (this.words == null) {
            if (n == 0) {
                return BigInteger.abs(bigInteger);
            }
            if (bigInteger.words == null && n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                if (n < 0) {
                    n = -n;
                }
                if (n2 < 0) {
                    n2 = -n2;
                }
                return BigInteger.valueOf(BigInteger.gcd(n, n2));
            }
            n = 1;
        }
        if (bigInteger.words == null) {
            if (n2 == 0) {
                return BigInteger.abs(this);
            }
            n2 = 1;
        }
        int n3 = (n > n2 ? n : n2) + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        this.getAbsolute(nArray);
        bigInteger.getAbsolute(nArray2);
        n3 = MPN.gcd(nArray, nArray2, n3);
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.ival = n3;
        bigInteger2.words = nArray;
        return bigInteger2.canonicalize();
    }

    public boolean isProbablePrime(int n) {
        if (n < 1) {
            return true;
        }
        BigInteger bigInteger = new BigInteger();
        int n2 = 0;
        while (n2 < primes.length) {
            if (this.words == null && this.ival == primes[n2]) {
                return true;
            }
            BigInteger.divide(this, smallFixNums[primes[n2] - -100], null, bigInteger, 3);
            if (bigInteger.canonicalize().isZero()) {
                return false;
            }
            ++n2;
        }
        BigInteger bigInteger2 = BigInteger.add(this, -1);
        int n3 = bigInteger2.getLowestSetBit();
        BigInteger bigInteger3 = bigInteger2.divide(BigInteger.valueOf((long)2 << n3 - 1));
        int n4 = this.bitLength();
        n2 = 0;
        while (n2 < k.length) {
            if (n4 <= k[n2]) break;
            ++n2;
        }
        int n5 = t[n2];
        if (n > 80) {
            n5 *= 2;
        }
        int n6 = 0;
        while (n6 < n5) {
            BigInteger bigInteger4 = smallFixNums[primes[n6] - -100].modPow(bigInteger3, this);
            if (!bigInteger4.isOne() && !bigInteger4.equals(bigInteger2)) {
                n2 = 0;
                while (n2 < n3) {
                    if (bigInteger4.isOne()) {
                        return false;
                    }
                    ++n2;
                    if (bigInteger4.equals(bigInteger2)) break;
                    bigInteger4 = bigInteger4.modPow(BigInteger.valueOf(2), this);
                }
                if (n2 == n3 && !bigInteger4.equals(bigInteger2)) {
                    return false;
                }
            }
            ++n6;
        }
        return true;
    }

    private final void setInvert() {
        if (this.words == null) {
            this.ival ^= 0xFFFFFFFF;
        } else {
            int n = this.ival;
            while (--n >= 0) {
                this.words[n] = ~this.words[n];
            }
        }
    }

    private final void setShiftLeft(BigInteger bigInteger, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (bigInteger.words == null) {
            if (n < 32) {
                this.set((long)bigInteger.ival << n);
                return;
            }
            nArray = new int[]{bigInteger.ival};
            n3 = 1;
        } else {
            nArray = bigInteger.words;
            n3 = bigInteger.ival;
        }
        int n4 = n >> 5;
        int n5 = n3 + n4;
        if ((n &= 0x1F) == 0) {
            this.realloc(n5);
            n2 = n3;
            while (--n2 >= 0) {
                this.words[n2 + n4] = nArray[n2];
            }
        } else {
            this.realloc(++n5);
            n2 = MPN.lshift(this.words, n4, nArray, n3, n);
            n = 32 - n;
            this.words[n5 - 1] = n2 << n >> n;
        }
        this.ival = n5;
        n2 = n4;
        while (--n2 >= 0) {
            this.words[n2] = 0;
        }
    }

    private final void setShiftRight(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            int n2;
            if (n < 32) {
                n2 = bigInteger.ival >> n;
            } else {
                int n3 = 0;
                if (bigInteger.ival < 0) {
                    n3 = 1;
                }
                n2 = 0 - n3;
            }
            this.set(n2);
        } else if (n == 0) {
            this.set(bigInteger);
        } else {
            int n4 = bigInteger.isNegative();
            int n5 = n >> 5;
            n &= 0x1F;
            int n6 = bigInteger.ival - n5;
            if (n6 <= 0) {
                this.set(0 - n4);
            } else {
                if (this.words == null || this.words.length < n6) {
                    this.realloc(n6);
                }
                MPN.rshift0(this.words, bigInteger.words, n5, n6, n);
                this.ival = n6;
                if (n4 != 0) {
                    int n7 = n6 - 1;
                    this.words[n7] = this.words[n7] | -2 << 31 - n;
                }
            }
        }
    }

    private final void setShift(BigInteger bigInteger, int n) {
        if (n > 0) {
            this.setShiftLeft(bigInteger, n);
        } else {
            this.setShiftRight(bigInteger, -n);
        }
    }

    private static final BigInteger shift(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            if (n <= 0) {
                int n2;
                if (n > -32) {
                    n2 = bigInteger.ival >> -n;
                } else {
                    int n3 = 0;
                    if (bigInteger.ival < 0) {
                        n3 = 1;
                    }
                    n2 = 0 - n3;
                }
                return BigInteger.valueOf(n2);
            }
            if (n < 32) {
                return BigInteger.valueOf((long)bigInteger.ival << n);
            }
        }
        if (n == 0) {
            return bigInteger;
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setShift(bigInteger, n);
        return bigInteger2.canonicalize();
    }

    public BigInteger shiftLeft(int n) {
        return BigInteger.shift(this, n);
    }

    public BigInteger shiftRight(int n) {
        return BigInteger.shift(this, -n);
    }

    private final void format(int n, StringBuffer stringBuffer) {
        if (this.words == null) {
            stringBuffer.append(Integer.toString(this.ival, n));
        } else if (this.ival <= 2) {
            stringBuffer.append(Long.toString(this.longValue(), n));
        } else {
            int[] nArray;
            boolean bl = this.isNegative();
            if (bl || n != 16) {
                nArray = new int[this.ival];
                this.getAbsolute(nArray);
            } else {
                nArray = this.words;
            }
            int n2 = this.ival;
            if (n == 16) {
                if (bl) {
                    stringBuffer.append('-');
                }
                int n3 = stringBuffer.length();
                int n4 = n2;
                while (--n4 >= 0) {
                    int n5 = nArray[n4];
                    int n6 = 8;
                    while (--n6 >= 0) {
                        int n7 = n5 >> 4 * n6 & 0xF;
                        if (n7 <= 0 && stringBuffer.length() <= n3) continue;
                        stringBuffer.append(Character.forDigit(n7, 16));
                    }
                }
            } else {
                int n8;
                int n9 = stringBuffer.length();
                do {
                    n8 = MPN.divmod_1(nArray, nArray, n2, n);
                    stringBuffer.append(Character.forDigit(n8, n));
                    while (n2 > 0 && nArray[n2 - 1] == 0) {
                        --n2;
                    }
                } while (n2 != 0);
                if (bl) {
                    stringBuffer.append('-');
                }
                n8 = stringBuffer.length() - 1;
                while (n9 < n8) {
                    char c = stringBuffer.charAt(n9);
                    stringBuffer.setCharAt(n9, stringBuffer.charAt(n8));
                    stringBuffer.setCharAt(n8, c);
                    ++n9;
                    --n8;
                }
            }
        }
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int n) {
        if (this.words == null) {
            return Integer.toString(this.ival, n);
        }
        if (this.ival <= 2) {
            return Long.toString(this.longValue(), n);
        }
        int n2 = this.ival * (MPN.chars_per_word(n) + 1);
        StringBuffer stringBuffer = new StringBuffer(n2);
        this.format(n, stringBuffer);
        return stringBuffer.toString();
    }

    public int intValue() {
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0];
    }

    public long longValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return this.words == null ? this.ival : this.words[0] + this.words[this.ival - 1];
    }

    private static final boolean equals(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.words == null && bigInteger2.words == null) {
            boolean bl = false;
            if (bigInteger.ival == bigInteger2.ival) {
                bl = true;
            }
            return bl;
        }
        if (bigInteger.words == null || bigInteger2.words == null || bigInteger.ival != bigInteger2.ival) {
            return false;
        }
        int n = bigInteger.ival;
        while (--n >= 0) {
            if (bigInteger.words[n] == bigInteger2.words[n]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInteger)) {
            return false;
        }
        return BigInteger.equals(this, (BigInteger)object);
    }

    private static final BigInteger valueOf(String string, int n) throws NumberFormatException {
        int n2 = string.length();
        if (n2 <= 15 && n <= 16) {
            return BigInteger.valueOf(Long.parseLong(string, n));
        }
        int n3 = 0;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c == '-') {
                bl = true;
            } else if (c != '_' && (n3 != 0 || c != ' ' && c != '\t')) {
                int n5 = Character.digit(c, n);
                if (n5 < 0) break;
                byArray[n3++] = (byte)n5;
            }
            ++n4;
        }
        return BigInteger.valueOf(byArray, n3, bl, n);
    }

    private static final BigInteger valueOf(byte[] byArray, int n, boolean bl, int n2) {
        int n3 = MPN.chars_per_word(n2);
        int[] nArray = new int[n / n3 + 1];
        int n4 = MPN.set_str(nArray, byArray, n, n2);
        if (n4 == 0) {
            return ZERO;
        }
        if (nArray[n4 - 1] < 0) {
            nArray[n4++] = 0;
        }
        if (bl) {
            BigInteger.negate(nArray, nArray, n4);
        }
        return BigInteger.make(nArray, n4);
    }

    public double doubleValue() {
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival <= 2) {
            return this.longValue();
        }
        if (this.isNegative()) {
            return BigInteger.neg(this).roundToDouble(0, true, false);
        }
        return this.roundToDouble(0, false, false);
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    private final boolean checkBits(int n) {
        if (n <= 0) {
            return false;
        }
        if (this.words == null) {
            boolean bl = false;
            if (n > 31 || (this.ival & (1 << n) - 1) != 0) {
                bl = true;
            }
            return bl;
        }
        int n2 = 0;
        while (n2 < n >> 5) {
            if (this.words[n2] != 0) {
                return true;
            }
            ++n2;
        }
        boolean bl = false;
        if ((n & 0x1F) != 0 && (this.words[n2] & (1 << (n & 0x1F)) - 1) != 0) {
            bl = true;
        }
        return bl;
    }

    private final double roundToDouble(int n, boolean bl, boolean bl2) {
        int n2 = this.bitLength();
        if ((n += n2 - 1) < -1075) {
            return bl ? -0.0 : 0.0;
        }
        if (n > 1023) {
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int n3 = n >= -1022 ? 53 : 53 + n + 1022;
        int n4 = n2 - (n3 + 1);
        long l = n4 > 0 ? (this.words == null ? (long)(this.ival >> n4) : MPN.rshift_long(this.words, this.ival, n4)) : this.longValue() << -n4;
        if (n == 1023 && l >> 1 == 0x1FFFFFFFFFFFFFL) {
            if (bl2 || this.checkBits(n2 - n3)) {
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return bl ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        if ((l & 1L) == 1L && ((l & (long)2) == (long)2 || bl2 || this.checkBits(n4))) {
            if (((l += (long)2) & 0x40000000000000L) != 0L) {
                ++n;
                l >>= 1;
            } else if (n3 == 52 && (l & 0x20000000000000L) != 0L) {
                ++n;
            }
        }
        long l2 = bl ? Long.MIN_VALUE : 0L;
        long l3 = (n += 1023) <= 0 ? 0L : (long)n << 52;
        long l4 = (l >>= 1) & 0xFFEFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2 | l3 | l4);
    }

    private final void getAbsolute(int[] nArray) {
        int n;
        int n2;
        if (this.words == null) {
            n2 = 1;
            nArray[0] = this.ival;
        } else {
            n = n2 = this.ival;
            while (--n >= 0) {
                nArray[n] = this.words[n];
            }
        }
        if (nArray[n2 - 1] < 0) {
            BigInteger.negate(nArray, nArray, n2);
        }
        n = nArray.length;
        while (--n > n2) {
            nArray[n] = 0;
        }
    }

    private static final boolean negate(int[] nArray, int[] nArray2, int n) {
        long l = 1L;
        boolean bl = false;
        if (nArray2[n - 1] < 0) {
            bl = true;
        }
        boolean bl2 = bl;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (int)(l += (long)(~nArray2[n2]) & 0xFFFFFFFFL);
            l >>= 32;
            ++n2;
        }
        boolean bl3 = false;
        if (bl2 && nArray[n - 1] < 0) {
            bl3 = true;
        }
        return bl3;
    }

    private final void setNegative(BigInteger bigInteger) {
        int n = bigInteger.ival;
        if (bigInteger.words == null) {
            if (n == Integer.MIN_VALUE) {
                this.set(-((long)n));
            } else {
                this.set(-n);
            }
            return;
        }
        this.realloc(n + 1);
        if (BigInteger.negate(this.words, bigInteger.words, n)) {
            this.words[n++] = 0;
        }
        this.ival = n;
    }

    private final void setNegative() {
        this.setNegative(this);
    }

    private static final BigInteger abs(BigInteger bigInteger) {
        return bigInteger.isNegative() ? BigInteger.neg(bigInteger) : bigInteger;
    }

    public BigInteger abs() {
        return BigInteger.abs(this);
    }

    private static final BigInteger neg(BigInteger bigInteger) {
        if (bigInteger.words == null && bigInteger.ival != Integer.MIN_VALUE) {
            return BigInteger.valueOf(-bigInteger.ival);
        }
        BigInteger bigInteger2 = new BigInteger(0);
        bigInteger2.setNegative(bigInteger);
        return bigInteger2.canonicalize();
    }

    public BigInteger negate() {
        return BigInteger.neg(this);
    }

    public int bitLength() {
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    public byte[] toByteArray() {
        int n;
        byte[] byArray = new byte[(this.bitLength() + 1 + 7) / 8];
        int n2 = byArray.length;
        int n3 = 0;
        while (n2 > 4) {
            n = this.words[n3++];
            int n4 = 4;
            while (n4 > 0) {
                byArray[--n2] = (byte)n;
                --n4;
                n >>= 8;
            }
        }
        n = this.words == null ? this.ival : this.words[n3];
        while (n2 > 0) {
            byArray[--n2] = (byte)n;
            n >>= 8;
        }
        return byArray;
    }

    private static final int swappedOp(int n) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(n);
    }

    private static final BigInteger bitOp(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        switch (n) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return bigInteger.and(bigInteger2);
            }
            case 3: {
                return bigInteger;
            }
            case 5: {
                return bigInteger2;
            }
            case 15: {
                return BigInteger.valueOf(-1);
            }
        }
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.setBitOp(bigInteger3, n, bigInteger, bigInteger2);
        return bigInteger3.canonicalize();
    }

    private static final void setBitOp(BigInteger bigInteger, int n, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bigInteger3.words != null && (bigInteger2.words == null || bigInteger2.ival < bigInteger3.ival)) {
            BigInteger bigInteger4 = bigInteger2;
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger4;
            n = BigInteger.swappedOp(n);
        }
        if (bigInteger3.words == null) {
            n6 = bigInteger3.ival;
            n5 = 1;
        } else {
            n6 = bigInteger3.words[0];
            n5 = bigInteger3.ival;
        }
        if (bigInteger2.words == null) {
            n4 = bigInteger2.ival;
            n3 = 1;
        } else {
            n4 = bigInteger2.words[0];
            n3 = bigInteger2.ival;
        }
        if (n3 > 1) {
            bigInteger.realloc(n3);
        }
        int[] nArray = bigInteger.words;
        int n7 = 0;
        int n8 = 0;
        block0 : switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                while (true) {
                    n2 = n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 2: {
                while (true) {
                    n2 = n4 & ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 3: {
                n2 = n4;
                n8 = 1;
                break;
            }
            case 4: {
                while (true) {
                    n2 = ~n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            case 5: {
                while (true) {
                    n2 = n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
            }
            case 6: {
                while (true) {
                    n2 = n4 ^ n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                int n9 = 0;
                if (n6 < 0) {
                    n9 = 1;
                }
                n8 = n9 + 1;
                break;
            }
            case 7: {
                while (true) {
                    n2 = n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 8: {
                while (true) {
                    n2 = ~(n4 | n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 9: {
                while (true) {
                    n2 = ~(n4 ^ n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                int n10 = 0;
                if (n6 >= 0) {
                    n10 = 1;
                }
                n8 = n10 + 1;
                break;
            }
            case 10: {
                while (true) {
                    n2 = ~n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
            }
            case 11: {
                while (true) {
                    n2 = n4 | ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 12: {
                n2 = ~n4;
                n8 = 2;
                break;
            }
            case 13: {
                while (true) {
                    n2 = ~n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 14: {
                while (true) {
                    n2 = ~(n4 & n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInteger2.words[n7];
                    n6 = bigInteger3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n7 + 1 == n3) {
            n8 = 0;
        }
        switch (n8) {
            case 0: {
                if (n7 == 0 && nArray == null) {
                    bigInteger.ival = n2;
                    return;
                }
                nArray[n7++] = n2;
                break;
            }
            case 1: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = bigInteger2.words[n7];
                }
                break;
            }
            case 2: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = ~bigInteger2.words[n7];
                }
                break;
            }
        }
        bigInteger.ival = n7;
    }

    private static final BigInteger and(BigInteger bigInteger, int n) {
        if (bigInteger.words == null) {
            return BigInteger.valueOf(bigInteger.ival & n);
        }
        if (n >= 0) {
            return BigInteger.valueOf(bigInteger.words[0] & n);
        }
        int n2 = bigInteger.ival;
        int[] nArray = new int[n2];
        nArray[0] = bigInteger.words[0] & n;
        while (--n2 > 0) {
            nArray[n2] = bigInteger.words[n2];
        }
        return BigInteger.make(nArray, bigInteger.ival);
    }

    public BigInteger and(BigInteger bigInteger) {
        if (bigInteger.words == null) {
            return BigInteger.and(this, bigInteger.ival);
        }
        if (this.words == null) {
            return BigInteger.and(bigInteger, this.ival);
        }
        BigInteger bigInteger2 = this;
        if (this.ival < bigInteger.ival) {
            BigInteger bigInteger3 = this;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger3;
        }
        int n = bigInteger.isNegative() ? bigInteger2.ival : bigInteger.ival;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < bigInteger.ival) {
            nArray[n2] = bigInteger2.words[n2] & bigInteger.words[n2];
            ++n2;
        }
        while (n2 < n) {
            nArray[n2] = bigInteger2.words[n2];
            ++n2;
        }
        return BigInteger.make(nArray, n);
    }

    public BigInteger or(BigInteger bigInteger) {
        return BigInteger.bitOp(7, this, bigInteger);
    }

    public BigInteger xor(BigInteger bigInteger) {
        return BigInteger.bitOp(6, this, bigInteger);
    }

    public BigInteger not() {
        return BigInteger.bitOp(12, this, ZERO);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        return this.and(bigInteger.not());
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n).not());
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.or(ONE.shiftLeft(n));
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n)).isZero() ^ true;
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.xor(ONE.shiftLeft(n));
    }

    public int getLowestSetBit() {
        if (this.isZero()) {
            return -1;
        }
        if (this.words == null) {
            return MPN.findLowestBit(this.ival);
        }
        return MPN.findLowestBit(this.words);
    }

    private static final int bitCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += bit4_count[n & 0xF];
            n >>>= 4;
        }
        return n2;
    }

    private static final int bitCount(int[] nArray, int n) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += BigInteger.bitCount(nArray[n]);
        }
        return n2;
    }

    public int bitCount() {
        int n;
        int n2;
        int[] nArray = this.words;
        if (nArray == null) {
            n2 = 1;
            n = BigInteger.bitCount(this.ival);
        } else {
            n2 = this.ival;
            n = BigInteger.bitCount(nArray, n2);
        }
        return this.isNegative() ? n2 * 32 - n : n;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.magnitude.length == 0 || this.signum == 0) {
            this.ival = 0;
            this.words = null;
        } else {
            int n = 0;
            if (this.signum < 0) {
                n = 1;
            }
            this.words = BigInteger.byteArrayToIntArray(this.magnitude, 0 - n);
            BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
            this.ival = bigInteger.ival;
            this.words = bigInteger.words;
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        this.signum = this.signum();
        this.magnitude = this.signum == 0 ? new byte[]{} : this.toByteArray();
        objectOutputStream.defaultWriteObject();
    }

    private final /* synthetic */ void this() {
        this.bitCount = -1;
        this.bitLength = -1;
        this.firstNonzeroByteNum = -2;
        this.lowestSetBit = -2;
    }

    private BigInteger() {
        this.this();
    }

    private BigInteger(int n) {
        this.this();
        this.ival = n;
    }

    public BigInteger(String string, int n) {
        this.this();
        BigInteger bigInteger = BigInteger.valueOf(string, n);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(byte[] byArray) {
        this.this();
        if (byArray == null || byArray.length < 1) {
            throw new NumberFormatException();
        }
        int n = 0;
        if (byArray[0] < 0) {
            n = 1;
        }
        this.words = BigInteger.byteArrayToIntArray(byArray, 0 - n);
        BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
    }

    public BigInteger(int n, byte[] byArray) {
        this.this();
        if (byArray == null || n > 1 || n < -1) {
            throw new NumberFormatException();
        }
        if (n == 0) {
            int n2 = byArray.length - 1;
            while (n2 >= 0 && byArray[n2] == 0) {
                --n2;
            }
            if (n2 >= 0) {
                throw new NumberFormatException();
            }
            return;
        }
        this.words = BigInteger.byteArrayToIntArray(byArray, 0);
        BigInteger bigInteger = BigInteger.make(this.words, this.words.length);
        this.ival = bigInteger.ival;
        this.words = bigInteger.words;
        if (n < 0) {
            this.setNegative();
        }
    }

    public BigInteger(int n, Random random) {
        this.this();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.init(n, random);
    }

    public BigInteger(int n, int n2, Random random) {
        this(n, random);
        while (!this.isProbablePrime(n2)) {
            this.init(n, random);
        }
        return;
    }

    static {
        int n = 1125;
        while (--n >= 0) {
            BigInteger.smallFixNums[n] = new BigInteger(n + -100);
        }
        ZERO = smallFixNums[100];
        ONE = smallFixNums[101];
        TEN = smallFixNums[110];
        primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251};
        k = new int[]{100, 150, 200, 250, 300, 350, 400, 500, 600, 800, 1250, Integer.MAX_VALUE};
        t = new int[]{27, 18, 15, 12, 9, 8, 7, 6, 5, 4, 3, 2};
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 3;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 3;
        byArray[12] = 2;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 4;
        bit4_count = byArray;
    }
}

